; Script generated by the HM NIS Edit Script Wizard and modified by Nasca Paul.

; HM NIS Edit Wizard helper defines
!define PRODUCT_NAME "ZynAddSubFX"
!define PRODUCT_VERSION "2.2.0"
!define PRODUCT_PUBLISHER "Nasca Octavian Paul"
!define PRODUCT_WEB_SITE "http://zynaddsubfx.sourceforge.net"
!define PRODUCT_DIR_REGKEY "Software\Microsoft\Windows\CurrentVersion\App Paths\zynaddsubfx.exe"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"

SetCompressor lzma

; MUI 1.67 compatible ------
!include "MUI.nsh"

; MUI Settings
!define MUI_ABORTWARNING
!define MUI_ICON "${NSISDIR}\Contrib\Graphics\Icons\modern-install.ico"
!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\modern-uninstall.ico"
/*
var VSTDIR ;

Function .onInit
;         StrCpy  "$INSTDIR" $VSTDIR
FunctionEnd
*/

; Welcome page
!insertmacro MUI_PAGE_WELCOME
; License page
!insertmacro MUI_PAGE_LICENSE "COPYING.txt"
; Components page
!insertmacro MUI_PAGE_COMPONENTS
; Directory page
!insertmacro MUI_PAGE_DIRECTORY
/*
;VST directory
PageEx directory
       DirVar $VSTDIR
PageExEnd
*/

; Instfiles page
!insertmacro MUI_PAGE_INSTFILES
; Finish page
!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!insertmacro MUI_UNPAGE_INSTFILES

; Language files
!insertmacro MUI_LANGUAGE "English"

; Reserve files
!insertmacro MUI_RESERVEFILE_INSTALLOPTIONS

; MUI end ------


Name "${PRODUCT_NAME} ${PRODUCT_VERSION}"
OutFile "Setup_ZynAddSubFX.exe"
InstallDir "$PROGRAMFILES\ZynAddSubFX"
InstallDirRegKey HKLM "${PRODUCT_DIR_REGKEY}" ""
;ShowInstDetails show
;ShowUnInstDetails show


Section "-Required" SEC01
  SetOutPath "$INSTDIR"
  SetOverwrite ifnewer
  File "README.txt"
  File "HISTORY.txt"
  File "FAQ.txt"
  File "COPYING.txt"
  File "ChangeLog.txt"
  File "bugs.txt"
;  File "Warning.txt"
  File "zynaddsubfx_icon.ico"
  File /r "banks"
  File /r "examples"
  File /r "presets"

  SetOutPath "$SYSDIR"
  File "pthreadGC1.dll"
SectionEnd

Section "Standalone" SEC02
  SetOutPath "$INSTDIR"
  File "zynaddsubfx.exe"
  File "launch_zynaddsubfx.bat"
  CreateDirectory "$SMPROGRAMS\ZynAddSubFX"
  CreateShortCut "$SMPROGRAMS\ZynAddSubFX\ZynAddSubFX low latency.lnk" "$INSTDIR\launch_zynaddsubfx.bat" "-Y" "$INSTDIR\zynaddsubfx_icon.ico" 
  CreateShortCut "$SMPROGRAMS\ZynAddSubFX\ZynAddSubFX.lnk" "$INSTDIR\zynaddsubfx.exe" "-Y" "$INSTDIR\zynaddsubfx_icon.ico"
  CreateShortCut "$DESKTOP\ZynAddSubFX.lnk" "$INSTDIR\launch_zynaddsubfx.bat" "-Y" "$INSTDIR\zynaddsubfx_icon.ico"
SectionEnd

;Section /o "VST Plugin" SEC03
;  SetOutPath "$INSTDIR\VST"
;  File "zynaddsubfx_vst.dll"
;SectionEnd

Section /o "Source Code" SEC04
  SetOutPath "$INSTDIR"
  File /r "source code"
SectionEnd

Section -AdditionalIcons
  WriteIniStr "$INSTDIR\${PRODUCT_NAME}.url" "InternetShortcut" "URL" "${PRODUCT_WEB_SITE}"
  CreateShortCut "$SMPROGRAMS\ZynAddSubFX\Website.lnk" "$INSTDIR\${PRODUCT_NAME}.url"

; sa sterg uninstall icon
  CreateShortCut "$SMPROGRAMS\ZynAddSubFX\Uninstall.lnk" "$INSTDIR\uninst.exe"
SectionEnd

Section -Post
  WriteUninstaller "$INSTDIR\uninst.exe"
  WriteRegStr HKLM "${PRODUCT_DIR_REGKEY}" "" "$INSTDIR\zynaddsubfx.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayIcon" "$INSTDIR\zynaddsubfx.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "URLInfoAbout" "${PRODUCT_WEB_SITE}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "Publisher" "${PRODUCT_PUBLISHER}"
SectionEnd

; Section descriptions
!insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC01} "Required files for ZynAddSubFX "
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC02} "ZynAddSubFX as a standalone synth"
;  !insertmacro MUI_DESCRIPTION_TEXT ${SEC03} "ZynAddSubFX as a VST plugin (not stable on every host)"
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC04} "Full source code of ZynAddSubFX"
!insertmacro MUI_FUNCTION_DESCRIPTION_END


Function un.onUninstSuccess
  HideWindow
  MessageBox MB_ICONINFORMATION|MB_OK "$(^Name) was successfully removed from your computer."
FunctionEnd

Function un.onInit
  MessageBox MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2 "Are you sure you want to completely remove $(^Name) and all of its components? $\r (INCLUDING THE USER-MADE INSTRUMENTS,ETC !!!)" IDYES +2
  Abort
FunctionEnd

Section Uninstall
  Delete "$INSTDIR\README.txt"
  Delete "$INSTDIR\HISTORY.txt"
  Delete "$INSTDIR\FAQ.txt"
  Delete "$INSTDIR\COPYING.txt"
  Delete "$INSTDIR\ChangeLog.txt"
  Delete "$INSTDIR\bugs.txt"
  Delete "$INSTDIR\Warning.txt"
  Delete "$INSTDIR\zynaddsubfx.exe"
  Delete "$INSTDIR\zynaddsubfx.url"
  Delete "$INSTDIR\launch_zynaddsubfx.bat"
  Delete "$INSTDIR\zynaddsubfxXML.cfg"
  Delete "$INSTDIR\uninst.exe"
  Delete "$INSTDIR\zynaddsubfx.ico"
  Delete "$INSTDIR\zynaddsubfx_icon.ico"
  RMDir /r "$INSTDIR\banks"
  RMDir /r "$INSTDIR\examples"
  RMDir /r "$INSTDIR\presets"
  RMDir /r "$INSTDIR\source code"
  RMDir /r "$INSTDIR\VST"

  Delete "$SMPROGRAMS\ZynAddSubFX\Uninstall.lnk"
  Delete "$SMPROGRAMS\ZynAddSubFX\Website.lnk"
  Delete "$STARTMENU.lnk"
  Delete "$DESKTOP\ZynAddSubFX.lnk"
  Delete "$SMPROGRAMS\ZynAddSubFX\ZynAddSubFX.lnk"
  Delete "$SMPROGRAMS\ZynAddSubFX\ZynAddSubFX low latency.lnk"

  RMDir "$SMPROGRAMS\ZynAddSubFX"
  RMDir "$INSTDIR"
  RMDir ""

  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"
  DeleteRegKey HKLM "${PRODUCT_DIR_REGKEY}"
  SetAutoClose true
SectionEnd
