"""Psyco optimisation of zope
"""

__author__ = 'Geoff Dave, Christian Heimes'

import sys, os

try:
    dummy = True
except NameError:
    True = 1
    False = 0

try:
    import psyco
    psyco_installed = 1
except ImportError:
    psyco_installed = 0

def optimise(profile=False):
    if not psyco_installed:
        return False

    if profile:
        ihome = os.environ.get('INSTANCE_HOME', None)
        if ihome:
            logfile = os.path.join(ihome, 'var', 'psyco.log')
        else:
            home = sys.modules[__name__].__path__
            logfile = os.path.join(home, 'psyco.log')
        psyco.log(logfile)
        psyco.profile()
    
    import TAL.TALInterpreter
    psyco.bind(TAL.TALInterpreter.TALInterpreter.interpret)
    psyco.bind(TAL.TALInterpreter.TALInterpreter.do_startTag)
    psyco.bind(TAL.TALInterpreter.TALInterpreter.do_startEndTag)    
    #psyco.bind(TAL.TALInterpreter.TALInterpreter.attrAction_tal)
    #psyco.bind(TAL.TALInterpreter.TALInterpreter.do_rawtextBeginScope_tal)
    #psyco.bind(TAL.TALInterpreter.TALInterpreter.no_tag)
    psyco.bind(TAL.TALInterpreter.TALInterpreter.do_condition)
    #psyco.bind(TAL.TALInterpreter.TALInterpreter.attrAction)
    psyco.bind(TAL.TALInterpreter.TALInterpreter.do_optTag_tal)
    psyco.bind(TAL.TALInterpreter.TALInterpreter.__call__)
    psyco.bind(TAL.TALInterpreter.TALInterpreter.do_useMacro)
    psyco.bind(TAL.TALInterpreter.TALInterpreter.do_defineSlot)
    psyco.bind(TAL.TALInterpreter.TALInterpreter.do_defineMacro)           
    psyco.bind(TAL.TALInterpreter.TALInterpreter.do_setLocal_tal)
    #psyco.bind(TAL.TALInterpreter.TALInterpreter.do_rawtextColumn)
    psyco.bind(TAL.TALInterpreter.TALInterpreter.do_endScope)
    psyco.bind(TAL.TALInterpreter.TALInterpreter.do_beginScope_tal)
    
    import Products.PageTemplates.Expressions
    psyco.bind(Products.PageTemplates.Expressions.restrictedTraverse)
    psyco.bind(Products.PageTemplates.Expressions.PathExpr._eval)
    psyco.bind(Products.PageTemplates.Expressions.PathExpr.__call__)
    psyco.bind(Products.PageTemplates.Expressions.render)
    import Products.PageTemplates.TALES
    psyco.bind(Products.PageTemplates.TALES.Context.evaluate)
    
    try:
        # the following methods cannot be bound with zope 2.7
        import AccessControl.ZopeGuards
        psyco.bind(AccessControl.ZopeGuards.guarded_getattr)
        import AccessControl.ZopeSecurityPolicy
        psyco.bind(AccessControl.ZopeSecurityPolicy.ZopeSecurityPolicy.validate)
        import AccessControl.SecurityManager
        psyco.bind(AccessControl.SecurityManager.SecurityManager.validate)
    except TypeError:
        pass

    # class
    try:
        import Products.PlacelessTranslationService.msgfmt
        psyco.bind(Products.PlacelessTranslationService.msgfmt.Msgfmt)
    except ImportError:
        pass
    
    # class
    try:
        import DateTime.DateTime.DateTime
    except ImportError:
        import DateTime.DateTime
        psyco.bind(DateTime.DateTime)
    else:
        psyco.bind(DateTime.DateTime.DateTime)

    # Bindings
    import Shared.DC.Scripts.Bindings
    psyco.bind(Shared.DC.Scripts.Bindings.Bindings._bindAndExec)
    
    #import ZServer.medusa.thread.select_trigger
    # class
    #psyco.bind(ZServer.medusa.thread.select_trigger.trigger)
    # class
    #psyco.bind(ZServer.medusa.thread.select_trigger.trigger_file)
    
    # getSecurityManager
    
    return True
