# Configuration options

PATCH_CMF = True  # Enable speedup of the CMF's skin resolution mechanism

USE_PSYCO = True  # Enable use of psyco 
                  # Note that psyco is automatically disabled in development mode

# SpeedPack caches (1) the contents of the skin directories, and (2) whether or
# not a particular attribute is provided by a skin.  The cache provides a big
# speedup in development mode, especially for Windows machines.  However, the
# cache will become outdated if you (1) delete a skin file, (2) add a new skin 
# file, or (3) move a skin file. 
# 
# You can refresh the cache manually by clicking the Reload tab in the skins
# tool in the ZMI.  Alternatively, you can set the cache to time out so that it
# will automatically refresh itself.  

SPEEDPACK_CACHE_TTL = 2.0 # Time in seconds to cache skin resolution info
# Small value (e.g. 2.0): slower, but you won't need to refresh the cache when you add/delete/move files
# Large value (e.g. 3600.0): faster, but you'll need to refresh the cache yourself when you add/delete/move files