from Products.CMFCore.utils import getToolByName

def install(self):
    return '\n'.join(_migrateToSkinsCustomFolder(self))

def uninstall(self):
    return '\n'.join(_migrateToFolder(self))


def _migrateToSkinsCustomFolder(portal):
    ps = getToolByName(portal, "portal_skins")
    old_type = ['Folder']
    migrated_add = ps.manage_addProduct['SpeedPack'].manage_addSkinsCustomFolder
    return _migrate(ps, old_type, migrated_add)

def _migrateToFolder(portal):
    ps = getToolByName(portal, "portal_skins")
    old_type = ['Skin Custom Folder']
    migrated_add = ps.manage_addProduct['OFSP'].manage_addFolder
    return _migrate(ps, old_type, migrated_add)

def _migrate(ps, old_type, migrated_add, out=[]):
    """Replaces all Folder objects with Skin Custom Folder
    """
    for old_folder in ps.objectValues(old_type):
        id = old_folder.getId()[:]
        title = old_folder.title
        
        # create a safe migration id
        migrate_id = id[:]
        while hasattr(ps, migrate_id):
            migrate_id += 'x_'

        # create new folder
        migrated_add(migrate_id)
        migrate_folder = getattr(ps, migrate_id)
        migrate_folder.title = title

        # copy all objects to the new folder
        for obj in old_folder.objectValues():
            migrate_folder.manage_clone(obj, obj.getId())

        # remove the old folder and rename new folder to the id of the old folder
        ps.manage_delObjects([id])
        # submit a sub transaction to assign a correct _p_jar to the migrated object
        # without a valid _p_jar it can't be renamed
        get_transaction().commit(1)
        ps.manage_renameObject(migrate_id, id)
        out.append('Migrated portal_skin/%s' % id)
    return out
