# -*- coding: UTF-8 -*-
# -*- Mode: Python; py-indent-offset: 4 -*-
# Author: Nik Kim <fafhrd@legco.biz>
__version__ = '$Revision: 1.12 $'[11:-2]

import traceback
from Globals import package_home
from Products.Archetypes.public import process_types, listTypes
import Products.CMFCore.utils as cmfcore_utils
from Products.CMFCore.DirectoryView import registerDirectory
from Products.CMFCore.utils import getToolByName
from Products.CMFCore.CMFCorePermissions import ManagePortal

from config import SKINS_DIR, GLOBALS, PROJECTNAME
from config import ADD_CONTENT_PERMISSION

import MailTransport, MailSpool, MailTemplatesTool, SubscriptionsTool
import Workflows

tools = (MailSpool.MailSpool, MailTransport.MailTransport,
         MailTemplatesTool.MailTemplatesTool,
         SubscriptionsTool.SubscriptionsTool,
         )

registerDirectory(SKINS_DIR, GLOBALS)

import traceback, templates

def initialize(context):
    import MailCategory, MailTemplate, \
           SubscriptionInfoAnonymous, SubscriptionInfoMember
    
    content_types, constructors, ftis = process_types(
        listTypes(PROJECTNAME),
        PROJECTNAME)

    cmfcore_utils.ContentInit(
        PROJECTNAME + ' Content',
        content_types      = content_types,
        permission         = ADD_CONTENT_PERMISSION,
        extra_constructors = constructors,
        fti                = ftis,
        ).initialize(context)

    cmfcore_utils.ToolInit(
        PROJECTNAME + ' Tools'
        , tools = tools
        , product_name = PROJECTNAME
        , icon='tool.gif'
        ).initialize(context)


from AccessControl import ModuleSecurityInfo, allow_module

ModuleSecurityInfo('Products.PortalTransport.utils').declareProtected(
    ManagePortal, 'change_email_for_member')
ModuleSecurityInfo('Products.PortalTransport.utils').declareProtected(
    ManagePortal, 'check_member_email')
allow_module('Products.PortalTransport.utils')
