# -*- coding: UTF-8 -*-
# -*- Mode: Python; py-indent-offset: 4 -*-
# Authors: Nik Kim <fafhrd@legco.biz> 
__version__ = '$Revision: 1.2 $'[11:-2]

import re, traceback
from Globals import InitializeClass
from DateTime import DateTime
from Acquisition import aq_base, aq_inner, aq_parent
from AccessControl import ClassSecurityInfo
from Products.CMFCore.utils import getToolByName
from Products.CMFCore.WorkflowCore import ObjectDeleted
from Products.Archetypes.public import *
from Products.Archetypes.config import TOOL_NAME
from Products.Archetypes.interfaces.referenceable import IReferenceable
from email.Utils import formataddr

from config import *
from utils import make_uuid
from SubscriptionInfoBase import BaseSubscriptionInfo

schema = BaseSchema + Schema((
    StringField('text_format', default='plain',
                widget=SelectionWidget(label='Message format',
                                       label_msgid='label_text_format',
                                       description_msgid='help_text_format',
                                       i18n_domain='PortalTransport')),
    ))


def addPT_SIMember(self, oid, uid, content, member, **kw):
    ob = PT_SIMember(oid, uid, content, member, **kw)
    return self._setObject(oid, ob)

class PT_SIMember(BaseSubscriptionInfo):
    """ class for manage single subscription """
    security = ClassSecurityInfo()

    schema = schema

    def __init__(self, oid, uid, content, member, text_format='plain', hint=''):
        BaseSubscriptionInfo.__init__(self, oid, uid, content, hint, text_format=text_format)

        self.member_id = member.getMemberId()

    security.declarePublic('isAutoActivate')
    def isAutoActivate(self):
        """ """
        return self.getSubscribedContent().isAutoActivateSubscription()

    def _getInfo(self, content):
        mtool = getToolByName(self, 'portal_membership')
        member = mtool.getMemberById(self.member_id)

        return {'email': member.getProperty('email'),
                'fullname': member.getProperty('fullname'),
                'member': member,
                }

    def getEmail(self):
	""" """
        mtool = getToolByName(self, 'portal_membership')
        member = mtool.getMemberById(self.member_id)

        return formataddr((member.getProperty('fullname'),
                           member.getProperty('email')))

    security.declareProtected(ModifyPortalContent, 'unsubscribe')
    def unsubscribe(self):
        """ """
        content = self.getSubscribedContent()

        try:
            self.wm_deactivate()
        except ObjectDeleted:
            pass

        return content

registerType(PT_SIMember)
