# -*- coding: UTF-8 -*-
# -*- Mode: Python; py-indent-offset: 4 -*-
# Author: Nik Kim <fafhrd@legco.biz>
__version__ = '$Revision: 1.7 $'[11:-2]

from OFS.Folder import Folder
from Globals import InitializeClass
from Acquisition import aq_parent, aq_inner, aq_base
from AccessControl import ClassSecurityInfo
from Products.CMFCore.CMFCorePermissions import View, ManagePortal
from Products.CMFCore.utils import UniqueObject
from Products.PageTemplates.PageTemplateFile import PageTemplateFile

import MailCategory
from config import PROJECTNAME

class MailTemplatesTool(UniqueObject, Folder):
    """ """

    security = ClassSecurityInfo()

    id = 'portal_mailtemplates'
    title = 'Manage portal e-mail templates'
    meta_type= 'PortalTransport Mail Templates'

    manage_options = ( Folder.manage_options +
                       ({'label':'Overview', 'action':'manage_overview' },) )

    security.declareProtected( ManagePortal, 'manage_overview' )
    manage_overview = PageTemplateFile('zpt/manage_overview', globals())

    security.declareProtected(ManagePortal, 'createCategory')
    def createCategory(self, id, title='', fields=[], REQUEST=None):
        """ """
        if not hasattr(aq_base(self), id):
            self.manage_addProduct[PROJECTNAME].manage_addContent(id, 'PT_MailCategory')
            ob = getattr(self, id)
            ob.title = title
            ob.fields = fields
        else:
            ob = getattr(self, id)

        if REQUEST is not None:
            return REQUEST.RESPONSE.redirect(
                '%s/prefs_mailtemplates?portal_status_message=Category added.'%(
                aq_parent(aq_inner(self)).absolute_url()))

        return ob

    def getTemplate(self, category, template):
        return getattr(getattr(self, category), template)

    security.declareProtected(View, 'createMessage')
    def createMessage(self, category, template, info, headers, charset=None,
                      text_format='plain', files=[]):
        """ """
        template = getattr(getattr(self, category), template)
        return template.getMessage(info, headers, charset, text_format, files)

    security.declareProtected(View, 'createMultipartMessage')
    def createMultipartMessage(self, category, template, info, headers, charset=None,
                               text_format='plain', messages=(), files=(),
                               multipart_format='alternative'):
        """ """
        template = getattr(getattr(self, category), template)
        return template.getMultipartMessage(
            info, headers, charset, text_format, messages, files, multipart_format)

    security.declareProtected(View, 'hasTemplate')
    def hasTemplate(self, category, template):
        """ """
        return hasattr(getattr(self, category, None), template)


InitializeClass( MailTemplatesTool )
