# -*- coding: UTF-8 -*-
# Author: Nikolay Kim <fafhrd@legco.biz>

from Globals import InitializeClass
from AccessControl import ClassSecurityInfo
from Products.CMFCore import CMFCorePermissions
from Products.CMFCore.utils import getToolByName
from Products.CMFCore.CMFCorePermissions import View, ModifyPortalContent
from Products.DCWorkflow.Scripts import Scripts
from Products.Archetypes.public import *

schema = BaseSchema + Schema((
    LinesField('fields', required=1,
               write_permission=ModifyPortalContent,
               widget=LinesWidget(label='Available Fields',
                                  label_msgid='label_available_fields',
                                  description_msgid='help_available_fields',
                                  i18n_domain='PortalMailTemplates')),
    TextField('description', required=0,
              write_permission=ModifyPortalContent,
              widget=TextAreaWidget(label_msgid='label_description',
                                    description_msgid='help_description',
                                    i18n_domain='plone')),
    ))


class PT_MailCategory(BaseFolder):
    """ """
    security = ClassSecurityInfo()

    schema = schema

    global_allow = 0
    filter_content_types = 1
    allowed_content_types = ['PT_MailTemplate']

    manage_options = ( (BaseFolder.manage_options[0],
                        {'label': 'Scripts', 'action': 'scripts/manage_main'},) +
                       BaseFolder.manage_options[1:])

    actions = (
        { 'id': 'view',
          'name': 'View',
          'action': 'string:$object_url/mailcategory_view',
          'permissions': (View,)
          },
        )

    def __init__(self, oid, **kwargs):
        BaseFolder.__init__(self, oid, **kwargs)
        self.scripts = Scripts('scripts')
        self.scripts.meta_type = 'MailTemplates Scripts'

    def getTemplate(self, id=None):
        template = None
        if id:
            # get specified template
            template = self[id]
        else:
            templates = self.objectIds()
            if len(templates) == 1:
                # if only one template, get it
                template = self[templates[0]]
            else:
                # if multiple template, get the default
                for t in templates:
                    if self[t].isDefault():
                        template = self[t]
                        break

        if not template:
            raise KeyError('No mail template for mail category %s' % self.getTitle())

        return template

    security.declarePublic('getFieldList')
    def getFieldList(self):
        fieldlist = []
        for f in self.fields:
            i = f.find(':')
            if i != -1:
                fieldlist.append((f[:i], f[(i+1):]))
        return fieldlist


registerType( PT_MailCategory )
