#include "cPersistence.h"

#define cPersistenceImported \
	(cPersistenceCAPI=PyCObject_Import("cPersistence","CAPI"))

#define Per_getattr (cPersistenceCAPI->pergetattro)
#define Per_setattr (cPersistenceCAPI->persetattro)
#define ASSIGN(V,E) {PyObject *__e; __e=(E); Py_XDECREF(V); (V)=__e;}
#define UNLESS(E) if(!(E))

static PyObject *__get_attr__, *__set_attr__, *__del_attr__;

static struct PyMethodDef dpMethods[] = { {NULL,NULL} };

static PyObject*
getattro_hook(PyObject *self, PyObject *name) {

	PyObject *r, *v, *tb;

	if (r = Py_FindAttr(self,name)) return r;	/* Found it first try */

	PyErr_Fetch(&r,&v,&tb);

	if (r && (r != PyExc_AttributeError)) {
		PyErr_Restore(r,v,tb);
		return NULL;
	}

	Py_XDECREF(r); Py_XDECREF(v); v=NULL; Py_XDECREF(tb);
	PyErr_Clear();

	if ((r = Py_FindAttr(self,__get_attr__)) && (v = PyTuple_New(1))) {
		PyTuple_SET_ITEM(v, 0, name);
		ASSIGN(r,PyObject_CallObject(r,v));
		PyTuple_SET_ITEM(v, 0, NULL);
		Py_DECREF(v);
		if (r && has__of__(r)) ASSIGN(r,PyObject_CallMethod(r,"__of__","O",self))
		return r;
	} else { Py_XDECREF(r); return NULL; }
}

static PyObject*
p_getattro(cPersistentObject *self, PyObject *name)
{
  char *s=NULL;

  if (PyString_Check(name))
    UNLESS(s=PyString_AsString(name)) return NULL;

  return Per_getattr((PyObject *)self, name, s, getattro_hook);
}































static int
p_setattro(cPersistentObject *self, PyObject *oname, PyObject *val)
{
	char *name; PyObject *r, *t;

	UNLESS(oname) return -1;
	if(PyString_Check(oname))
		UNLESS(name=PyString_AsString(oname)) return -1;
        
	if(*name=='_' && (name[1]=='p' || name[1]=='v')&& name[2]=='_')
		return Per_setattr((PyObject *)self,oname, val, 
			PyExtensionClassCAPI->setattro);

	if (!val) {
		if ((r = Py_FindAttr((PyObject *)self,__del_attr__))
			&& (t = PyTuple_New(1)))
		{
			PyTuple_SET_ITEM(t, 0, oname);
			ASSIGN(r,PyObject_CallObject(r,t));
			PyTuple_SET_ITEM(t, 0, NULL);
			Py_DECREF(t);
			if (r) { Py_DECREF(r); return 0; }
		}
	}

	else if ((r = Py_FindAttr((PyObject *)self,__set_attr__))
			&& (t = PyTuple_New(2)))
	{
		PyTuple_SET_ITEM(t, 0, oname);
		PyTuple_SET_ITEM(t, 1, val);
		ASSIGN(r,PyObject_CallObject(r,t));
		PyTuple_SET_ITEM(t, 0, NULL);
		PyTuple_SET_ITEM(t, 1, NULL);
		Py_DECREF(t);
		if (r) { Py_DECREF(r); return 0; }
	}

	Py_XDECREF(r); return -1;
}


void
initDynPersist()
{
	PyObject *m, *d;

	PURE_MIXIN_CLASS(DynPersist,
		"cPersistence.Persistent subclass supporting __getattr__",
		dpMethods);

	DynPersistType.tp_getattro = (getattrofunc) p_getattro;
	DynPersistType.tp_setattro = (setattrofunc) p_setattro;

	UNLESS(ExtensionClassImported) return;
	UNLESS(cPersistenceImported) return;

	/* Make up a type */


	m = Py_InitModule4(
		"DynPersist", 
		dpMethods, 	/* hack, use it since it's empty... */
		"Persistent's with __getattr__!", 
		(PyObject*)NULL, 
		PYTHON_API_VERSION
	);

	__get_attr__ = PyString_InternFromString("__get_attr__");
	__set_attr__ = PyString_InternFromString("__set_attr__");
	__del_attr__ = PyString_InternFromString("__del_attr__");

	d = PyModule_GetDict(m);

	PyDict_SetItemString(d,"__version__", PyString_FromString("0.2"));

	PyExtensionClass_Export(d,"DynPersist",DynPersistType);

	if (PyErr_Occurred())
		Py_FatalError("can't initialize module PersistWithGetattr");
}
