from Providers import ProviderGroup, ProviderContainer
from Products.PlugIns import PlugInContainer, unifiedZClassRegistry
from Globals import HTMLFile, default__class_init__, PersistentMapping
from OFS.Folder import Folder
from ComputedAttribute import ComputedAttribute
from AttributeProviders import AttributeProvider
from SheetProviders import SheetProvider
from ExtensionClass import Base
import Products

try:
    from thread import get_ident
except:
    def get_ident(): pass

_marker = []

class DataManager(ProviderContainer, PlugInContainer):

    """Something which provides objects with data"""

    def _objectChanging(self,client):
        for ob in self._getRegistry('provides').get('handlers',()):
            ob.__of__(self)._objectChanging(client)

    def _objectCreating(self,client):
        for ob in self._uniqueProviders(('attributes','sheets','handlers')):
            ob._objectCreating(client)

    def _objectAdding(self,client):
        for ob in self._uniqueProviders(('attributes','sheets','handlers')):
            ob._objectAdding(client)

    def _objectDeleting(self,client):
        for ob in self._uniqueProviders(('handlers','sheets','attributes')):
            ob._objectDeleting(client)





    def _getDataManagerFor(self,client,default=None):
        return self.aq_inner

    def _readableSlotFor(self,client):
        slot = client.__dict__.get('__skinSlot__',_marker)

        if slot is _marker: return {}

        client._setSlot(slot); return slot

    def _writeableSlotFor(self,client):
        slot = client.__dict__.get('__skinSlot__',_marker)

        if slot is _marker:
            slot = client.__dict__['__skinSlot__'] = PersistentMapping()
            client._p_changed = 1

        client._setSlot(slot); return slot























    def _zclassOK(self, z):
        """Verify that the ZClass selected is acceptable for this DataManager"""
        # All we check here is rack-mountability/dataskinnishness
        return getattr(z._zclass_,'_isRackMountable',0)


    def _unifiedZClassRegistry(self):
        """Return a sanely unified registry of ZClasses and ZClass bases"""

        return unifiedZClassRegistry(self, self._zclassOK)


    def manage_product_zclass_info(self):
        """Return a list of ZClasses suitable for use in this DataManager"""

        return map(lambda x, sel=self._isSelected: {
                'name':x[1][0],
                'path':x[0],
                'meta_type': x[1][1]._zclass_.meta_type,
                'selected': sel(x[1][0],x[0],x[1][1]) and 'selected' or '',
            }, 
            self._unifiedZClassRegistry().items()
        )

    def _isSelected(self,name,path,klass): pass

    __ac_permissions__ = (
        ('View management screens',
            ('manage_product_zclass_info',),
        ),
    )

default__class_init__(DataManager)








_nullDMs = {}

class DefaultDataManager(Base):

    """Thing that returns a canonical NullDataManager for each thread"""
    
    def __of__(self,parent):
    
        id  = get_ident()
        NDM = _nullDMs.get(id)
        
        if NDM is None:
            NDM = _nullDMs[id] = NullDataManager(id='_DefaultDataManager')
            
        return NDM.__of__(parent)
    

class NullDataManager(DataManager):

    """DataManager that emulates ordinary Zope reality"""

    def _objectDeleting(self,client): pass
    def _objectChanging(self,client): pass
    def _objectCreating(self,client): pass
    def _objectAdding(self,client):   pass

    def _getProvidersFor(self,client,kind,names): return ()
    def _uniqueProviders(self,kinds): return ()
