#
# Tests Zope's CopySupport
#

import os, sys
if __name__ == '__main__':
    execfile(os.path.join(sys.path[0], 'framework.py'))

from Testing import ZopeTestCase


# We can only paste an object that is properly installed/registered. 
# That's why we monkey patch an existing class instead of making our own.

def __init(self, file, __name__=''):
    self.count = 0
    self.afterAdd = 0
    self.afterClone = 0
    self.beforeDelete = 0
    self._old__init__(file, __name__=__name__)
def manage_afterAdd(self, item, container):
    self.afterAdd = self.count
    self.count = self.count + 1
    return self._old_manage_afterAdd(item, container)
def manage_afterClone(self, item):
    self.afterClone = self.count
    self.count = self.count + 1
    return self._old_manage_afterClone(item)
def manage_beforeDelete(self, item, container):
    self.beforeDelete = self.count
    self.count = self.count + 1
    return self._old_manage_beforeDelete(item, container)
def order(self):
    return self.afterAdd, self.afterClone, self.beforeDelete

from OFS.DTMLMethod import DTMLMethod
DTMLMethod._old_manage_afterAdd = DTMLMethod.manage_afterAdd
DTMLMethod.manage_afterAdd = manage_afterAdd
DTMLMethod._old_manage_afterClone = DTMLMethod.manage_afterClone
DTMLMethod.manage_afterClone = manage_afterClone
DTMLMethod._old_manage_beforeDelete = DTMLMethod.manage_beforeDelete
DTMLMethod.manage_beforeDelete = manage_beforeDelete
DTMLMethod._old__init__ = DTMLMethod.__init__
DTMLMethod.__init__ = __init
DTMLMethod.order = order


copymove_perms = ['Copy or Move', 'View management screens',
                  'Add Documents, Images, and Files', 'Delete objects']



class TestCopySupport(ZopeTestCase.ZopeTestCase):
    '''Tests the order in which the add/clone/del hooks are called'''

    def afterSetUp(self):
        self.setPermissions(copymove_perms)
        self.folder.manage_addFolder('subfolder')
        self.subfolder = self.folder['subfolder']
        self.folder.manage_addProduct['OFSP'].manage_addDTMLMethod('myob')
        self.folder.myob.afterAdd = 0   # reset
        get_transaction().commit(1)     # need a _p_jar

    def test_1_Clone(self):
        '''Test clone'''
        #print self.folder.myob.order()
        self.subfolder.manage_clone(self.folder.myob, 'yourob')
        #print self.subfolder.yourob.order()
        assert self.subfolder.yourob.order() == (1, 2, 0)   # add, clone

    def test_2_CopyPaste(self):
        '''Test copy/paste'''
        cb = self.folder.manage_copyObjects(['myob'])
        #print self.folder.myob.order()
        self.subfolder.manage_pasteObjects(cb)
        #print self.subfolder.myob.order()
        assert self.subfolder.myob.order() == (1, 2, 0)     # add, clone

    def test_3_CutPaste(self):
        '''Test cut/paste'''
        cb = self.folder.manage_cutObjects(['myob'])
        #print self.folder.myob.order()
        self.subfolder.manage_pasteObjects(cb)
        #print self.subfolder.myob.order()
        assert self.subfolder.myob.order() == (2, 0, 1)     # del, add

    def test_4_Rename(self):
        '''Test rename'''
        #print self.folder.myob.order()
        self.folder.manage_renameObject('myob', 'yourob')
        #print self.subfolder.yourob.order()
        assert self.subfolder.yourob.order() == (2, 0, 1)   # del, add

    # Remember to test COPY() which calls manage_afterClone()
    # *before* _setObject()

    def test_5_COPY(self):
        '''Test webdav COPY'''
        #print self.folder.myob.order()
        req = self.app.REQUEST
        req.environ['HTTP_DEPTH'] = 'infinity'
        req.environ['HTTP_DESTINATION'] = 'http://dummy.org/%s/subfolder/myob' % ZopeTestCase.folder_name
        self.folder.myob.COPY(req, req.RESPONSE)
        #print self.subfolder.myob.order()
        assert self.subfolder.myob.order() == (2, 1, 0)     # clone, add
            


def test_suite():
    from unittest import TestSuite, makeSuite
    suite = TestSuite()
    suite.addTest(makeSuite(TestCopySupport))
    return suite

if __name__ == '__main__':
    framework()

