# -*- coding: UTF-8 -*-
# Authors: Jean-mat Grimaldi <jean-mat@macadames.com> 
"""
"""
import Globals
from Globals import package_home
try:
    from Products.CMFCore.permissions import View, ManagePortal
except ImportError: # For instances with old CMF products
    from Products.CMFCore.CMFCorePermissions import View, ManagePortal

from utils import fckDefaultToolbar

GLOBALS = globals()

PROJECTNAME = "FCKeditor"
SKINS_DIR = 'skins'

fckeditor_properties = (
    ('allow_link_byuid', 'boolean', 1),
    ('allow_relative_links', 'boolean', 1),
    ('allow_latin_entities', 'boolean', 0),
    ('force_paste_as_text', 'boolean', 0),
    ('gecko_use_span', 'boolean', 1),
    ('spellchecker', 'string', 'ieSpell'),
    ('fck_force_width', 'string', ''),
    ('fck_force_height', 'string', ''),
    ('fck_toolbar', 'string', 'ZopeCmf'),
    ('fck_custom_toolbar', 'text', fckDefaultToolbar()),
    ('allow_server_browsing', 'boolean', 1),
    ('allow_file_upload', 'boolean', 1),
    ('allow_image_upload', 'boolean', 1),
    ('allow_flash_upload', 'boolean', 1),
    ('file_portal_type', 'string', 'File'),
    ('image_portal_type', 'string', 'Image'),
    ('flash_portal_type', 'string', 'File'),
    ('pa_meta_types', 'lines', ['PloneArticle','MyPloneArticleType']),
    ('fck_area_style', 'string', ''),
    ('fck_force_path', 'boolean', 0), # force path to personal member folder
    ('fck_force_other_path', 'string', ''), # force path to other folder
    ('fck_force_root', 'boolean', 0),  # force browser root to personal member folder
    ('fck_force_other_root', 'string', ''), # force root to other folder
    ('fck_default_skin', 'string', 'default'),
    ('fck_menu_styles', 'text', '<Style name="Image on Left" element="img">\n\t<Attribute name="class" value="img_left" />\n</Style>\n<Style name="Image on Right" element="img">\n\t<Attribute name="class" value="img_right" />\n</Style>\n<Style name="Image on Top" element="img">\n\t<Attribute name="class" value="img_top" />\n</Style>\n<Style name="Link Plain" element="a">\n\t<Attribute name="class" value="link-plain" />\n</Style>\n<Style name="Custom Ruler" element="hr">\n\t<Attribute name="size" value="1" />\n\t<Attribute name="color" value="#ff0000" />\n</Style>'),
    ('fck_default_r2l', 'boolean', 0), # default edition from right to left
    ('fck_unpublished_states', 'lines', ['visible','pending','rejected', 'waitreview']), # states wich need to be hidden even when user have permission view
    ('fck_unpublished_view_roles', 'lines', ['Manager','Reviewer','Owner', 'Contributor']), # roles allowed to view unpublished contents
    )

memberData_properties = (
    ('fck_skin', 'string', ''), # member can change fckeditor skin not set by default
    ('fck_path', 'string', ''), # member can choose browser opening path if path is not forced
    ('fck_root', 'string', ''), # member can choose browser root if root is not forced
    )


fckeditor_configlet = {
    'id': 'fckeditor_configlet',
    'appId': 'FCKeditor',
    'name': 'FCKeditor configuration',
    'action': 'string:$portal_url/prefs_fckeditor_form',
    'category': 'Products',
    'permission': (ManagePortal,),
    'imageUrl': 'fckPlone_icon.gif',
    }

fckeditor_member_prefs = {
    'id': 'fckeditor_member_prefs',
    'appId': 'FCKeditor',
    'name': 'FCKeditor preferences',
    'action': 'string:$portal_url/prefs_fckeditor_member',
    'condition': 'not:object/portal_membership/isAnonymousUser',
    'permission': ('View',),
    'category': 'Member',
    'imageUrl': 'fckPlone_icon.gif',
    }




