# jean-mat @ macadames.com

from AccessControl import ClassSecurityInfo
from Products.Archetypes.Widget import TextAreaWidget, StringWidget
from Products.Archetypes.Registry import registerWidget
 


class MiniVisualWidget(TextAreaWidget):
    _properties = TextAreaWidget._properties.copy()
    _properties.update({
        'macro' : "widget_mini_visual",
        'rows'  : 8,      #rows of TextArea if FCKeditor is not available
        'cols'  : 60,      #same for cols
        'width' : '90%', #width of FCK frame (if FCKeditor is available)
        'height': '300px', #same for height
        'format': 0,
        'append_only': False, #creates a textarea you can only add to, not edit
        'divider': '\n\n<hr />\n\n', # default divider for append only divider
        })

    security = ClassSecurityInfo()


class BrowseFilesWidget(StringWidget):
    _properties = StringWidget._properties.copy()
    _properties.update({
        'macro' : "widget_browse_files",
        'size' : '30',
        'maxlength' : '255',
        'helper_js': ('browse_files.js',),
        })

    security = ClassSecurityInfo()


registerWidget(MiniVisualWidget,
               title='MiniVisual',
               description='Renders a HTML mini visual editing',
               used_for=('Products.Archetypes.Field.StringField',)
               )


registerWidget(BrowseFilesWidget,
               title='BrowseFiles',
               description='Renders a text input with a browse server link',
               used_for=('Products.Archetypes.Field.StringField',)
               )
