############################################################################
#                                                                          #
#             copyright (c) 2004 ITB, Humboldt-University Berlin           #
#             written by: Raphael Ritz, r.ritz@biologie.hu-berlin.de       #
#                                                                          #
############################################################################

"""XMLParser (MODS) class"""

# Python stuff
import re, os

# Zope stuff
from Globals import InitializeClass
from App.Dialogs import MessageDialog

# Bibliography stuff
from Products.CMFBibliographyAT.tool.parsers.base \
     import IBibliographyParser, BibliographyParser

try:
    import _bibtex
    from Products.CMFBibliographyAT.tool.parsers.pyblbibtex \
         import PyBlBibtexParser as BaseParser
except ImportError:
    from Products.CMFBibliographyAT.tool.parsers.bibtex \
         import BibtexParser as BaseParser


class XMLParser(BaseParser):
    """
    specific parser to process input in XML(MODS)-format
    """

    __implements__ = (IBibliographyParser,)

    meta_type = "XML (MODS) Parser"

    format = {'name':'XML (MODS)',
              'extension':'xml'}

    def __init__(self,
                 id = 'xml_mods',
                 title = "XML(MODS) parser"
                 ):
        """
        initializes including the regular expression patterns
        """
        BaseParser.__init__(self, id=id, title=title)   

    # Here we need to provide 'checkFormat' and 'preprocess'

    def checkFormat(self, source):
        """
        is this my format?
        """
        teststring = source[:200].lower()
        ai = teststring.find('www.loc.gov/mods')
        ei = teststring.find('modsCollection')
        if ai + ei > -2:
            return 1
        else:
            return 0

    def preprocess(self, source):
        """
        convert XML to BibTeX
        """
        # open a pipe
        (fi, fo, fe) = os.popen3('xml2bib ', 't')
        # provide the input
        fi.write(source)
        fi.close()
        # get the output
        bibtex = fo.read()
        fo.close()
        # get the staus/error message
        # (this isn't used but we don't want it in the output)
        error = fe.read()
        fe.close()
        # done
        return bibtex

    # all the rest we inherit from our parent BibTeX(!) parser

 # Class instanciation
InitializeClass(XMLParser)

   
def manage_addXMLParser(self, REQUEST=None):
    """ """
    try:
        self._setObject('xml_mods', XMLParser())
    except:
        return MessageDialog(
            title='Bibliography tool warning message',
            message='The parser you attempted to add already exists.',
            action='manage_main')    
    return self.manage_main(self, REQUEST)
