<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en-US"
      lang="en-US"
      metal:use-macro="here/main_template/macros/master"
      i18n:domain="plone">
<body>

  <div metal:fill-slot="main"
       tal:define="global props python:container.portal_properties;
                   Iterator python:modules['Products.CMFPlone'].IndexIterator;
                   tabindex python:Iterator();">

    <h1 i18n:translate="heading_pubref_import">Import Bibliographic Entries</h1>

    <p i18n:translate="description_pubref_import"> 
      Enter the name of your source file or click <strong>browse</strong>
      to get a file dialog box to select it. Then specify the format from
      the drop-down list. Start by clicking
      <span i18n:name="import"><strong i18n:translate="">import</strong></span>.
    </p>
    

    <form class="group"
          name="import"
          enctype="multipart/form-data" 
          action="import"
          method="post">

      <fieldset>

        <legend i18n:translate="legend_source_file">Source File</legend>

          <div class="field">
            <label for="file" i18n:translate="label_file">File</label>

            <div class="formHelp" i18n:translate="help_bibliography_file_import">
              Select the file to be imported by clicking the 'Browse' button.
            </div>

            <input type="file"
                   id="file"
                   name="file"
                   size="30"
                   tabindex=""
                   tal:attributes="tabindex tabindex/next" />

            <span i18n:translate="no_file_imported"
                  tal:define="file_size python:here.getObjSize(here)"
                  tal:condition="not: file_size">
              (No file has been imported yet)
            </span>
          </div>

        <div class="field">
          <label i18n:translate="label_bibliography_import_format">Import Format</label>

          <div class="formHelp" i18n:translate="help_bibliography_import_format">
            Please select the format for the source file.
          </div>

          <select name="format" size="1"
                  tal:attributes="tabindex tabindex/next;">
            <option tal:repeat="value here/portal_bibliography/getImportFormatNames"
                    tal:content="python:value"
                    tal:attributes="value value"> dummy format
            </option>
          </select>
        </div>

        <div class="formControls">
          <input class="context"
                 tabindex=""
                 type="submit"
                 name="submit"
                 value="Import File"
                 i18n:attributes="value"
                 tal:attributes="tabindex tabindex/next;" />
        </div>

      </fieldset>
    
    </form>

  </div>

</body>

</html>
