##########################################################################
#                                                                        #
#           copyright (c) 2003 ITB, Humboldt-University Berlin           #
#           written by: Raphael Ritz, r.ritz@biologie.hu-berlin.de       #
#                                                                        #
##########################################################################

"""Inbook reference main class"""

from AccessControl import ClassSecurityInfo
from Products.CMFCore.permissions import View
from Products.Archetypes.public import registerType
from Products.Archetypes.public import Schema
from Products.Archetypes.public import StringField, BooleanField
from Products.Archetypes.public import StringWidget, BooleanWidget

from Products.CMFBibliographyAT.content.base import BaseEntry
from Products.CMFBibliographyAT.content.schemata \
    import HeaderSchema, AuthorSchema, CoreSchema, TrailingSchema
from Products.CMFBibliographyAT.content.fields \
    import booktitleField, editorField, publisherField, addressField, \
           editionField, seriesField, chapterField, pagesField


SourceSchema = Schema((
    booktitleField,
    editorField,
    publisherField,
    addressField,
    editionField,
    seriesField,
    chapterField,
    pagesField,
    ))

InbookSchema = HeaderSchema + AuthorSchema + CoreSchema +  \
               SourceSchema + TrailingSchema


class InbookReference(BaseEntry):
    """ content type to make reference to a part/chapter within a book.
    """
    security = ClassSecurityInfo()
    archetype_name = "Inbook Reference"
    source_fields = ('booktitle', 'editor', 'publisher', 'address', 'edition', 'series', 'chapter', 'pages')

    schema = InbookSchema
    
    security.declareProtected(View, 'Source')
    def Source(self):
        """ the default 'in book' source format
        """
        try:
            return self.InbookSource()
        except AttributeError:
            context = self
            booktitle = context.getBooktitle()
            editor    = context.getEditor()
            publisher = context.getPublisher()
            address   = context.getAddress()
            chapter   = context.getChapter()
            pages     = context.getPages()
            
            source = "In: %s" % booktitle
            
            if editor: source += ", edited by %s" % editor
            if publisher: source += '. ' + publisher
            if address: source += ', ' + address
            if chapter: source += ", chapter %s" % chapter
            if pages: source += ", pages %s" % pages
            
            return source + '.'


registerType(InbookReference)
