from interfaces import *

class Service:
    __implements__ = (ivalidationService,)

    def __init__(self):
        self._validator = {}

    def validate(self, name, value, *args, **kwargs):
        v = self.validatorFor(name)
        return v(value, *args, **kwargs)

    __call__ = validate

    def validatorFor(self, name):
        return self._validator[name]

    def register(self, validator):
        self._validator[validator.name] = validator

    def items(self):
        return self._validator.items()

    def keys(self):
        return [k for k, v in self.items()]

    def values(self):
        return [v for k, v in self.items()]

    def unregister(self, name):
        if self._validator.has_key(name):
            del self._validator[name]
