package ONVIF::PTZ::Types::Fault;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://schemas.xmlsoap.org/soap/envelope/' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %faultcode_of :ATTR(:get<faultcode>);
my %faultstring_of :ATTR(:get<faultstring>);
my %faultactor_of :ATTR(:get<faultactor>);
my %detail_of :ATTR(:get<detail>);

__PACKAGE__->_factory(
    [ qw(        faultcode
        faultstring
        faultactor
        detail

    ) ],
    {
        'faultcode' => \%faultcode_of,
        'faultstring' => \%faultstring_of,
        'faultactor' => \%faultactor_of,
        'detail' => \%detail_of,
    },
    {
        'faultcode' => 'SOAP::WSDL::XSD::Typelib::Builtin::QName',
        'faultstring' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'faultactor' => 'SOAP::WSDL::XSD::Typelib::Builtin::anyURI',
        'detail' => 'ONVIF::PTZ::Types::detail',
    },
    {

        'faultcode' => 'faultcode',
        'faultstring' => 'faultstring',
        'faultactor' => 'faultactor',
        'detail' => 'detail',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::PTZ::Types::Fault

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
Fault from the namespace http://schemas.xmlsoap.org/soap/envelope/.

Fault reporting structure 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * faultcode


=item * faultstring


=item * faultactor


=item * detail




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::PTZ::Types::Fault
   faultcode =>  $some_value, # QName
   faultstring =>  $some_value, # string
   faultactor =>  $some_value, # anyURI
   detail =>  { # ONVIF::PTZ::Types::detail
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

