
package WSNotification::Elements::NotificationProducerRP;
use strict;
use warnings;

{ # BLOCK to scope variables

sub get_xmlns { 'http://docs.oasis-open.org/wsn/b-2' }

__PACKAGE__->__set_name('NotificationProducerRP');
__PACKAGE__->__set_nillable();
__PACKAGE__->__set_minOccurs();
__PACKAGE__->__set_maxOccurs();
__PACKAGE__->__set_ref();

use base qw(
    SOAP::WSDL::XSD::Typelib::Element
    SOAP::WSDL::XSD::Typelib::ComplexType
);

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %TopicExpression_of :ATTR(:get<TopicExpression>);
my %FixedTopicSet_of :ATTR(:get<FixedTopicSet>);
my %TopicExpressionDialect_of :ATTR(:get<TopicExpressionDialect>);
my %TopicSet_of :ATTR(:get<TopicSet>);

__PACKAGE__->_factory(
    [ qw(        TopicExpression
        FixedTopicSet
        TopicExpressionDialect
        TopicSet

    ) ],
    {
        'TopicExpression' => \%TopicExpression_of,
        'FixedTopicSet' => \%FixedTopicSet_of,
        'TopicExpressionDialect' => \%TopicExpressionDialect_of,
        'TopicSet' => \%TopicSet_of,
    },
    {
        'TopicExpression' => 'WSNotification::Elements::TopicExpression',

        'FixedTopicSet' => 'WSNotification::Elements::FixedTopicSet',

        'TopicExpressionDialect' => 'WSNotification::Elements::TopicExpressionDialect',

        'TopicSet' => 'WSNotification::Elements::TopicSet',

    },
    {

        'TopicExpression' => '',
        'FixedTopicSet' => '',
        'TopicExpressionDialect' => '',
        'TopicSet' => '',
    }
);

} # end BLOCK







} # end of BLOCK



1;


=pod

=head1 NAME

WSNotification::Elements::NotificationProducerRP

=head1 DESCRIPTION

Perl data type class for the XML Schema defined element
NotificationProducerRP from the namespace http://docs.oasis-open.org/wsn/b-2.







=head1 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * TopicExpression

 $element->set_TopicExpression($data);
 $element->get_TopicExpression();


Note: The name of this property has been altered, because it didn't match
perl's notion of variable/subroutine names. The altered name is used in
perl code only, XML output uses the original name:

 



=item * FixedTopicSet

 $element->set_FixedTopicSet($data);
 $element->get_FixedTopicSet();


Note: The name of this property has been altered, because it didn't match
perl's notion of variable/subroutine names. The altered name is used in
perl code only, XML output uses the original name:

 



=item * TopicExpressionDialect

 $element->set_TopicExpressionDialect($data);
 $element->get_TopicExpressionDialect();


Note: The name of this property has been altered, because it didn't match
perl's notion of variable/subroutine names. The altered name is used in
perl code only, XML output uses the original name:

 



=item * TopicSet

 $element->set_TopicSet($data);
 $element->get_TopicSet();


Note: The name of this property has been altered, because it didn't match
perl's notion of variable/subroutine names. The altered name is used in
perl code only, XML output uses the original name:

 




=back


=head1 METHODS

=head2 new

 my $element = WSNotification::Elements::NotificationProducerRP->new($data);

Constructor. The following data structure may be passed to new():

 {
   TopicExpression =>  { # WSNotification::Types::TopicExpressionType
   },
   FixedTopicSet =>  $some_value, # boolean
   TopicExpressionDialect =>  $some_value, # anyURI
   TopicSet =>  { # WSNotification::Types::TopicSetType
   },
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=cut

