/*      Copyright (C) 2001, 2002, 2003, 2004 Stijn van Dongen
 *
 * This file is part of Zoem. You can redistribute and/or modify Zoem under the
 * terms of the GNU General Public License;  either version 2 of the License or
 * (at your option) any later  version.  You should have received a copy of the
 * GPL along with Zoem, in the file COPYING.
*/

#ifndef zoem_sink_h__
#define zoem_sink_h__

#include "filter.h"

#include "util/io.h"
#include "util/ting.h"
#include "util.h"

typedef struct
{  filter*     fd
;  yamStack*   envStack
;  yamStack*   xmlStack
;  char*       fname
;
}  sink    ;

void sinkSetDefault
(  sink*    sd
,  int      fltidx
)  ;

sink* sinkGetDefault
(  void
)  ;

yamStack* currentEnvStack
(  void
)  ;

yamStack* currentXmlStack
(  void
)  ;

void sinkStackPush
(  sink* sd
)  ;

void sinkStackPop
(  void
)  ;

sink* sinkNew
(  mcxIO* xf
)  ;

void sinkFree
(  sink* filed
)  ;

mcxIO* yamOutputNew
(  const char*  fname
)  ;

void yamOutputClose
(  const char*  fname
)  ;

void mod_sink_init
(  int   n
)  ;

void mod_sink_exit
(  void
)  ;

mcxTing* sinkGetDefaultName
(  void
)  ;

#endif

