package Zim::Repository::Man;

use strict;
use File::Spec;
use Zim::Repository;
use Zim::Page;

our $VERSION = 0.02;
our @ISA     = 'Zim::Repository';

my $null = File::Spec->devnull;

=head1 NAME

Zim::Repository::Man - Man page repository for zim

=head1 DESCRIPTION

This module can be used to read man pages in L<zim>.

It derives from L<Zim::Repository>.

=head1 METHODS

=over 4

=item C<list_pages(NAMESPACE)>

TODO

=cut

sub list_pages {
}

=item C<page_exists(NAME)>

=cut

sub page_exists {
	my ($self, $page) = @_;
	$page =~ s/(^:*$self->{namespace}:*)//g;
	my $pref = $1;
	$page =~ s/:+$//;
	open MAN, "man -w $page 2> $null |";
	$_ = join '', <MAN>;
	close MAN;
	return /\S/ ? $page : ($page =~ /[A-Z]/)
		? $self->page_exists($pref.lc($page)) : undef ;
}

=item C<load_page(NAME)>

Load a page object corresponding to a man page.

=cut

sub load_page {
	my ($self, $name) = @_;
	
	$name = $self->page_exists($name);
	return unless defined $name;
	
	$ENV{MANWIDTH} = 80; # FIXME get window size (via Env ?)
	open MAN, "man -c $name |" or die "Could not open pipe to man(1)\n";
	my ($block, @data);
	while (<MAN>) {
		# FIXME implement parsing algo like in Zim.pm
		# include bold and head2
		#s/((\S\cH\S)+)/<b>$1<\/b>/g;
		chomp;
		s/.\cH//g;
		if (/^[A-Z]+[A-Z\s]*$/) { # heading
			push @data, $block if length $block;
			push @data, ['head1', {}, $_];
			$block = "\n";
		}
		elsif (/\b\w+\(\w\)/) { # links
			# FIXME namespace links per man section
			push @data, $block if length $block;
			while (s/(.*?)\b(([\w\.\-]+)\(\w+\))//) {
				push @data, $1 if length($1);
				push @data, ['link', {to => $3}, $2];
			}
			$block = $_ . "\n";
		}
		else { $block .= $_ . "\n" }
	}
	push @data, $block if length $block;
	close MAN;
	
	my $page = Zim::Page->new($self, $self->{namespace}.':'.$name);
	$page->push_blocks(@data);
	return $page;
}

=item C<save_page()>

=item C<move_page()>

=item C<delete_page()>

These methods do nothing. Man pages are read-only.

=cut

sub save_page   { return }

sub move_page   { return }

sub delete_page { return }

=item C<resolve_page(NAME)>

TODO

=cut

sub resolve_page { return $_[1] }

1;

__END__

=back

=head1 AUTHOR

Jaap Karssenberg (Pardus) E<lt>pardus@cpan.orgE<gt>

Copyright (c) 2005 Jaap G Karssenberg. All rights reserved.
This program is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

=head1 SEE ALSO

L<Zim::Repository>

=cut

