/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.AlreadyRegisteredException;
import Ice.Communicator;
import Ice.ObjectAdapter;
import Ice.ObjectAdapterDeactivatedException;
import Ice.ObjectAdapterI;
import Ice.ObjectPrx;
import Ice.RouterPrx;
import IceInternal.Instance;
import IceUtil.Assert;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public final class ObjectAdapterFactory {
    private Instance _instance;
    private Communicator _communicator;
    private HashMap _adapters = new HashMap();
    private boolean _waitForShutdown;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        ObjectAdapter[] adapters;
        ObjectAdapterFactory objectAdapterFactory = this;
        synchronized (objectAdapterFactory) {
            if (this._instance == null) {
                return;
            }
            adapters = this._adapters.values().toArray(new ObjectAdapter[0]);
            this._instance = null;
            this._communicator = null;
            this.notifyAll();
        }
        for (int i = 0; i < adapters.length; ++i) {
            adapters[i].deactivate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForShutdown() {
        ObjectAdapterFactory objectAdapterFactory = this;
        synchronized (objectAdapterFactory) {
            while (this._instance != null) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {}
            }
            while (this._waitForShutdown) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {}
            }
            this._waitForShutdown = true;
        }
        if (this._adapters != null) {
            Iterator i = this._adapters.values().iterator();
            while (i.hasNext()) {
                ObjectAdapter adapter = (ObjectAdapter)i.next();
                adapter.waitForDeactivate();
            }
            this._adapters = null;
        }
        objectAdapterFactory = this;
        synchronized (objectAdapterFactory) {
            this._waitForShutdown = false;
            this.notifyAll();
        }
    }

    public synchronized ObjectAdapter createObjectAdapter(String name, String endpoints, RouterPrx router) {
        if (this._instance == null) {
            throw new ObjectAdapterDeactivatedException();
        }
        ObjectAdapter adapter = (ObjectAdapter)this._adapters.get(name);
        if (adapter != null) {
            throw new AlreadyRegisteredException("object adapter", name);
        }
        adapter = new ObjectAdapterI(this._instance, this._communicator, this, name, endpoints, router);
        this._adapters.put(name, adapter);
        return adapter;
    }

    public synchronized ObjectAdapter findObjectAdapter(ObjectPrx proxy) {
        if (this._instance == null) {
            return null;
        }
        Iterator i = this._adapters.values().iterator();
        while (i.hasNext()) {
            ObjectAdapterI adapter = (ObjectAdapterI)i.next();
            try {
                if (!adapter.isLocal(proxy)) continue;
                return adapter;
            }
            catch (ObjectAdapterDeactivatedException ex) {
            }
        }
        return null;
    }

    public synchronized void removeObjectAdapter(String name) {
        if (this._waitForShutdown) {
            return;
        }
        this._adapters.remove(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushBatchRequests() {
        LinkedList a = new LinkedList();
        ObjectAdapterFactory objectAdapterFactory = this;
        synchronized (objectAdapterFactory) {
            Iterator i = this._adapters.values().iterator();
            while (i.hasNext()) {
                a.add(i.next());
            }
        }
        Iterator p = a.iterator();
        while (p.hasNext()) {
            ((ObjectAdapterI)p.next()).flushBatchRequests();
        }
    }

    ObjectAdapterFactory(Instance instance, Communicator communicator) {
        this._instance = instance;
        this._communicator = communicator;
        this._waitForShutdown = false;
    }

    protected synchronized void finalize() throws Throwable {
        Assert.FinalizerAssert(this._instance == null);
        Assert.FinalizerAssert(this._communicator == null);
        Assert.FinalizerAssert(this._adapters == null);
        Assert.FinalizerAssert(!this._waitForShutdown);
        super.finalize();
    }
}

