/*
 * Decompiled with CFR 0.152.
 */
package IceSSL;

import Ice.Logger;
import Ice.SocketException;
import Ice.TimeoutException;
import IceInternal.Acceptor;
import IceInternal.Network;
import IceInternal.Transceiver;
import IceSSL.Context;
import IceSSL.Instance;
import IceSSL.SslTransceiver;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;

class SslAcceptor
implements Acceptor {
    private Instance _instance;
    private Context _ctx;
    private Logger _logger;
    private SSLServerSocket _fd;
    private int _backlog;
    private InetSocketAddress _addr;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ServerSocketChannel fd() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        SSLServerSocket fd;
        if (this._instance.networkTraceLevel() >= 1) {
            String s = "stopping to accept ssl connections at " + this.toString();
            this._logger.trace(this._instance.networkTraceCategory(), s);
        }
        SslAcceptor sslAcceptor = this;
        synchronized (sslAcceptor) {
            fd = this._fd;
            this._fd = null;
        }
        if (fd != null) {
            try {
                fd.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void listen() {
        if (this._instance.networkTraceLevel() >= 1) {
            String s = "accepting ssl connections at " + this.toString();
            this._logger.trace(this._instance.networkTraceCategory(), s);
        }
    }

    public Transceiver accept(int timeout) {
        SSLSocket fd = null;
        try {
            if (timeout == -1) {
                timeout = 0;
            } else if (timeout == 0) {
                timeout = 1;
            }
            this._fd.setSoTimeout(timeout);
            fd = (SSLSocket)this._fd.accept();
            fd.setUseClientMode(false);
        }
        catch (SocketTimeoutException ex) {
            TimeoutException e = new TimeoutException();
            e.initCause(ex);
            throw e;
        }
        catch (IOException ex) {
            SocketException e = new SocketException();
            e.initCause(ex);
            throw e;
        }
        if (this._instance.networkTraceLevel() >= 1) {
            String s = "accepted ssl connection\n" + Network.fdToString(fd);
            this._logger.trace(this._instance.networkTraceCategory(), s);
        }
        return new SslTransceiver(this._instance, fd);
    }

    public void connectToSelf() {
        SocketChannel fd = Network.createTcpSocket();
        Network.setBlock(fd, false);
        Network.doConnect(fd, this._addr, -1);
        Network.closeSocket(fd);
    }

    public String toString() {
        return Network.addrToString(this._addr);
    }

    final boolean equivalent(String host, int port) {
        InetSocketAddress addr = Network.getAddress(host, port);
        return addr.equals(this._addr);
    }

    int effectivePort() {
        return this._addr.getPort();
    }

    SslAcceptor(Instance instance, String host, int port) {
        this._instance = instance;
        this._ctx = instance.serverContext();
        this._logger = instance.communicator().getLogger();
        this._backlog = 0;
        if (this._backlog <= 0) {
            this._backlog = 5;
        }
        try {
            SSLServerSocketFactory factory = this._ctx.sslContext().getServerSocketFactory();
            this._addr = new InetSocketAddress(host, port);
            if (this._instance.networkTraceLevel() >= 2) {
                String s = "attempting to bind to ssl socket " + this.toString();
                this._logger.trace(this._instance.networkTraceCategory(), s);
            }
            InetAddress iface = InetAddress.getByName(host);
            this._fd = (SSLServerSocket)factory.createServerSocket(port, this._backlog, iface);
            this._addr = (InetSocketAddress)this._fd.getLocalSocketAddress();
            int clientAuth = this._instance.communicator().getProperties().getPropertyAsIntWithDefault("IceSSL.Server.ClientAuth", 0);
            if (clientAuth == 0) {
                this._fd.setWantClientAuth(false);
                this._fd.setNeedClientAuth(false);
            } else if (clientAuth == 1) {
                this._fd.setWantClientAuth(true);
            } else {
                this._fd.setNeedClientAuth(true);
            }
            String[] cipherSuites = this._ctx.filterCiphers(this._fd.getSupportedCipherSuites(), this._fd.getEnabledCipherSuites());
            if (this._instance.securityTraceLevel() > 0) {
                StringBuffer s = new StringBuffer();
                s.append("enabling ciphersuites for ssl server socket " + this.toString() + ":");
                for (int i = 0; i < cipherSuites.length; ++i) {
                    s.append("\n  " + cipherSuites[i]);
                }
                this._logger.trace(this._instance.securityTraceCategory(), s.toString());
            }
            this._fd.setEnabledCipherSuites(cipherSuites);
        }
        catch (IOException ex) {
            try {
                if (this._fd != null) {
                    this._fd.close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            this._fd = null;
            SocketException se = new SocketException();
            se.initCause(ex);
            throw se;
        }
    }

    protected void finalize() throws Throwable {
        if (!$assertionsDisabled && this._fd != null) {
            throw new AssertionError();
        }
        super.finalize();
    }

    static {
        $assertionsDisabled = !SslAcceptor.class.desiredAssertionStatus();
    }
}

