/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.Err;
import net.sf.saxon.TransformerFactoryImpl;
import net.sf.saxon.charcode.UnicodeCharacterSet;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FilterIterator;
import net.sf.saxon.expr.IdentityComparison;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StringTokenIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.exslt.Math;
import net.sf.saxon.functions.DeepEqual;
import net.sf.saxon.functions.Evaluate;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Orphan;
import net.sf.saxon.om.ProcInstParser;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.om.XMLChar;
import net.sf.saxon.query.QueryResult;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.sort.GenericAtomicComparer;
import net.sf.saxon.sort.GlobalOrderComparer;
import net.sf.saxon.sort.SortKeyEvaluator;
import net.sf.saxon.sort.SortedIterator;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.tinytree.TinyBuilder;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.DayTimeDurationValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.HexBinaryValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SingletonNode;
import net.sf.saxon.value.Value;
import net.sf.saxon.value.YearMonthDurationValue;

public class Extensions {
    private Extensions() {
    }

    public static void pauseTracing(XPathContext xPathContext) {
        xPathContext.getController().pauseTracing(true);
    }

    public static void resumeTracing(XPathContext xPathContext) {
        xPathContext.getController().pauseTracing(false);
    }

    public static String systemId(XPathContext xPathContext) throws XPathException {
        Item item = xPathContext.getContextItem();
        if (item == null) {
            DynamicError dynamicError = new DynamicError("The context item for saxon:systemId() is not set");
            dynamicError.setXPathContext(xPathContext);
            throw dynamicError;
        }
        if (item instanceof NodeInfo) {
            return ((NodeInfo)item).getSystemId();
        }
        return "";
    }

    public static String generateId(NodeInfo nodeInfo) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(16);
        nodeInfo.generateId(fastStringBuffer);
        return fastStringBuffer.toString();
    }

    public static int lineNumber(XPathContext xPathContext) {
        Item item = xPathContext.getCurrentIterator().current();
        if (item instanceof NodeInfo) {
            return ((NodeInfo)item).getLineNumber();
        }
        return -1;
    }

    public static int lineNumber(NodeInfo nodeInfo) {
        if (nodeInfo == null) {
            return -1;
        }
        return nodeInfo.getLineNumber();
    }

    public static DocumentInfo discardDocument(XPathContext xPathContext, DocumentInfo documentInfo) {
        if (documentInfo == null) {
            return null;
        }
        Controller controller = xPathContext.getController();
        String string = controller.getDocumentPool().getDocumentURI(documentInfo);
        if (string != null) {
            controller.removeUnavailableOutputDestination(string);
        }
        return controller.getDocumentPool().discard(documentInfo);
    }

    public static boolean hasSameNodes(SequenceIterator sequenceIterator, SequenceIterator sequenceIterator2) throws XPathException {
        NodeInfo nodeInfo;
        NodeInfo nodeInfo2;
        SequenceIterator sequenceIterator3 = sequenceIterator;
        SequenceIterator sequenceIterator4 = sequenceIterator2;
        if (sequenceIterator3 == null) {
            sequenceIterator3 = EmptyIterator.getInstance();
        }
        if (sequenceIterator4 == null) {
            sequenceIterator4 = EmptyIterator.getInstance();
        }
        do {
            nodeInfo2 = (NodeInfo)sequenceIterator3.next();
            nodeInfo = (NodeInfo)sequenceIterator4.next();
            if (nodeInfo2 != null && nodeInfo != null) continue;
            return nodeInfo2 == nodeInfo;
        } while (nodeInfo2.isSameNodeInfo(nodeInfo));
        return false;
    }

    public static SequenceIterator sort(XPathContext xPathContext, SequenceIterator sequenceIterator) {
        SortKeyEvaluator sortKeyEvaluator = new SortKeyEvaluator(){

            public Item evaluateSortKey(int n, XPathContext xPathContext) throws XPathException {
                Item item = xPathContext.getContextItem();
                if (item instanceof NodeInfo) {
                    Value value = ((NodeInfo)item).atomize();
                    if (value.getLength() == 0) {
                        item = null;
                    } else if (value.getLength() == 1) {
                        item = value.itemAt(0);
                    } else {
                        throw new DynamicError("error in saxon:sort() - a node has a typed value of length > 1");
                    }
                }
                return item;
            }
        };
        AtomicComparer[] atomicComparerArray = new AtomicComparer[]{new GenericAtomicComparer((StringCollator)CodepointCollator.getInstance(), xPathContext.getConfiguration())};
        return new SortedIterator(xPathContext, sequenceIterator, sortKeyEvaluator, atomicComparerArray);
    }

    public static SequenceIterator sort(XPathContext xPathContext, SequenceIterator sequenceIterator, final Evaluate.PreparedExpression preparedExpression) {
        SortKeyEvaluator sortKeyEvaluator = new SortKeyEvaluator(){

            public Item evaluateSortKey(int n, XPathContext xPathContext) throws XPathException {
                Item item = preparedExpression.expression.evaluateItem(xPathContext);
                if (item instanceof NodeInfo) {
                    Value value = ((NodeInfo)item).atomize();
                    if (value.getLength() == 0) {
                        item = null;
                    } else if (value.getLength() == 1) {
                        item = value.itemAt(0);
                    } else {
                        throw new DynamicError("error in saxon:sort() - a node has a typed value of length > 1");
                    }
                }
                return item;
            }
        };
        AtomicComparer[] atomicComparerArray = new AtomicComparer[]{new GenericAtomicComparer((StringCollator)CodepointCollator.getInstance(), xPathContext.getConfiguration())};
        return new SortedIterator(xPathContext, sequenceIterator, sortKeyEvaluator, atomicComparerArray);
    }

    public static Value highest(SequenceIterator sequenceIterator) throws XPathException {
        return Math.highest(sequenceIterator);
    }

    public static SequenceIterator highest(XPathContext xPathContext, SequenceIterator sequenceIterator, Evaluate.PreparedExpression preparedExpression) throws XPathException {
        Item item;
        if (sequenceIterator == null) {
            return EmptyIterator.getInstance();
        }
        if (preparedExpression == null) {
            return EmptyIterator.getInstance();
        }
        double d = Double.NEGATIVE_INFINITY;
        XPathContextMinor xPathContextMinor = xPathContext.newMinorContext();
        xPathContextMinor.setOriginatingConstructType(2052);
        Item item2 = null;
        xPathContextMinor.setCurrentIterator(sequenceIterator);
        while ((item = sequenceIterator.next()) != null) {
            Serializable serializable;
            Item item3 = preparedExpression.expression.evaluateItem(xPathContextMinor);
            if (item3 instanceof NumericValue) {
                serializable = (DoubleValue)((NumericValue)item3).convert(BuiltInAtomicType.DOUBLE, xPathContext);
                if (!(((DoubleValue)serializable).getDoubleValue() > d)) continue;
                d = ((DoubleValue)serializable).getDoubleValue();
                item2 = sequenceIterator.current();
                continue;
            }
            serializable = new DynamicError("expression in saxon:highest() must return numeric values");
            ((DynamicError)serializable).setXPathContext(xPathContext);
            throw serializable;
        }
        return SingletonIterator.makeIterator(item2);
    }

    public static Value lowest(SequenceIterator sequenceIterator) throws XPathException {
        return Math.lowest(sequenceIterator);
    }

    public static SequenceIterator lowest(XPathContext xPathContext, SequenceIterator sequenceIterator, Evaluate.PreparedExpression preparedExpression) throws XPathException {
        Item item;
        if (sequenceIterator == null) {
            return EmptyIterator.getInstance();
        }
        if (preparedExpression == null) {
            return EmptyIterator.getInstance();
        }
        double d = Double.POSITIVE_INFINITY;
        XPathContextMinor xPathContextMinor = xPathContext.newMinorContext();
        xPathContextMinor.setOriginatingConstructType(2052);
        Item item2 = null;
        xPathContextMinor.setCurrentIterator(sequenceIterator);
        while ((item = sequenceIterator.next()) != null) {
            Serializable serializable;
            Item item3 = preparedExpression.expression.evaluateItem(xPathContextMinor);
            if (item3 instanceof NumericValue) {
                serializable = (DoubleValue)((NumericValue)item3).convert(BuiltInAtomicType.DOUBLE, xPathContext);
                if (!(((DoubleValue)serializable).getDoubleValue() < d)) continue;
                d = ((DoubleValue)serializable).getDoubleValue();
                item2 = sequenceIterator.current();
                continue;
            }
            serializable = new DynamicError("expression in saxon:lowest() must return numeric values");
            ((DynamicError)serializable).setXPathContext(xPathContext);
            throw serializable;
        }
        return SingletonIterator.makeIterator(item2);
    }

    public static SequenceIterator leading(XPathContext xPathContext, SequenceIterator sequenceIterator, Evaluate.PreparedExpression preparedExpression) {
        if (sequenceIterator == null) {
            return EmptyIterator.getInstance();
        }
        if (preparedExpression == null) {
            return EmptyIterator.getInstance();
        }
        XPathContextMinor xPathContextMinor = xPathContext.newMinorContext();
        xPathContextMinor.setOriginatingConstructType(2052);
        return new FilterIterator.Leading(sequenceIterator, preparedExpression.expression, xPathContextMinor);
    }

    public static SequenceIterator after(XPathContext xPathContext, SequenceIterator sequenceIterator, SequenceIterator sequenceIterator2) throws XPathException {
        Object object;
        Object object2;
        block4: {
            Object object3;
            object2 = null;
            GlobalOrderComparer globalOrderComparer = GlobalOrderComparer.getInstance();
            while (true) {
                if ((object = sequenceIterator2.next()) == null) {
                    if (object2 == null) {
                        return sequenceIterator;
                    }
                    break block4;
                }
                if (!(object instanceof NodeInfo)) break;
                object3 = (NodeInfo)object;
                if (object2 == null) {
                    object2 = object3;
                    continue;
                }
                if (globalOrderComparer.compare((NodeInfo)object3, (NodeInfo)object2) >= 0) continue;
                object2 = object3;
            }
            object3 = new DynamicError("Operand of after() contains an item that is not a node");
            ((DynamicError)object3).setXPathContext(xPathContext);
            throw object3;
        }
        object = new IdentityComparison(new ContextItemExpression(), 38, new Literal(new SingletonNode((NodeInfo)object2)));
        return new FilterIterator(sequenceIterator, (Expression)object, xPathContext);
    }

    public static SequenceIterator tokenize(String string) {
        if (string == null) {
            return EmptyIterator.getInstance();
        }
        return new StringTokenIterator(string);
    }

    public static SequenceIterator tokenize(String string, String string2) {
        if (string == null) {
            return EmptyIterator.getInstance();
        }
        if (string2 == null) {
            return new StringTokenIterator(string);
        }
        return new StringTokenIterator(string, string2);
    }

    public static String path(XPathContext xPathContext) throws XPathException {
        Item item = xPathContext.getContextItem();
        if (item == null) {
            DynamicError dynamicError = new DynamicError("The context item for saxon:path() is not set");
            dynamicError.setXPathContext(xPathContext);
            throw dynamicError;
        }
        if (item instanceof NodeInfo) {
            return Navigator.getPath((NodeInfo)item);
        }
        return "";
    }

    public static String typeAnnotation(XPathContext xPathContext, NodeInfo nodeInfo) {
        if (nodeInfo == null) {
            return null;
        }
        int n = nodeInfo.getTypeAnnotation();
        if ((n & 0x40000000) != 0) {
            n = 631;
        }
        if (n == -1) {
            int n2 = nodeInfo.getNodeKind();
            if (n2 == 1 || n2 == 9) {
                return "untyped";
            }
            return "untypedAtomic";
        }
        SchemaType schemaType = xPathContext.getConfiguration().getSchemaType(n & 0xFFFFF);
        if (schemaType == null) {
            return xPathContext.getNamePool().getDisplayName(n);
        }
        return "type " + schemaType.getDescription();
    }

    public static XPathContext getContext(XPathContext xPathContext) {
        return xPathContext;
    }

    public static Controller getController(XPathContext xPathContext) {
        return xPathContext.getController();
    }

    public static Configuration getConfiguration(XPathContext xPathContext) {
        return xPathContext.getConfiguration();
    }

    public static String getPseudoAttribute(XPathContext xPathContext, String string) throws XPathException {
        if (string == null) {
            return null;
        }
        Item item = xPathContext.getContextItem();
        if (item == null) {
            DynamicError dynamicError = new DynamicError("The context item for saxon:getPseudoAttribute() is not set");
            dynamicError.setXPathContext(xPathContext);
            throw dynamicError;
        }
        String string2 = ProcInstParser.getPseudoAttribute(item.getStringValue(), string);
        if (string2 == null) {
            return "";
        }
        return string2;
    }

    public static DayTimeDurationValue dayTimeDurationFromSeconds(BigDecimal bigDecimal) throws XPathException {
        return DayTimeDurationValue.fromSeconds(bigDecimal);
    }

    public static YearMonthDurationValue yearMonthDurationFromMonths(int n) {
        return YearMonthDurationValue.fromMonths(n);
    }

    public static BigDecimal decimalDivide(BigDecimal bigDecimal, BigDecimal bigDecimal2, int n) {
        if (bigDecimal == null || bigDecimal2 == null) {
            return null;
        }
        return bigDecimal.divide(bigDecimal2, n, 1);
    }

    public static List stringToUtf8(String string) {
        if (string == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(string.length() * 2);
        byte[] byArray = new byte[4];
        for (int i = 0; i < string.length(); ++i) {
            int n = UnicodeCharacterSet.getUTF8Encoding(string.charAt(i), i + 1 < string.length() ? string.charAt(i + 1) : (char)'\u0000', byArray);
            for (int j = 0; j < n; ++j) {
                arrayList.add(new Integer(0xFF & byArray[j]));
            }
        }
        return arrayList;
    }

    public static Base64BinaryValue octetsToBase64Binary(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        return new Base64BinaryValue(byArray);
    }

    public static HexBinaryValue octetsToHexBinary(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        return new HexBinaryValue(byArray);
    }

    public static byte[] base64BinaryToOctets(Base64BinaryValue base64BinaryValue) {
        if (base64BinaryValue == null) {
            return null;
        }
        return base64BinaryValue.getBinaryValue();
    }

    public static byte[] hexBinaryToOctets(HexBinaryValue hexBinaryValue) {
        if (hexBinaryValue == null) {
            return null;
        }
        return hexBinaryValue.getBinaryValue();
    }

    public static String base64BinaryToString(XPathContext xPathContext, Base64BinaryValue base64BinaryValue, String string) throws Exception {
        if (base64BinaryValue == null) {
            return null;
        }
        if (string == null) {
            string = "UTF-8";
        }
        byte[] byArray = base64BinaryValue.getBinaryValue();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)byteArrayInputStream, string);
        char[] cArray = new char[byArray.length];
        int n = inputStreamReader.read(cArray, 0, cArray.length);
        Extensions.checkBytes(cArray, 0, n, xPathContext.getConfiguration().getNameChecker());
        return new String(cArray, 0, n);
    }

    public static Base64BinaryValue stringToBase64Binary(String string, String string2) throws UnsupportedEncodingException, IOException {
        if (string == null) {
            return null;
        }
        if (string2 == null) {
            string2 = "UTF-8";
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string.length());
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, string2);
        outputStreamWriter.write(string);
        outputStreamWriter.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        return Extensions.octetsToBase64Binary(byArray);
    }

    public static String hexBinaryToString(XPathContext xPathContext, HexBinaryValue hexBinaryValue, String string) throws Exception {
        if (hexBinaryValue == null) {
            return null;
        }
        if (string == null) {
            string = "UTF-8";
        }
        byte[] byArray = hexBinaryValue.getBinaryValue();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)byteArrayInputStream, string);
        char[] cArray = new char[byArray.length];
        int n = inputStreamReader.read(cArray, 0, cArray.length);
        Extensions.checkBytes(cArray, 0, n, xPathContext.getConfiguration().getNameChecker());
        return new String(cArray, 0, n);
    }

    private static void checkBytes(char[] cArray, int n, int n2, NameChecker nameChecker) throws XPathException {
        for (int i = n; i < n2; ++i) {
            int n3 = cArray[i];
            if (XMLChar.isHighSurrogate(n3)) {
                char c = cArray[i++];
                n3 = XMLChar.supplemental((char)n3, c);
            }
            if (nameChecker.isValidChar(n3)) continue;
            DynamicError dynamicError = new DynamicError("The byte sequence contains a character not allowed by XML (hex " + Integer.toHexString(n3) + ')');
            dynamicError.setErrorCode("XTDE1180");
            throw dynamicError;
        }
    }

    public static HexBinaryValue stringToHexBinary(String string, String string2) throws Exception {
        if (string == null) {
            return null;
        }
        if (string2 == null) {
            string2 = "UTF-8";
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string.length());
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, string2);
        outputStreamWriter.write(string);
        outputStreamWriter.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        return Extensions.octetsToHexBinary(byArray);
    }

    public static boolean validCharacter(XPathContext xPathContext, int n) {
        return xPathContext.getConfiguration().getNameChecker().isValidChar(n);
    }

    public static NodeInfo namespaceNode(XPathContext xPathContext, String string, String string2) throws XPathException {
        if (string == null) {
            string = "";
        } else if (string.length() != 0 && !xPathContext.getConfiguration().getNameChecker().isValidNCName(string)) {
            DynamicError dynamicError = new DynamicError("Namespace prefix " + Err.wrap(string) + " is not a valid NCName");
            throw dynamicError;
        }
        if (string2 == null || string2.length() == 0) {
            DynamicError dynamicError = new DynamicError("URI of namespace node must not be empty");
            throw dynamicError;
        }
        NamePool namePool = xPathContext.getNamePool();
        Orphan orphan = new Orphan(xPathContext.getConfiguration());
        orphan.setNodeKind((short)13);
        orphan.setNameCode(namePool.allocate("", "", string));
        orphan.setStringValue(string2);
        return orphan;
    }

    public static boolean deepEqual(XPathContext xPathContext, SequenceIterator sequenceIterator, SequenceIterator sequenceIterator2, String string, String string2) throws XPathException {
        Serializable serializable;
        if (string2.indexOf(33) >= 0) {
            serializable = new Properties();
            serializable.setProperty("indent", "yes");
            System.err.println("DeepEqual: first argument:");
            QueryResult.serialize(QueryResult.wrap(sequenceIterator.getAnother(), xPathContext.getConfiguration()), new StreamResult(System.err), serializable);
            System.err.println("DeepEqual: second argument:");
            QueryResult.serialize(QueryResult.wrap(sequenceIterator2.getAnother(), xPathContext.getConfiguration()), new StreamResult(System.err), serializable);
        }
        serializable = string == null ? new GenericAtomicComparer(xPathContext.getDefaultCollation(), xPathContext) : new GenericAtomicComparer(xPathContext.getCollation(string), xPathContext);
        int n = 0;
        if (string2.indexOf("N") >= 0) {
            n |= 1;
        }
        if (string2.indexOf("J") >= 0) {
            n |= 0x100;
        }
        if (string2.indexOf("C") >= 0) {
            n |= 4;
        }
        if (string2.indexOf("P") >= 0) {
            n |= 8;
        }
        if (string2.indexOf("F") >= 0) {
            n |= 2;
        }
        if (string2.indexOf("S") >= 0) {
            n |= 0x20;
        }
        if (string2.indexOf("A") >= 0) {
            n |= 0x40;
        }
        if (string2.indexOf("w") >= 0) {
            n |= 0x10;
        }
        if (string2.indexOf("?") >= 0) {
            n |= 0x80;
        }
        return DeepEqual.deepEquals(sequenceIterator, sequenceIterator2, (GenericAtomicComparer)serializable, xPathContext.getConfiguration(), n);
    }

    public static Templates compileStylesheet(XPathContext xPathContext, DocumentInfo documentInfo) throws XPathException {
        if (documentInfo == null) {
            return null;
        }
        try {
            TransformerFactoryImpl transformerFactoryImpl = new TransformerFactoryImpl(xPathContext.getConfiguration());
            Templates templates = transformerFactoryImpl.newTemplates(documentInfo);
            return templates;
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw DynamicError.makeDynamicError(transformerConfigurationException);
        }
    }

    public static DocumentInfo transform(XPathContext xPathContext, Templates templates, NodeInfo nodeInfo) throws XPathException {
        if (templates == null) {
            return null;
        }
        if (nodeInfo == null) {
            return null;
        }
        try {
            Transformer transformer = templates.newTransformer();
            TinyBuilder tinyBuilder = new TinyBuilder();
            tinyBuilder.setPipelineConfiguration(xPathContext.getController().makePipelineConfiguration());
            transformer.transform(nodeInfo, tinyBuilder);
            return (DocumentInfo)tinyBuilder.getCurrentRoot();
        }
        catch (TransformerException transformerException) {
            throw DynamicError.makeDynamicError(transformerException);
        }
    }

    public static DocumentInfo transform(XPathContext xPathContext, Templates templates, NodeInfo nodeInfo, SequenceIterator sequenceIterator) throws XPathException {
        if (templates == null) {
            return null;
        }
        if (nodeInfo == null) {
            return null;
        }
        try {
            Item item;
            Transformer transformer = templates.newTransformer();
            TinyBuilder tinyBuilder = new TinyBuilder();
            tinyBuilder.setPipelineConfiguration(xPathContext.getController().makePipelineConfiguration());
            while ((item = sequenceIterator.next()) != null) {
                if (item instanceof NodeInfo) {
                    int n = ((NodeInfo)item).getFingerprint();
                    Value value = ((NodeInfo)item).atomize();
                    ((Controller)transformer).setParameter(n, value);
                    continue;
                }
                throw new DynamicError("Parameters passed to saxon:transform() must be nodes");
            }
            transformer.transform(nodeInfo, tinyBuilder);
            return (DocumentInfo)tinyBuilder.getCurrentRoot();
        }
        catch (TransformerException transformerException) {
            throw DynamicError.makeDynamicError(transformerException);
        }
    }
}

