/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.io.FileReader;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.debug.DebuggableEngine;
import org.mozilla.javascript.tools.debugger.Main;
import org.mozilla.javascript.tools.debugger.MessageDialogWrapper;

class LoadFile
implements Runnable {
    Scriptable scope;
    String fileName;
    Main db;

    LoadFile(Main main, Scriptable scriptable, String string) {
        this.scope = scriptable;
        this.fileName = string;
        this.db = main;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Context context = Context.enter();
        DebuggableEngine debuggableEngine = context.getDebuggableEngine();
        debuggableEngine.setBreakNextLine(true);
        try {
            try {
                context.evaluateReader(this.scope, new FileReader(this.fileName), this.fileName, 1, null);
            }
            catch (Exception exception) {
                String string = exception.getMessage();
                if (exception instanceof EcmaError) {
                    EcmaError ecmaError = (EcmaError)exception;
                    string = ecmaError.getSourceName() + ", line " + ecmaError.getLineNumber() + ": " + string;
                }
                MessageDialogWrapper.showMessageDialog(this.db, string, "Run", 0);
                Object var7_4 = null;
                Context.exit();
                return;
            }
            Object var7_3 = null;
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
    }
}

