/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import java.util.Enumeration;
import java.util.Hashtable;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.optimizer.Block;

public class FatBlock {
    private Hashtable itsSuccessors = new Hashtable(4);
    private Hashtable itsPredecessors = new Hashtable(4);
    private Block itsShadowOfFormerSelf;

    public FatBlock(int n, int n2, Node[] nodeArray) {
        this.itsShadowOfFormerSelf = new Block(n, n2, nodeArray);
    }

    public Node getEndNode() {
        return this.itsShadowOfFormerSelf.getEndNode();
    }

    public Block getSlimmerSelf() {
        return this.itsShadowOfFormerSelf;
    }

    private Block[] reduceToArray(Hashtable hashtable) {
        Block[] blockArray = null;
        if (!hashtable.isEmpty()) {
            blockArray = new Block[hashtable.size()];
            Enumeration enumeration = hashtable.elements();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                FatBlock fatBlock = (FatBlock)enumeration.nextElement();
                blockArray[n++] = fatBlock.itsShadowOfFormerSelf;
            }
        }
        return blockArray;
    }

    Block diet() {
        this.itsShadowOfFormerSelf.setSuccessorList(this.reduceToArray(this.itsSuccessors));
        this.itsShadowOfFormerSelf.setPredecessorList(this.reduceToArray(this.itsPredecessors));
        return this.itsShadowOfFormerSelf;
    }

    public void addSuccessor(FatBlock fatBlock) {
        this.itsSuccessors.put(fatBlock, fatBlock);
    }

    public void addPredecessor(FatBlock fatBlock) {
        this.itsPredecessors.put(fatBlock, fatBlock);
    }
}

