#!/bin/sh


##
## This file is called by Makefile. It does the followings:
## 1.run pdf latex to each tex file produced by R CMD build
## 2.remove header and footer or each tex file so that it's ready for inclusion by zelig.tex
## 3.convert all Rd files to tex file so that they are ready for inclusion by zelig.tex
##

## get name of the models and save them in a file
echo "library(Zelig); a<-zeligListModels(); write(a,file='tmp.txt');" | R --vanilla --slave

## at this point, Sweave should have been run and produced tex files
for f in `cat tmp.txt`
  do 
if [ "$f" != "beta" ]
then
  #if [ "$RBUILD" != "TRUE" ]
  #    then
  echo "Sweave(\"$f.Rnw\")" | R --slave
  #fi
  
  ## create pdfs for all the tex file produced by sweave
  pdflatex $f.tex
  
  ## remove header and footer from the tex file so that they are ready 
  ## for inclusion in big zelig manual
  perl -i -ne 'print unless /^\\include{zinput}$/ .. /^\\begin{document}$/' $f.tex
  perl -i -p -e 's#\\end{document}# #i' $f.tex
fi
done

## run R CMD Rdconv to rd files
## create commandsRd folder if does not exists

if [ ! -d commandsRd ]
then
    mkdir commandsRd
fi
Rdfiles=`ls ../../man`
for rd in ${Rdfiles}
  do
  newname=`basename ${rd} .Rd`
  R CMD Rdconv -t=latex ../../man/${rd} -o commandsRd/${newname}.tex
  
  ### perl -i -pe 's#HeaderA{#section{{\\tt #i' commandsRd/${newname}.tex
  perl -i -pe 's#HeaderA{(.*)}{(.*)}{(.*)}#section{{\\tt \1}: \2}\\label{ss:\3}#i' commandsRd/${newname}.tex 
done


## create the big Zelig manual
pdflatex zelig
bibtex zelig
pdflatex zelig
pdflatex zelig
pdflatex zelig


#for f in `cat tmp.txt`
#do
#rm -f $f.tex
#done

## remove the files with the name of the models
rm tmp.txt



## do some cleanup
rm -f *.aux *.toc *.log *.out *.blg *.bbl








#### here is how u delete the \end{document}
#### perl -i.old -p -e 's#\\end{document}# #i' try

#### delete first 10 lines 
#### perl -i.old -ne 'print unless 1 .. 10' foo.txt

#### \SweaveOpts{result=hide}
#### perl -i.old -p -e 's#\\include{zinput}#\\SweaveOpts{results=hide}\n\\include{zinput}#i' *.Rnw

### change dependencies line
### perl -i.old -p -e 's#See Package dependencies#Zelig#i' *.Rnw

#### thats how u remove the header from tex files
#### perl -i.old -ne 'print unless /^\\include{zinput}$/ .. /^\\begin{document}$/' try
