/* log.c -- logging conversations to files */

/*                       NOTICE
 *
 * Copyright (c) 1990,1992,1993 Britt Yenne.  All rights reserved.
 * 
 * This software is provided AS-IS.  The author gives no warranty,
 * real or assumed, and takes no responsibility whatsoever for any 
 * use or misuse of this software, or any damage created by its use
 * or misuse.
 * 
 * This software may be freely copied and distributed provided that
 * no part of this NOTICE is deleted or edited in any manner.
 * 
 */

/*   Mail comments or questions to metawire.org */

#include <stdio.h>
#include <time.h>
#include "header.h"

static FILE *dump_fp = NULL;

/* ---- local functions ---- */

static void add_to_dump_buf(yuser *user, ychar c)
{
    if (!dump_fp) return;

    user->dump_buf[user->dump_buf_len] = c;
    ++user->dump_buf_len;
}

static void dump_dump(yuser *user)
{
    char buf[1024];
    time_t t = time(NULL);

    if (!dump_fp) return;

    add_to_dump_buf(user,'\0');

    sprintf(buf,"%s",asctime(localtime(&t)));
    buf[strlen(buf)-1] = '\0';	/* kill '\n' */
    
    fprintf(dump_fp,
	    "%s (%s):\n%s",
	    user->full_name,
	    buf,
	    user->dump_buf);
    fflush(dump_fp);

    user->dump_buf_len = 0;
}

static void dump_if_ready(yuser *user)
{
    if (!dump_fp) return;

    if (user->dump_buf_len == DUMP_BUF_SIZE) dump_dump(user);
    
    if (user->dump_buf_len > 1 &&
	user->dump_buf[user->dump_buf_len-1] == '\n' &&
	user->dump_buf[user->dump_buf_len-2] == '\n' ) 
    {
	dump_dump(user);
    }
}

/* ---- global functions ---- */

void addch_dump(yuser *user, ychar c)
{
    if (!dump_fp) return;

    add_to_dump_buf(user,c);
    dump_if_ready(user);
}

void newline_dump(yuser *user)
{
    if (!dump_fp) return;

    add_to_dump_buf(user,'\n');
    dump_if_ready(user);
}

void rub_dump(yuser *user)
{
    if (!dump_fp) return;

    if (user->dump_buf_len > 0) user->dump_buf_len -= 2;
}

void set_file_dump(char *fn) 
{
    dump_fp = fopen(fn,"w");
    if (!dump_fp) 
	fprintf(stderr,
		"Warning: Can not open %s, "
		"no record of conversation will be kept\n",fn);
}
