#include <asm/io.h>
#include "ieee1284.h"
#include "project.h"
#include "port_signal.h"
#include "yepplib.h"
#include "interface.h"

#define YEPP_WSBS 0x3ff0
#define YEPP_WBBS 0x41f8
#define YEPP_RSBS 0x3ff0
#define YEPP_RBBS 0x41f8

static struct yepp_dirent list[300];

int yepp_ping()
{
   outb_p(0x0a, DATA);

   return SUCCESS;
}

int yepp_wakeup()
{
   unsigned char j;
   int trys = 0;

   if(!ieee1284_probe(BASE))
      return FAIL;

   do
   {
      foo();
      if(!negotiate(0x10))
	 not1284_setup();

      if(ieee1284_writebyte(0xa))
      {
         j = 0;
         if (((read_dsr() & 0xa0) == 0xa0))
         {                   // FIXME:
         ieee1284_ftor();
         ieee1284_readbyte(&j);
         ieee1284_rtof();
         }
         ieee1284_term();
         if(j == 1)
            return SUCCESS;
      }
   foo();
   sleep(2);
   usleep(10000);
   outb_p(0xe, DCR);
   usleep(10000);
   outb_p(0xc, DCR);
   }

    while(trys < 4);
       return FAIL;
}

struct yepp_status*  yepp_status()
{
   struct yepp_status *status;
   unsigned char buf[8];
   int loop;

   if(!phase1())
   {
      phase4();
      printf("status 1\n");
      return FAIL;
   }

   if(!ieee1284_writebyte(0x4))
   {
      phase4();
      printf("status 2\n");
      return FAIL;
   }

   if(!phase2())
   {
      printf("status 3\n");
      return FAIL;
   }

   for(loop = 0; loop <= 7; loop++) ieee1284_readbyte(&buf[loop]);

   phase3();
   phase4();

   status = (struct yepp_status*) malloc(sizeof(struct yepp_status));

   status->flash_size = ((buf[1] << 8) | buf[0]) * 16;
   status->flash_free = ((buf[3] << 8) | buf[2]) * 16;
   status->card_size = ((buf[5] << 8) | buf[4]) * 16;
   status->card_free = ((buf[7] << 8) | buf[6]) * 16;

   return status;
}

void yepp_release(void)
{
   outb_p(0x0, DATA);
   outb_p(0x0c, DCR);
   outb_p(0x0b, DCR);
}

struct yepp_status* yepp_connect()
{
   struct yepp_status *status;

   status = yepp_status();

   return status;
}

struct yepp_dirent* yepp_dir()
{
   unsigned char buf[522];
   int loop, check = SUCCESS, index = 0, end;
   
   if(!phase1())
   {
      phase4();
      printf("dir 1\n");
      return FAIL;
   }

   if(!ieee1284_writebyte(0x3))
   {
      phase4();
      printf("dir 2\n");
      return FAIL;
   }

   if(!phase2())
   {
      printf("dir 3\n");
      return FAIL;
   }

   while(SUCCESS)
   {
      for(loop = 0; check == SUCCESS && loop < 522; loop++)
         check = ieee1284_readbyte(buf + loop);

      if(loop != 522)
      {
         phase3();
         phase4();
         printf("dir 4\n");
	 return NULL;
      }

      for(end = 0; end < 522; end++)
         if(buf[end])
            break;

      if(end == 522)
      {
         ieee1284_readbyte(buf);
         phase3();
         phase4();
         (list+index)->index = FAIL;
         return list;
      }

      if(check == SUCCESS)
      {
         (list+index)->index = buf[0];
         (list+index)->type = buf[1];
         (list+index)->size =
	    buf[2] | (buf[3] << 8) | (buf[4] << 16) | (buf[5] << 24);
         bcopy(buf + 6, (list+index)->name, 515);
         (list+index)->attr = buf[521];
         index++;
      }
   }
}

int yepp_send_dword (int i)
{
   unsigned char buf[4];

   buf[0] = i & 0xff;
   i >>= 8;
   buf[1] = i & 0xff;
   i >>= 8;
   buf[2] = i & 0xff;
   i >>= 8;
   buf[3] = i & 0xff;
	     
   if(!yepp_write(buf, 4))
      return FAIL;
   else
      return SUCCESS;
}

int yepp_send_word (int i)
{
   unsigned char buf[2];

   buf[0] = i & 0xff;
   i >>= 8;
   buf[1] = i & 0xff;

   if(!yepp_write(buf, 2))
      return FAIL;
   else
      return SUCCESS;
}

int yepp_bytes_to_blocks (int bytes)
{
   int blocks = 1;
   bytes -= YEPP_WSBS;

   while (bytes > 0)
   {
      bytes -= YEPP_WBBS;
      blocks++;
   }

   return blocks;
}

static int yepp_send_filename (char *name)
{
   unsigned char buf[515];

   bzero (buf, 515);
   strncpy (buf, name, 514);

   return (yepp_write (buf, 515) == 515);
}

int last_slash(char *fname)
{
   int slash = 0;
   int index = 0;

   for(index = 0; *(fname + index) != '\0'; index++)
      if(*(fname + index) == '/')
	 slash = index;

   return ++slash;
}

int upload_to_yepp(char *fname, int where, int type)
{
   FILE *fp;
   char buf[0x41f8], cur_buf[4];
   int size, check, offset;
   
   if(!(fp = fopen(fname, "r")))
   {  printf("aaaaaaaaa1\n");
      return FAIL;
   }

   offset = last_slash(fname);

   fseek(fp, 0L, SEEK_END);
   size = ftell(fp);
   fseek(fp, 0L, SEEK_SET);

   blocks = yepp_bytes_to_blocks(size);

   if(!phase1())
   {
      phase4();
      return FAIL;
   }

   if(!ieee1284_writebyte(0x1))
   {
      phase4();
      return FAIL;
   }

   if(!ieee1284_writebyte(where))
   {
      phase4();
      return FAIL;
   }
   if(!ieee1284_writebyte(type))
   {
      phase4();
      return FAIL;
   }
   if(!yepp_send_dword(size))
   {
      phase4();
      return FAIL;
   }
   if(!yepp_send_word(blocks))
   {
      phase4();
      return 0;
   }
   if(!yepp_send_filename(fname + offset))
   {
      phase4();
      return FAIL;
   }

   fread (buf, 1, YEPP_WSBS, fp);

   check = yepp_write(buf, YEPP_WSBS);

   if(!check )
   {
      phase4();
      return FAIL;
   }

   if(!ieee1284_writebyte(0x0))
   {
      phase4 ();
      return FAIL;
   }

   for(cur_block = 1; cur_block < blocks; ++cur_block)
   {
      fread (buf, 1, YEPP_WBBS, fp);

      check = yepp_write(buf, YEPP_WBBS);

      sprintf(cur_buf, "%3.0f", (cur_block / blocks) * 100);
      write(fd, cur_buf, sizeof(cur_buf));

      if(check != YEPP_WBBS)
      {
         phase4();
         return FAIL;
      }
      if(!ieee1284_writebyte(0x0))
      {
         phase4();
	 return FAIL;
      }
   }
   
   phase2();
   check = ieee1284_readbyte(buf);
   phase3();
   phase4();

   fclose(fp);
   
   return (check == SUCCESS) ? cur_block : FAIL;
}

int yepp_delete(int index)
{
   unsigned char c;
   int buf;
   
   if(!phase1())
   {
      phase4();
      return FAIL;
   }

   if(!ieee1284_writebyte(0x5))
   {
      phase4();
      return FAIL;
   }

   if(!ieee1284_writebyte(index))
   {
      phase4();
      return FAIL;
   }

   if(!phase2())
   {
      phase4();
      return FAIL;
   }

   buf = ieee1284_readbyte(&c);

   phase3();
   phase4();

   if(!buf)
      return FAIL;

   return (c == 0);
}

int yepp_format(int where)
{
   unsigned char c;
   int ret;

   if(!phase1())
   {
      phase4();
      return FAIL;
   }

   if(!ieee1284_writebyte(0x6))
   {
      phase4();
      return FAIL;
   }

   if(!ieee1284_writebyte(where))
   {
      phase4();
      return FAIL;
   }

   if(!phase2())
   {
      phase4();
      return FAIL;
   }

   ret = ieee1284_readbyte(&c);

   phase3();
   phase4();

   if(!ret)
      return FAIL;

   return (c == 0xff);
}
