#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>

#include <getopt.h>
#include <unistd.h>

#include <glib.h>
#include <gc/gc.h>

#include "process.h"

static void usage(FILE *outf, int exit_code);

static struct option opts[] =
{
  { "help", no_argument, 0, 'h' },
  { "output", required_argument, 0, 'o' },
  { 0, 0, 0, 0 }
};

int main(int argc, char *argv[])
{
  FILE *inf, *outf;
  char *infile_name, *outfile_name = NULL;
  int option_index = 0;
  int c;
  
  while ((c = getopt_long(argc, argv, "ho:", opts, &option_index)) != -1)
  {
    switch (c)
    {
      case 'o':
        outfile_name = optarg;
        break;
      case 'h':
        usage(stdout, -1);
        exit(EXIT_SUCCESS);
      default:
        g_assert_not_reached();
    }
  }
  
  if (argc - optind != 1)
  {
    fprintf(stderr, "yehia-igen needs exactly one non-option argument\n");
    usage(stderr, EXIT_FAILURE);
  }
  
  infile_name = argv[optind];
  if ((inf = fopen(infile_name, "r")) == NULL)
  {
    fprintf(stderr, "unable to open input file `%s': %s\n", infile_name,
            strerror(errno));
    exit(EXIT_FAILURE);
  }

  if (outfile_name == NULL)
  {
    char *cp;
    
    if ((cp = strrchr(infile_name, '.')) != NULL)
    {
      outfile_name = GC_malloc(cp - infile_name + 4);
      memcpy(outfile_name, infile_name, cp - infile_name);
      strcpy(outfile_name + (cp - infile_name), ".cc");
    }
    else
    {
      int len = strlen(infile_name);
      outfile_name = GC_malloc(len + 4);
      strcpy(outfile_name, infile_name);
      strcpy(outfile_name + len, ".cc");
    }
  }
  if (strcmp(outfile_name, "-") == 0)
    outf = stdout;
  else if ((outf = fopen(outfile_name, "w")) == NULL)
  {
    fprintf(stderr, "unable to open output file `%s': %s\n", outfile_name,
            strerror(errno));
    exit(EXIT_FAILURE);
  }

  if (process_file(inf, infile_name, outf))
    exit(EXIT_SUCCESS);
  else
  {
    unlink(outfile_name);
    exit(EXIT_FAILURE);
  }
}

static void usage(FILE *outf, int exit_code)
{
  fprintf(outf,
          "Usage: yehia-igen [options] file\n"
          "\n"
          "Options:\n"
          "\n"
          "  --help             display this message\n"
          "  -o, --output=FILE  ouput file name\n"
          "\n"
          "Report bugs to <ucxx-main@lists.sourceforge.net>\n");
          
  if (exit_code >= 0)
    exit(exit_code);
}

