/* This is for emacs: -*-Mode: C++;-*- */
/*  
  Copyright 2002, Andreas Rottmann

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/
#if !defined(__INC_UCXX_SCRIPT_WRAPOBJ_H)
#define __INC_UCXX_SCRIPT_WRAPOBJ_H

namespace Yehia
{

namespace Script
{

//
// Wrapper for Objects not derived from SigC::Object
class WrapObject : public SigC::Object
{
    template <class T> friend struct MarshalTraits;
  public:
    template <class T>
    WrapObject(T *t) : content_(new Holder<T>(t)) { }
    const std::type_info& type() const {
      return content_ ? content_->type() : typeid(void);
    }
    void detach() {
      if (content_)
        content_->detach();
    }
    virtual ~WrapObject() { delete content_; }
  private:
    class PlaceHolder
    {
      public:
        virtual ~PlaceHolder() { }
        virtual const std::type_info& type() const = 0;
        virtual void detach() = 0;
    };
    template <class T>
    class Holder : public PlaceHolder
    {
        template <class U> friend struct MarshalTraits;
      public:
        Holder(T *t) : held_(t) { }
        virtual ~Holder() { if (held_) delete held_; }
        virtual const std::type_info& type() const { return typeid(T); }
        virtual void detach() { held_ = 0; }
      private:
        T *held_;
    };
    PlaceHolder *content_;
};

}

}

#endif
