#include <iostream>
#include <string>

#include <sigc++/method_slot.h>
#include <sigc++/retype_return.h>
#include <sigcx/thread_tunnel.h>
#include <sigcx/ref_slot.h>

#include <yehia/plugin.h>
#include <yehia/script.h>

using namespace Yehia;
using namespace Yehia::Script;

bool logger(int level, const string& msg)
{
  if (level == ErrorHandler::LOG_ERROR)
    std::cout << "ERROR " << msg << endl;
  else
    std::cout << "LOG[" << level << "] " << msg << std::endl;
  return true;
}

class MySimpleObject
{
  public:
    MySimpleObject() {
      cout << "A new MySimpleObject has been created!!" << endl;
    }
    virtual ~MySimpleObject() {
      cout << "A MySimpleObject has been destroyed!!" << endl;
    }
};

class MyObject : public SigC::Object
{
  public:
    MyObject() {
      cout << "A new MyObject has been created!!" << endl;
      foo_ = false;
      bar_ = 0;
    }
    virtual ~MyObject() {
      cout << "A MyObject has been destroyed!!" << endl;
      if (bar_)
        delete bar_;
    }
    MySimpleObject& get_bar() {
      if (bar_ == 0)
        bar_ = new MySimpleObject();
      return *bar_;
    }
    void set_bar(MySimpleObject *bar) {
      if (bar_)
        delete bar_;
      bar_ = bar;
    }
    void set_foo(bool foo) { foo_ = foo; }
    bool get_foo() { return foo_; }
  private:
    bool foo_;
    MySimpleObject *bar_;
};

class MyVirtualObject : public SigC::Object
{
  public:
    virtual void func() {
      std::cout << "MyVirtualObject::func called" << std::endl;
    }
};

class MyOtherVObject : public MyVirtualObject
{
  public:
    virtual void func() {
      std::cout << "MyOtherVObject::func called" << std::endl;
 }
};

MyVirtualObject *vobj_creator_func()
{
  return manage(new MyOtherVObject());
}

int sqr_func(int arg)
{
  return arg * arg;
}

string str_add_func(const string& s1, const string& s2)
{
  return s1 + s2;
}

void caller_func(SigC::Slot1<void, const string&> slot)
{
  slot("foo");
}

void call_method(MyVirtualObject *obj)
{
  cout << "call_method: " << obj << endl;
  obj->func();
}

#include "mymodule.cc"

void language_registered(const string& name)
{
  Language *lang = LanguageManager::instance().language(name);
#if 1
  if (lang)
    SigCX::pack<void, Language&>(SigC::slot(&yehia_ns_mymodule_register), 
                                 *lang)->tunnel(lang->tunnel());
#endif
}


int main(int argc, char *argv[])
{
  SigCX::StandardDispatcher disp;
  SigCX::ThreadTunnel main_tunnel(disp, SigCX::ThreadTunnel::CurrentThread);
  PluginManager manager;
  LanguageManager langman(&manager, &main_tunnel);
  //bool do_exit;

  manager.log.connect(SigC::slot(logger));

  manager.load_plugin("yehia");

  langman.language_registered.connect(SigC::slot(language_registered));

  for (int i = 1; i < argc; i++)
  {
    string langname = argv[i];
    manager.load_plugin(langname);
    manager.load_plugin("test." + langname + "01");
    manager.release_plugin("test." + langname + "01");
  }
}
