/* Generated by re2c 0.9.1-C on Sat Oct 30 21:13:55 2004
 */
#line 1 "./modules/arch/lc3b/lc3bid.re"
/*
 * LC-3b identifier recognition and instruction handling
 *
 *  Copyright (C) 2003  Peter Johnson
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND OTHER CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR OTHER CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
#include <util.h>
RCSID("$Id: lc3bid.re 1137 2004-09-04 01:24:57Z peter $");

#define YASM_LIB_INTERNAL
#define YASM_BC_INTERNAL
#define YASM_EXPR_INTERNAL
#include <libyasm.h>

#include "modules/arch/lc3b/lc3barch.h"


/* Opcode modifiers.  The opcode bytes are in "reverse" order because the
 * parameters are read from the arch-specific data in LSB->MSB order.
 * (only for asthetic reasons in the lexer code below, no practical reason).
 */
#define MOD_OpHAdd  (1UL<<0)	/* Parameter adds to upper 8 bits of insn */
#define MOD_OpLAdd  (1UL<<1)	/* Parameter adds to lower 8 bits of insn */

/* Operand types.  These are more detailed than the "general" types for all
 * architectures, as they include the size, for instance.
 * Bit Breakdown (from LSB to MSB):
 *  - 1 bit = general type (must be exact match, except for =3):
 *            0 = immediate
 *            1 = register
 *
 * MSBs than the above are actions: what to do with the operand if the
 * instruction matches.  Essentially describes what part of the output bytecode
 * gets the operand.  This may require conversion (e.g. a register going into
 * an ea field).  Naturally, only one of each of these may be contained in the
 * operands of a single insn_info structure.
 *  - 2 bits = action:
 *             0 = does nothing (operand data is discarded)
 *             1 = DR field
 *             2 = SR field
 *             3 = immediate
 *
 * Immediate operands can have different sizes.
 *  - 3 bits = size:
 *             0 = no immediate
 *             1 = 4-bit immediate
 *             2 = 5-bit immediate
 *             3 = 6-bit index, word (16 bit)-multiple
 *             4 = 6-bit index, byte-multiple
 *             5 = 8-bit immediate, word-multiple
 *             6 = 9-bit signed immediate, word-multiple
 *             7 = 9-bit signed offset from next PC ($+2), word-multiple
 */
#define OPT_Imm		0x0
#define OPT_Reg		0x1
#define OPT_MASK	0x1

#define OPA_None	(0<<1)
#define OPA_DR		(1<<1)
#define OPA_SR		(2<<1)
#define OPA_Imm		(3<<1)
#define OPA_MASK	(3<<1)

#define OPI_None	(LC3B_IMM_NONE<<3)
#define OPI_4		(LC3B_IMM_4<<3)
#define OPI_5		(LC3B_IMM_5<<3)
#define OPI_6W		(LC3B_IMM_6_WORD<<3)
#define OPI_6B		(LC3B_IMM_6_BYTE<<3)
#define OPI_8		(LC3B_IMM_8<<3)
#define OPI_9		(LC3B_IMM_9<<3)
#define OPI_9PC		(LC3B_IMM_9_PC<<3)
#define OPI_MASK	(7<<3)

typedef struct lc3b_insn_info {
    /* Opcode modifiers for variations of instruction.  As each modifier reads
     * its parameter in LSB->MSB order from the arch-specific data[1] from the
     * lexer data, and the LSB of the arch-specific data[1] is reserved for the
     * count of insn_info structures in the instruction grouping, there can
     * only be a maximum of 3 modifiers.
     */
    unsigned int modifiers;

    /* The basic 2 byte opcode */
    unsigned int opcode;

    /* The number of operands this form of the instruction takes */
    unsigned char num_operands;

    /* The types of each operand, see above */
    unsigned int operands[3];
} lc3b_insn_info;

/* Define lexer arch-specific data with 0-3 modifiers. */
#define DEF_INSN_DATA(group, mod)	do { \
    data[0] = (unsigned long)group##_insn; \
    data[1] = ((mod)<<8) | \
    	      ((unsigned char)(sizeof(group##_insn)/sizeof(lc3b_insn_info))); \
    } while (0)

#define RET_INSN(group, mod)	do { \
    DEF_INSN_DATA(group, mod); \
    return YASM_ARCH_CHECK_ID_INSN; \
    } while (0)

/*
 * Instruction groupings
 */

static const lc3b_insn_info addand_insn[] = {
    { MOD_OpHAdd, 0x1000, 3,
      {OPT_Reg|OPA_DR, OPT_Reg|OPA_SR, OPT_Reg|OPA_Imm|OPI_5} },
    { MOD_OpHAdd, 0x1020, 3,
      {OPT_Reg|OPA_DR, OPT_Reg|OPA_SR, OPT_Imm|OPA_Imm|OPI_5} }
};

static const lc3b_insn_info br_insn[] = {
    { MOD_OpHAdd, 0x0000, 1, {OPT_Imm|OPA_Imm|OPI_9PC, 0, 0} }
};

static const lc3b_insn_info jmp_insn[] = {
    { 0, 0xC000, 2, {OPT_Reg|OPA_DR, OPT_Imm|OPA_Imm|OPI_9, 0} }
};

static const lc3b_insn_info lea_insn[] = {
    { 0, 0xE000, 2, {OPT_Reg|OPA_DR, OPT_Imm|OPA_Imm|OPI_9PC, 0} }
};

static const lc3b_insn_info ldst_insn[] = {
    { MOD_OpHAdd, 0x0000, 3,
      {OPT_Reg|OPA_DR, OPT_Reg|OPA_SR, OPT_Imm|OPA_Imm|OPI_6W} }
};

static const lc3b_insn_info ldstb_insn[] = {
    { MOD_OpHAdd, 0x0000, 3,
      {OPT_Reg|OPA_DR, OPT_Reg|OPA_SR, OPT_Imm|OPA_Imm|OPI_6B} }
};

static const lc3b_insn_info not_insn[] = {
    { 0, 0x903F, 2, {OPT_Reg|OPA_DR, OPT_Reg|OPA_SR, 0} }
};

static const lc3b_insn_info nooperand_insn[] = {
    { MOD_OpHAdd, 0x0000, 0, {0, 0, 0} }
};

static const lc3b_insn_info shift_insn[] = {
    { MOD_OpLAdd, 0xD000, 3,
      {OPT_Reg|OPA_DR, OPT_Reg|OPA_SR, OPT_Imm|OPA_Imm|OPI_4} }
};

static const lc3b_insn_info trap_insn[] = {
    { 0, 0xF000, 1, {OPT_Imm|OPA_Imm|OPI_8, 0, 0} }
};

yasm_bytecode *
yasm_lc3b__parse_insn(yasm_arch *arch, const unsigned long data[4],
		      int num_operands, yasm_insn_operands *operands,
		      yasm_bytecode *prev_bc, unsigned long line)
{
    lc3b_new_insn_data d;
    int num_info = (int)(data[1]&0xFF);
    lc3b_insn_info *info = (lc3b_insn_info *)data[0];
    unsigned long mod_data = data[1] >> 8;
    int found = 0;
    yasm_insn_operand *op;
    int i;

    /* Just do a simple linear search through the info array for a match.
     * First match wins.
     */
    for (; num_info>0 && !found; num_info--, info++) {
	int mismatch = 0;

	/* Match # of operands */
	if (num_operands != info->num_operands)
	    continue;

	if (!operands) {
	    found = 1;	    /* no operands -> must have a match here. */
	    break;
	}

	/* Match each operand type and size */
	for(i = 0, op = yasm_ops_first(operands); op && i<info->num_operands &&
	    !mismatch; op = yasm_operand_next(op), i++) {
	    /* Check operand type */
	    switch ((int)(info->operands[i] & OPT_MASK)) {
		case OPT_Imm:
		    if (op->type != YASM_INSN__OPERAND_IMM)
			mismatch = 1;
		    break;
		case OPT_Reg:
		    if (op->type != YASM_INSN__OPERAND_REG)
			mismatch = 1;
		    break;
		default:
		    yasm_internal_error(N_("invalid operand type"));
	    }

	    if (mismatch)
		break;
	}

	if (!mismatch) {
	    found = 1;
	    break;
	}
    }

    if (!found) {
	/* Didn't find a matching one */
	yasm__error(line, N_("invalid combination of opcode and operands"));
	return NULL;
    }

    /* Copy what we can from info */
    d.line = line;
    d.imm = NULL;
    d.imm_type = LC3B_IMM_NONE;
    d.origin = NULL;
    d.opcode = info->opcode;

    /* Apply modifiers */
    if (info->modifiers & MOD_OpHAdd) {
	d.opcode += ((unsigned int)(mod_data & 0xFF))<<8;
	mod_data >>= 8;
    }
    if (info->modifiers & MOD_OpLAdd) {
	d.opcode += (unsigned int)(mod_data & 0xFF);
	/*mod_data >>= 8;*/
    }

    /* Go through operands and assign */
    if (operands) {
	for(i = 0, op = yasm_ops_first(operands); op && i<info->num_operands;
	    op = yasm_operand_next(op), i++) {
	    switch ((int)(info->operands[i] & OPA_MASK)) {
		case OPA_None:
		    /* Throw away the operand contents */
		    if (op->type == YASM_INSN__OPERAND_IMM)
			yasm_expr_destroy(op->data.val);
		    break;
		case OPA_DR:
		    if (op->type != YASM_INSN__OPERAND_REG)
			yasm_internal_error(N_("invalid operand conversion"));
		    d.opcode |= ((unsigned int)(op->data.reg & 0x7)) << 9;
		    break;
		case OPA_SR:
		    if (op->type != YASM_INSN__OPERAND_REG)
			yasm_internal_error(N_("invalid operand conversion"));
		    d.opcode |= ((unsigned int)(op->data.reg & 0x7)) << 6;
		    break;
		case OPA_Imm:
		    switch (op->type) {
			case YASM_INSN__OPERAND_IMM:
			    d.imm = op->data.val;
			    break;
			case YASM_INSN__OPERAND_REG:
			    d.imm = yasm_expr_create_ident(yasm_expr_int(
				yasm_intnum_create_uint(op->data.reg & 0x7)),
				line);
			    break;
			default:
			    yasm_internal_error(N_("invalid operand conversion"));
		    }
		    break;
		default:
		    yasm_internal_error(N_("unknown operand action"));
	    }

	    d.imm_type = (info->operands[i] & OPI_MASK)>>3;
	    if (d.imm_type == LC3B_IMM_9_PC)
		d.origin = yasm_symtab_define_label2("$", prev_bc, 0, line);
	}
    }

    /* Create the bytecode and return it */
    return yasm_lc3b__bc_create_insn(&d);
}


#define YYCTYPE		char
#define YYCURSOR	id
#define YYLIMIT		id
#define YYMARKER	marker
#define YYFILL(n)

#line 336 "./modules/arch/lc3b/lc3bid.re"


void
yasm_lc3b__parse_cpu(yasm_arch *arch, const char *id, unsigned long line)
{
}

yasm_arch_check_id_retval
yasm_lc3b__parse_check_id(yasm_arch *arch, unsigned long data[4],
			  const char *id, unsigned long line)
{
    const char *oid = id;
    /*const char *marker;*/
    
#line 327 "lc3bid.c"
{
	YYCTYPE yych;

	goto yy0;
	++YYCURSOR;
yy0:
	if((YYLIMIT - YYCURSOR) < 6) YYFILL(6);
	yych = *YYCURSOR;
	if(yych <= 'T'){
		if(yych <= 'K'){
			if(yych <= 'A'){
				if(yych <= '\000')	goto yy13;
				if(yych <= '@')	goto yy11;
				goto yy4;
			} else {
				if(yych <= 'B')	goto yy5;
				if(yych == 'J')	goto yy6;
				goto yy11;
			}
		} else {
			if(yych <= 'N'){
				if(yych <= 'L')	goto yy7;
				if(yych <= 'M')	goto yy11;
				goto yy9;
			} else {
				if(yych <= 'Q')	goto yy11;
				if(yych <= 'R')	goto yy2;
				if(yych <= 'S')	goto yy8;
				goto yy10;
			}
		}
	} else {
		if(yych <= 'l'){
			if(yych <= 'b'){
				if(yych <= '`')	goto yy11;
				if(yych <= 'a')	goto yy4;
				goto yy5;
			} else {
				if(yych == 'j')	goto yy6;
				if(yych <= 'k')	goto yy11;
				goto yy7;
			}
		} else {
			if(yych <= 'q'){
				if(yych == 'n')	goto yy9;
				goto yy11;
			} else {
				if(yych <= 'r')	goto yy2;
				if(yych <= 's')	goto yy8;
				if(yych <= 't')	goto yy10;
				goto yy11;
			}
		}
	}
yy2:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych <= 'D'){
			if(yych <= '/')	goto yy12;
			if(yych <= '7')	goto yy69;
			goto yy12;
		} else {
			if(yych <= 'E')	goto yy71;
			if(yych <= 'R')	goto yy12;
			goto yy72;
		}
	} else {
		if(yych <= 'e'){
			if(yych <= 'T')	goto yy73;
			if(yych <= 'd')	goto yy12;
			goto yy71;
		} else {
			if(yych <= 'r')	goto yy12;
			if(yych <= 's')	goto yy72;
			if(yych <= 't')	goto yy73;
			goto yy12;
		}
	}
yy3:
#line 396 "./modules/arch/lc3b/lc3bid.re"
{
	    return YASM_ARCH_CHECK_ID_NONE;
	}
#line 410 "lc3bid.c"
yy4:	yych = *++YYCURSOR;
	if(yych <= 'N'){
		if(yych == 'D')	goto yy63;
		if(yych <= 'M')	goto yy12;
		goto yy64;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy12;
			goto yy63;
		} else {
			if(yych == 'n')	goto yy64;
			goto yy12;
		}
	}
yy5:	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy47;
	if(yych == 'r')	goto yy47;
	goto yy12;
yy6:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'M')	goto yy41;
		if(yych <= 'R')	goto yy12;
		goto yy42;
	} else {
		if(yych <= 'm'){
			if(yych <= 'l')	goto yy12;
			goto yy41;
		} else {
			if(yych == 's')	goto yy42;
			goto yy12;
		}
	}
yy7:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych <= 'D'){
			if(yych <= 'C')	goto yy12;
			goto yy28;
		} else {
			if(yych <= 'E')	goto yy30;
			if(yych <= 'R')	goto yy12;
			goto yy31;
		}
	} else {
		if(yych <= 'e'){
			if(yych <= 'c')	goto yy12;
			if(yych <= 'd')	goto yy28;
			goto yy30;
		} else {
			if(yych == 's')	goto yy31;
			goto yy12;
		}
	}
yy8:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy22;
	if(yych == 't')	goto yy22;
	goto yy12;
yy9:	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy19;
	if(yych == 'o')	goto yy19;
	goto yy12;
yy10:	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy15;
	if(yych == 'r')	goto yy15;
	goto yy12;
yy11:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy12:	if(yych <= '\000')	goto yy3;
	goto yy11;
yy13:	yych = *++YYCURSOR;

#line 399 "./modules/arch/lc3b/lc3bid.re"
{
	    return YASM_ARCH_CHECK_ID_NONE;
	}
#line 486 "lc3bid.c"
yy15:	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy16;
	if(yych != 'a')	goto yy12;
yy16:	yych = *++YYCURSOR;
	if(yych == 'P')	goto yy17;
	if(yych != 'p')	goto yy12;
yy17:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy11;

#line 393 "./modules/arch/lc3b/lc3bid.re"
{ RET_INSN(trap, 0); }
#line 498 "lc3bid.c"
yy19:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy20;
	if(yych != 't')	goto yy12;
yy20:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy11;

#line 384 "./modules/arch/lc3b/lc3bid.re"
{ RET_INSN(not, 0); }
#line 507 "lc3bid.c"
yy22:	yych = *++YYCURSOR;
	if(yych <= 'I'){
		if(yych <= 'A'){
			if(yych >= '\001')	goto yy11;
		} else {
			if(yych <= 'B')	goto yy26;
			if(yych <= 'H')	goto yy11;
			goto yy24;
		}
	} else {
		if(yych <= 'b'){
			if(yych <= 'a')	goto yy11;
			goto yy26;
		} else {
			if(yych == 'i')	goto yy24;
			goto yy11;
		}
	}

#line 378 "./modules/arch/lc3b/lc3bid.re"
{ RET_INSN(ldst, 0x30); }
#line 529 "lc3bid.c"
yy24:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy11;

#line 379 "./modules/arch/lc3b/lc3bid.re"
{ RET_INSN(ldst, 0xB0); }
#line 535 "lc3bid.c"
yy26:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy11;

#line 382 "./modules/arch/lc3b/lc3bid.re"
{ RET_INSN(ldstb, 0x70); }
#line 541 "lc3bid.c"
yy28:	yych = *++YYCURSOR;
	if(yych <= 'I'){
		if(yych <= 'A'){
			if(yych >= '\001')	goto yy11;
		} else {
			if(yych <= 'B')	goto yy39;
			if(yych <= 'H')	goto yy11;
			goto yy37;
		}
	} else {
		if(yych <= 'b'){
			if(yych <= 'a')	goto yy11;
			goto yy39;
		} else {
			if(yych == 'i')	goto yy37;
			goto yy11;
		}
	}

#line 376 "./modules/arch/lc3b/lc3bid.re"
{ RET_INSN(ldst, 0x20); }
#line 563 "lc3bid.c"
yy30:	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy35;
	if(yych == 'a')	goto yy35;
	goto yy12;
yy31:	yych = *++YYCURSOR;
	if(yych == 'H')	goto yy32;
	if(yych != 'h')	goto yy12;
yy32:	yych = *++YYCURSOR;
	if(yych == 'F')	goto yy33;
	if(yych != 'f')	goto yy12;
yy33:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy11;

#line 389 "./modules/arch/lc3b/lc3bid.re"
{ RET_INSN(shift, 0x00); }
#line 579 "lc3bid.c"
yy35:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy11;

#line 374 "./modules/arch/lc3b/lc3bid.re"
{ RET_INSN(lea, 0); }
#line 585 "lc3bid.c"
yy37:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy11;

#line 377 "./modules/arch/lc3b/lc3bid.re"
{ RET_INSN(ldst, 0xA0); }
#line 591 "lc3bid.c"
yy39:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy11;

#line 381 "./modules/arch/lc3b/lc3bid.re"
{ RET_INSN(ldstb, 0x60); }
#line 597 "lc3bid.c"
yy41:	yych = *++YYCURSOR;
	if(yych == 'P')	goto yy45;
	if(yych == 'p')	goto yy45;
	goto yy12;
yy42:	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy43;
	if(yych != 'r')	goto yy12;
yy43:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy11;

#line 370 "./modules/arch/lc3b/lc3bid.re"
{ RET_INSN(br, 0x40); }
#line 610 "lc3bid.c"
yy45:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy11;

#line 372 "./modules/arch/lc3b/lc3bid.re"
{ RET_INSN(jmp, 0); }
#line 616 "lc3bid.c"
yy47:	yych = *++YYCURSOR;
	if(yych <= 'Z'){
		if(yych <= 'N'){
			if(yych <= '\000')	goto yy48;
			if(yych <= 'M')	goto yy11;
			goto yy49;
		} else {
			if(yych == 'P')	goto yy53;
			if(yych <= 'Y')	goto yy11;
			goto yy51;
		}
	} else {
		if(yych <= 'o'){
			if(yych == 'n')	goto yy49;
			goto yy11;
		} else {
			if(yych <= 'p')	goto yy53;
			if(yych == 'z')	goto yy51;
			goto yy11;
		}
	}
yy48:
#line 362 "./modules/arch/lc3b/lc3bid.re"
{ RET_INSN(br, 0x00); }
#line 641 "lc3bid.c"
yy49:	yych = *++YYCURSOR;
	if(yych <= 'Z'){
		if(yych <= 'O'){
			if(yych >= '\001')	goto yy11;
		} else {
			if(yych <= 'P')	goto yy57;
			if(yych <= 'Y')	goto yy11;
			goto yy59;
		}
	} else {
		if(yych <= 'p'){
			if(yych <= 'o')	goto yy11;
			goto yy57;
		} else {
			if(yych == 'z')	goto yy59;
			goto yy11;
		}
	}

#line 363 "./modules/arch/lc3b/lc3bid.re"
{ RET_INSN(br, 0x08); }
#line 663 "lc3bid.c"
yy51:	yych = *++YYCURSOR;
	if(yych <= 'P'){
		if(yych <= '\000')	goto yy52;
		if(yych <= 'O')	goto yy11;
		goto yy55;
	} else {
		if(yych == 'p')	goto yy55;
		goto yy11;
	}
yy52:
#line 364 "./modules/arch/lc3b/lc3bid.re"
{ RET_INSN(br, 0x04); }
#line 676 "lc3bid.c"
yy53:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy11;

#line 365 "./modules/arch/lc3b/lc3bid.re"
{ RET_INSN(br, 0x02); }
#line 682 "lc3bid.c"
yy55:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy11;

#line 368 "./modules/arch/lc3b/lc3bid.re"
{ RET_INSN(br, 0x06); }
#line 688 "lc3bid.c"
yy57:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy11;

#line 367 "./modules/arch/lc3b/lc3bid.re"
{ RET_INSN(br, 0x0A); }
#line 694 "lc3bid.c"
yy59:	yych = *++YYCURSOR;
	if(yych <= 'P'){
		if(yych <= '\000')	goto yy60;
		if(yych <= 'O')	goto yy11;
		goto yy61;
	} else {
		if(yych == 'p')	goto yy61;
		goto yy11;
	}
yy60:
#line 366 "./modules/arch/lc3b/lc3bid.re"
{ RET_INSN(br, 0x0C); }
#line 707 "lc3bid.c"
yy61:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy11;

#line 369 "./modules/arch/lc3b/lc3bid.re"
{ RET_INSN(br, 0x0E); }
#line 713 "lc3bid.c"
yy63:	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy67;
	if(yych == 'd')	goto yy67;
	goto yy12;
yy64:	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy65;
	if(yych != 'd')	goto yy12;
yy65:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy11;

#line 360 "./modules/arch/lc3b/lc3bid.re"
{ RET_INSN(addand, 0x40); }
#line 726 "lc3bid.c"
yy67:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy11;

#line 359 "./modules/arch/lc3b/lc3bid.re"
{ RET_INSN(addand, 0x00); }
#line 732 "lc3bid.c"
yy69:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy11;

#line 352 "./modules/arch/lc3b/lc3bid.re"
{
	    data[0] = (oid[1]-'0');
	    return YASM_ARCH_CHECK_ID_REG;
	}
#line 741 "lc3bid.c"
yy71:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy82;
	if(yych == 't')	goto yy82;
	goto yy12;
yy72:	yych = *++YYCURSOR;
	if(yych == 'H')	goto yy76;
	if(yych == 'h')	goto yy76;
	goto yy12;
yy73:	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy74;
	if(yych != 'i')	goto yy12;
yy74:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy11;

#line 387 "./modules/arch/lc3b/lc3bid.re"
{ RET_INSN(nooperand, 0x80); }
#line 758 "lc3bid.c"
yy76:	yych = *++YYCURSOR;
	if(yych == 'F')	goto yy77;
	if(yych != 'f')	goto yy12;
yy77:	yych = *++YYCURSOR;
	if(yych <= 'L'){
		if(yych == 'A')	goto yy80;
		if(yych <= 'K')	goto yy12;
	} else {
		if(yych <= 'a'){
			if(yych <= '`')	goto yy12;
			goto yy80;
		} else {
			if(yych != 'l')	goto yy12;
		}
	}
	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy11;

#line 390 "./modules/arch/lc3b/lc3bid.re"
{ RET_INSN(shift, 0x10); }
#line 779 "lc3bid.c"
yy80:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy11;

#line 391 "./modules/arch/lc3b/lc3bid.re"
{ RET_INSN(shift, 0x30); }
#line 785 "lc3bid.c"
yy82:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy11;

#line 386 "./modules/arch/lc3b/lc3bid.re"
{ RET_INSN(nooperand, 0xCE); }
#line 791 "lc3bid.c"
}
#line 402 "./modules/arch/lc3b/lc3bid.re"

}
