//
// This file is part of libyacurs.
// Copyright (C) 2013  Rafael Ostertag
//
// This program is free software: you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation, either version 3 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see
// <http://www.gnu.org/licenses/>.
//
//
// $Id$
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "gettext.h"

#include <cassert>
#include <cstdlib>

#include "radiobox.h"
#include "yacursex.h"

using namespace YACURS;

//
// Private
//

RadioBox&
RadioBox::operator=(const RadioBox&) {
    throw EXCEPTIONS::NotSupported();
    return *this;
}

//
// Protected
//


//
// Public
//

RadioBox::RadioBox(const std::string& _title,
                   const std::vector<std::string>& _items) :
    CheckBox(_title, _items) {
    __indicators[0] = "( ) ";
    __indicators[1] = "(o) ";
}

RadioBox::~RadioBox() {
}

void
RadioBox::set_selection(unsigned short _cursor) {
    if (_cursor >= __items.size() )
	throw std::out_of_range(_("RadioBox cursor out of range in set_selection()"));

    for (std::vector<INTERNAL::Selectable>::size_type i = 0;
         i < __items.size();
         i++)
        __items[i].selected = false;

    __items[_cursor].selected = true;
}

void
RadioBox::set_selection(const std::string& _i) {
    CheckBox::set_selection(_i);
}
