/*************************************************************************
*  Copyright (C) 2008 by Vincent Richefeu                                *
*  vincent.richefeu@hmg.inpg.fr                                          *
*                                                                        *
*  This program is free software; it is licensed under the terms of the  *
*  GNU General Public License v2 or later. See file LICENSE for details. *
*************************************************************************/

/* ATTENTION : si DK8_BUFDIM est trop petit, il y a risque de plantage 
 */

char * DK8(double D)
{
  static int ich = 0;
  static char CH[DK8_BUFDIM][15];
  
  if (ich == DK8_BUFDIM)
    ich = 0; 

  sprintf(&CH[ich][0], "%14.7E", D);
  CH[ich][10] = 'D';
  ich++;

  return &CH[ich - 1][0];
}

void
bd_bodiesInit ()
{
  outfile = fopen ("BODIES.DAT", "w");

  fprintf (outfile, "! File generated by mgpost v%s\n", MGP_VERSION);
  fprintf (outfile, "!\n");
  fprintf (outfile, "! The symbol    bdyty   stands for  body type data.\n");
  fprintf (outfile, "! These data are distributed according to some species\n");
  fprintf (outfile, "!\n");
  fprintf (outfile, "! the specy     blmty   stands for  bulk element type data ,\n");
  fprintf (outfile, "! i.e. part or total bulk geometric description\n");
  fprintf (outfile, "! and bulk behaviour laws;\n");
  fprintf (outfile, "!\n");
  fprintf (outfile, "! the specy     nodty   stands for  node type data ,\n");
  fprintf (outfile, "! i.e. degrees of freedom data;\n");
  fprintf (outfile, "!\n");
  fprintf (outfile, "! the specy     tacty   stands for  contactor type data ;\n");
  fprintf (outfile, "!\n");
  fprintf (outfile, "! the keyword   $$$$$$  ends a body record.\n");
  fprintf (outfile, "!\n\n");
 
}

void
bd_bodiesDISKx (int id, double x, double y, double r)
{
  fprintf(outfile,"$bdyty\n");
  fprintf(outfile," RBDY2 % 6d\n", id);
  fprintf(outfile,"$blmty\n");
  fprintf(outfile," PLAIN % 6d  behav  PLEXx  avrd=%s  gyrd=%s\n", 1, 
		   DK8(0.0), DK8(0.0));
  fprintf(outfile,"$nodty\n");
  fprintf(outfile," NO3xx % 6d                coo1=%s  coo2=%s  coo3=%s\n", 1,
		  DK8(x), DK8(y), DK8(0.0));
  fprintf(outfile,"$tacty\n");
  fprintf(outfile," DISKx % 6d  color  BLEUx  byrd=%s\n", 1, DK8(r));
  fprintf(outfile,"$$$$$$\n\n");
}

void
bd_bodiesSPHER (int id, double x, double y, double z, double r)
{
  fprintf(outfile,"$bdyty\n");
  fprintf(outfile," RBDY2 % 6d\n", id);
  fprintf(outfile,"$blmty\n");
  fprintf(outfile," PLAIN % 6d  behav  PLEXx  avrd=%s  gyrd=%s\n", 1, 
		  DK8(0.0), DK8(0.0));
  fprintf(outfile,"$nodty\n");
  fprintf(outfile," NO3xx % 6d                coo1=%s  coo2=%s  coo3=%s\n", 1,
		  DK8(x), DK8(y), DK8(z));
  fprintf(outfile,"                           coo4=%s  coo5=%s  coo6=%s\n",
		  DK8(0.0), DK8(0.0), DK8(0.0));
  fprintf(outfile,"$tacty\n");
  fprintf(outfile," SPHER % 6d  color  BLEUx  byrd=%s\n", 1,
		  DK8(r));
  fprintf(outfile,"$$$$$$\n\n");
}

void
bd_bodiesJONCx (int id, double x, double y, double ax1, double ax2, int flag)
{
  double rot;

  if (flag == 1)
    rot = 1.5708;
  else
    rot = 0.0;

  fprintf(outfile,"$bdyty\n");
  fprintf(outfile," RBDY2 % 6d\n",id);
  fprintf(outfile,"$blmty\n");
  fprintf(outfile," PLAIN % 6d  behav  PLEXx  avrd=%s  gyrd=%s\n", 1,
		  DK8(0.0), DK8(0.0));
  fprintf(outfile,"$nodty\n");
  fprintf(outfile," NO3xx % 6d                coo1=%s  coo2=%s  coo3=%s\n", 1,
		  DK8(x), DK8(y), DK8(0.0));
  fprintf(outfile,"$tacty\n");
  fprintf(outfile," JONCx % 6d  color  BLEUx   ax1=%s   ax2=%s\n", 1,
		  DK8(ax1), DK8(ax2));
  fprintf(outfile,"$$$$$$\n\n");
}

void
bd_bodiesWALxx (int id, double pos, const char * orient)
{
  fprintf (stderr, "WALxx non disponible dans le format LMGC90 !!\n");
}

void
bd_bodiesClose ()
{
  fclose (outfile);
  fprintf (stdout, "Le fichier 'BODIES.DAT' a ete cree\n");
}


