/* rec_baseline.h -- correct stroke coordinates according to inferred baseline

   Copyright 2001 Carl Worth

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
*/

#ifndef REC_BASELINE_H
#define REC_BASELINE_H

/* need pt_t */
#include "stroke.h"

#define REC_BASELINE_PRECISION_BITS 8
#define REC_BASELINE_HISTORY_MAX 5
struct rec_baseline
{
    double orientation;
    double history[REC_BASELINE_HISTORY_MAX];
    int correction_matrix[2][2];
};
typedef struct rec_baseline rec_baseline_t;

int rec_baseline_init(rec_baseline_t *baseline);
void rec_baseline_deinit(rec_baseline_t *baseline);

void rec_baseline_correct(rec_baseline_t *baseline, int *x, int *y);
void rec_baseline_nudge(rec_baseline_t *baseline, double correction);

#endif

