#include <stdio.h>
#include <stdlib.h>

#include <X11/Xlib.h>
#include <X11/extensions/XTest.h>

int main(void)
{
    Display *dpy;
    int scr;
    XEvent xev;
    Window root;

    dpy = XOpenDisplay(NULL);
    if (dpy == NULL) {
	exit(1);
    }
    scr = DefaultScreen(dpy);
    root = DefaultRootWindow(dpy);

    printf("Welcome to Carl Worth's test of grab passing.\n"
	   "Click Button1 to get a grab and try to pass it through with XTest.\n"
	   "Click any other button to get a grab and pass it through with XAllowEvents.\n\n");

    XGrabButton(dpy, AnyButton, AnyModifier, root,
		True, ButtonPressMask | ButtonMotionMask | ButtonReleaseMask,
		GrabModeSync, GrabModeAsync, None, None);
    while (1) {
	XNextEvent(dpy, &xev);
	switch (xev.type) {
	case ButtonPress: {
	    printf("Got a grab\n");
	    if (xev.xbutton.button != 1) {
		printf("Passing button through with XAllowEvents\n");
		XAllowEvents(dpy, ReplayPointer, CurrentTime);
	    } else {
		printf("Attempting to pass button through with XTest\n");

		XGrabServer(dpy);
		XAllowEvents(dpy, AsyncPointer, CurrentTime);
		XUngrabPointer(dpy, CurrentTime);
		XUngrabButton(dpy, AnyButton, AnyModifier, root);

		XTestFakeButtonEvent(dpy, xev.xbutton.button, False, CurrentTime);
		XTestFakeButtonEvent(dpy, xev.xbutton.button, True, CurrentTime);

		XGrabButton(dpy, AnyButton, AnyModifier, root,
			    True, ButtonPressMask | ButtonMotionMask | ButtonReleaseMask,
			    GrabModeSync, GrabModeAsync, None, None);

		XSync(dpy, False);
		XUngrabServer(dpy);
	    }
	    break;
	}
	}
    }

    return 0;
}
