/*
 * Copyright 2005 Luc Verhaegen.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef _VIA_MEMORY_H_
#define _VIA_MEMORY_H_ 1

/* Do this here because via_dri.h should be kept identical between dri and X
 * driver */
#ifdef XF86DRI

/* don't include local via_drm.h when using modular */
#ifdef HAVE_CONFIG_H
#include "drm/via_drm.h"
#else
#include "via_drm.h"
#endif

#endif /* XF86DRI */

#ifndef X_USE_LINEARFB
#define VIA_MEM_SLOTS  8
#endif

struct ViaMem {
    unsigned long  Base;  /* Offset into fb */
    unsigned long  Size;

    /*
     * DRI: drm_via_mem_t *
     * 4.4 and later: FBLinearPtr
     * earlier: NULL
     */
    void  *Private;
    unsigned long PrivateSize;

    void (*Free) (ScrnInfoPtr pScrn, struct ViaMem *Mem);
};

void ViaMemInit(ScrnInfoPtr pScrn,  ScreenPtr pScreen);
struct ViaMem *ViaMemAlloc(ScrnInfoPtr pScrn, unsigned long size, CARD8 alignment);
void ViaMemFree(ScrnInfoPtr pScrn, struct ViaMem *Mem);

#endif /* _VIA_MEMORY_H_ */
