/*
 * Copyright 2004-2005 Luc Verhaegen.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 * DEALINGS IN THE SOFTWARE.
 */
#ifndef _VIA_ID_H_
#define _VIA_ID_H_ 1

/* Chip tags.  These are used to group the adapters into
 * related families.
 *
 * Sadly, VIA has a completely insane naming structure. I have no
 * other option but to represent them with VT<pci device id>.
 */
enum VIACHIPTAGS {
    VIA_UNKNOWN = 0,
    VT3122, /* CLE266 */
    VT7205, /* KM400, P4M800 */
    VT3108, /* K8M800 */
    VT3118, /* PM800, CN400, PM880, whatever. */
    VT3344, /* P4M800Pro, CN700, VN800 */
    VT3157, /* Still unreleased CX700 */
    VT3230, /* K8M890 */
    VT3343, /* Still unreleased P4M890 */
    VIA_LAST 
};


#define PCI_VENDOR_VIA  0x1106

#define PCI_CHIP_VT3122  0x3122
#define PCI_CHIP_VT7205  0x7205
#define PCI_CHIP_VT3108  0x3108
#define PCI_CHIP_VT3118  0x3118
#define PCI_CHIP_VT3344  0x3344
#define PCI_CHIP_VT3157  0x3157
#define PCI_CHIP_VT3230  0x3230
#define PCI_CHIP_VT3343  0x3343

/*
 * There is also quite some conflicting information on the
 * 2 major revisions of the CLE266, oft labelled as Ax and Cx
 * It seems to center around 
 *        ChipRev > 15 == Cx
 *   and
 *        ChipRev < 15 == Ax
 * There is only one case in original xfree86 code where 15 is
 * handled; in via_bandwidth.c:
 *   if (pBIOSInfo->ChipRev > 14) {  // For 3123Cx
 * While setting the primary fifo, the secondary is > 15 again.
 *
 * So does this rule out the existence of CLE266B?
 *
 * It seems to be 0x10, anything from that and up is Cx, anything
 * below is Ax
 */
#define VT3122_REV_IS_CX(x) ((x) >= 0x10)
#define VT3122_REV_IS_AX(x) ((x) < 0x10)

struct ViaCardId {
    char*  String;   /* Full identification string. */
    CARD8  Chip;     /* Which unichrome device? */
    CARD16 Vendor;   /* PCI Card/Subsystem vendor id */
    CARD16 Device;   /* PCI Card/Subsystem device id */
    Bool   HasPanel; /* Will remain neccessary for TTL panels */
};

void ViaCheckCardId(ScrnInfoPtr pScrn);

#endif /* _VIA_ID_H_ */
