/* $XFree86: xc/programs/Xserver/GL/glx/glxserver.h,v 1.4 2001/08/23 18:25:40 alanh Exp $ */
#ifndef _GLX_server_h_
#define _GLX_server_h_

/*
** License Applicability. Except to the extent portions of this file are
** made subject to an alternative license as permitted in the SGI Free
** Software License B, Version 1.1 (the "License"), the contents of this
** file are subject only to the provisions of the License. You may not use
** this file except in compliance with the License. You may obtain a copy
** of the License at Silicon Graphics, Inc., attn: Legal Services, 1600
** Amphitheatre Parkway, Mountain View, CA 94043-1351, or at:
** 
** http://oss.sgi.com/projects/FreeB
** 
** Note that, as provided in the License, the Software is distributed on an
** "AS IS" basis, with ALL EXPRESS AND IMPLIED WARRANTIES AND CONDITIONS
** DISCLAIMED, INCLUDING, WITHOUT LIMITATION, ANY IMPLIED WARRANTIES AND
** CONDITIONS OF MERCHANTABILITY, SATISFACTORY QUALITY, FITNESS FOR A
** PARTICULAR PURPOSE, AND NON-INFRINGEMENT.
** 
** Original Code. The Original Code is: OpenGL Sample Implementation,
** Version 1.2.1, released January 26, 2000, developed by Silicon Graphics,
** Inc. The Original Code is Copyright (c) 1991-2000 Silicon Graphics, Inc.
** Copyright in any portions created by third parties is as indicated
** elsewhere herein. All Rights Reserved.
** 
** Additional Notice Provisions: The application programming interfaces
** established by SGI in conjunction with the Original Code are The
** OpenGL(R) Graphics System: A Specification (Version 1.2.1), released
** April 1, 1999; The OpenGL(R) Graphics System Utility Library (Version
** 1.3), released November 4, 1998; and OpenGL(R) Graphics with the X
** Window System(R) (Version 1.3), released October 19, 1998. This software
** was created using the OpenGL(R) version 1.2.1 Sample Implementation
** published by SGI, but has not been independently verified as being
** compliant with the OpenGL(R) version 1.2.1 Specification.
**
*/

#include <X11/X.h>
#include <X11/Xproto.h>
#include <X11/Xmd.h>
#include <misc.h>
#include <dixstruct.h>
#include <pixmapstr.h>
#include <gcstruct.h>
#include <extnsionst.h>
#include <resource.h>
#include <scrnintstr.h>
#include "GL/glx_ansic.h"


/*
** The X header misc.h defines these math functions.
*/
#undef abs
#undef fabs

#define GL_GLEXT_PROTOTYPES /* we want prototypes */
#include <GL/gl.h>
#include <GL/glxproto.h>
#include <GL/glxint.h>

/* XXX: should go into glxext.h */
#ifndef GLX_EXT_render_texture
#define GLX_TEXTURE_TARGET_EXT	  0x6001
#define GLX_TEXTURE_2D_EXT	  0x6002
#define GLX_TEXTURE_RECTANGLE_EXT 0x6003
#define GLX_NO_TEXTURE_EXT	  0x6004
#define GLX_FRONT_LEFT_EXT	  0x6005
#endif

/* For glxscreens.h */
typedef struct __GLXdrawablePrivateRec __GLXdrawablePrivate;

#include "glxscreens.h"
#include "glxdrawable.h"
#include "glxcontext.h"
#include "glxerror.h"


#define GLX_SERVER_MAJOR_VERSION 1
#define GLX_SERVER_MINOR_VERSION 2

#ifndef True
#define True 1
#endif
#ifndef False
#define False 0
#endif

/*
** GLX resources.
*/
typedef XID GLXContextID;
typedef XID GLXPixmap;
typedef XID GLXDrawable;

typedef struct __GLXcontextRec *GLXContext;
typedef struct __GLXclientStateRec __GLXclientState;

extern __GLXscreenInfo *__glXActiveScreens;
extern GLint __glXNumActiveScreens;

/************************************************************************/

/*
** The last context used (from the server's persective) is cached.
*/
extern __GLXcontext *__glXLastContext;
extern __GLXcontext *__glXForceCurrent(__GLXclientState*, GLXContextTag, int*);

/*
** Macros to set, unset, and retrieve the flag that says whether a context
** has unflushed commands.
*/
#define __GLX_NOTE_UNFLUSHED_CMDS(glxc) glxc->hasUnflushedCommands = GL_TRUE
#define __GLX_NOTE_FLUSHED_CMDS(glxc) glxc->hasUnflushedCommands = GL_FALSE
#define __GLX_HAS_UNFLUSHED_CMDS(glxc) (glxc->hasUnflushedCommands)

/************************************************************************/

/*
** State kept per client.
*/
struct __GLXclientStateRec {
    /*
    ** Whether this structure is currently being used to support a client.
    */
    Bool inUse;

    /*
    ** Buffer for returned data.
    */
    GLbyte *returnBuf;
    GLint returnBufSize;

    /*
    ** Keep track of large rendering commands, which span multiple requests.
    */
    GLint largeCmdBytesSoFar;		/* bytes received so far	*/
    GLint largeCmdBytesTotal;		/* total bytes expected		*/
    GLint largeCmdRequestsSoFar;	/* requests received so far	*/
    GLint largeCmdRequestsTotal;	/* total requests expected	*/
    GLbyte *largeCmdBuf;
    GLint largeCmdBufSize;

    /*
    ** Keep a list of all the contexts that are current for this client's
    ** threads.
    */
    __GLXcontext **currentContexts;
    GLint numCurrentContexts;

    /* Back pointer to X client record */
    ClientPtr client;

    int GLClientmajorVersion;
    int GLClientminorVersion;
    char *GLClientextensions;
};

extern __GLXclientState *__glXClients[];

/************************************************************************/

/*
** Dispatch tables.
*/
typedef void (*__GLXdispatchRenderProcPtr)(GLbyte *);
typedef int (*__GLXdispatchSingleProcPtr)(__GLXclientState *, GLbyte *);
typedef int (*__GLXdispatchVendorPrivProcPtr)(__GLXclientState *, GLbyte *);

/*
 * Dispatch for GLX commands.
 */
typedef int (*__GLXprocPtr)(__GLXclientState *, char *pc);
extern __GLXprocPtr __glXProcTable[];

/*
 * Tables for computing the size of each rendering command.
 */
typedef struct {
    int bytes;
    int (*varsize)(GLbyte *pc, Bool swap);
} __GLXrenderSizeData;
extern __GLXrenderSizeData __glXRenderSizeTable[];
extern __GLXrenderSizeData __glXRenderSizeTable_EXT[];

/************************************************************************/

/*
** X resources.
*/
extern RESTYPE __glXContextRes;
extern RESTYPE __glXClientRes;
extern RESTYPE __glXPixmapRes;
extern RESTYPE __glXDrawableRes;

/************************************************************************/

/*
** Prototypes.
*/

extern char *__glXcombine_strings(const char *, const char *);

/*
** Routines for sending swapped replies.
*/

extern void __glXSwapMakeCurrentReply(ClientPtr client,
				      xGLXMakeCurrentReply *reply);
extern void __glXSwapIsDirectReply(ClientPtr client,
				   xGLXIsDirectReply *reply);
extern void __glXSwapQueryVersionReply(ClientPtr client,
				       xGLXQueryVersionReply *reply);
extern void __glXSwapQueryContextInfoEXTReply(ClientPtr client,
					      xGLXQueryContextInfoEXTReply *reply,
					      int *buf);
extern void glxSwapQueryExtensionsStringReply(ClientPtr client,
				xGLXQueryExtensionsStringReply *reply, char *buf);
extern void glxSwapQueryServerStringReply(ClientPtr client,
				xGLXQueryServerStringReply *reply, char *buf);
extern void __glXSwapGetDrawableAttributesReply(ClientPtr client, xGLXGetDrawableAttributesReply *reply, int *buf);


/*
 * Routines for computing the size of variably-sized rendering commands.
 */

extern int __glXTypeSize(GLenum enm);
extern int __glXImageSize(GLenum format, GLenum type, GLsizei w, GLsizei h,
			  GLint rowLength, GLint skipRows, GLint alignment);
extern int __glXImage3DSize(GLenum format, GLenum type,
			    GLsizei w, GLsizei h, GLsizei d,
			    GLint imageHeight, GLint rowLength,
			    GLint skipImages, GLint skipRows,
			    GLint alignment);

extern int __glXCallListsReqSize(GLbyte *pc, Bool swap);
extern int __glXBitmapReqSize(GLbyte *pc, Bool swap);
extern int __glXFogfvReqSize(GLbyte *pc, Bool swap);
extern int __glXFogivReqSize(GLbyte *pc, Bool swap);
extern int __glXLightfvReqSize(GLbyte *pc, Bool swap);
extern int __glXLightivReqSize(GLbyte *pc, Bool swap);
extern int __glXLightModelfvReqSize(GLbyte *pc, Bool swap);
extern int __glXLightModelivReqSize(GLbyte *pc, Bool swap);
extern int __glXMaterialfvReqSize(GLbyte *pc, Bool swap);
extern int __glXMaterialivReqSize(GLbyte *pc, Bool swap);
extern int __glXTexParameterfvReqSize(GLbyte *pc, Bool swap);
extern int __glXTexParameterivReqSize(GLbyte *pc, Bool swap);
extern int __glXTexImage1DReqSize(GLbyte *pc, Bool swap);
extern int __glXTexImage2DReqSize(GLbyte *pc, Bool swap);
extern int __glXTexEnvfvReqSize(GLbyte *pc, Bool swap);
extern int __glXTexEnvivReqSize(GLbyte *pc, Bool swap);
extern int __glXTexGendvReqSize(GLbyte *pc, Bool swap);
extern int __glXTexGenfvReqSize(GLbyte *pc, Bool swap);
extern int __glXTexGenivReqSize(GLbyte *pc, Bool swap);
extern int __glXMap1dReqSize(GLbyte *pc, Bool swap);
extern int __glXMap1fReqSize(GLbyte *pc, Bool swap);
extern int __glXMap2dReqSize(GLbyte *pc, Bool swap);
extern int __glXMap2fReqSize(GLbyte *pc, Bool swap);
extern int __glXPixelMapfvReqSize(GLbyte *pc, Bool swap);
extern int __glXPixelMapuivReqSize(GLbyte *pc, Bool swap);
extern int __glXPixelMapusvReqSize(GLbyte *pc, Bool swap);
extern int __glXDrawPixelsReqSize(GLbyte *pc, Bool swap);
extern int __glXDrawArraysSize(GLbyte *pc, Bool swap);
extern int __glXPrioritizeTexturesReqSize(GLbyte *pc, Bool swap);
extern int __glXTexSubImage1DReqSize(GLbyte *pc, Bool swap);
extern int __glXTexSubImage2DReqSize(GLbyte *pc, Bool swap);
extern int __glXTexImage3DReqSize(GLbyte *pc, Bool swap );
extern int __glXTexSubImage3DReqSize(GLbyte *pc, Bool swap);
extern int __glXConvolutionFilter1DReqSize(GLbyte *pc, Bool swap);
extern int __glXConvolutionFilter2DReqSize(GLbyte *pc, Bool swap);
extern int __glXConvolutionParameterivReqSize(GLbyte *pc, Bool swap);
extern int __glXConvolutionParameterfvReqSize(GLbyte *pc, Bool swap);
extern int __glXSeparableFilter2DReqSize(GLbyte *pc, Bool swap);
extern int __glXColorTableReqSize(GLbyte *pc, Bool swap);
extern int __glXColorSubTableReqSize(GLbyte *pc, Bool swap);
extern int __glXColorTableParameterfvReqSize(GLbyte *pc, Bool swap);
extern int __glXColorTableParameterivReqSize(GLbyte *pc, Bool swap);

/*
 * Routines for computing the size of returned data.
 */
extern int __glXConvolutionParameterivSize(GLenum pname);
extern int __glXConvolutionParameterfvSize(GLenum pname);
extern int __glXColorTableParameterfvSize(GLenum pname);
extern int __glXColorTableParameterivSize(GLenum pname);

extern int __glXPointParameterfvARBReqSize(GLbyte *pc, Bool swap);
extern int __glXPointParameterivReqSize(GLbyte *pc, Bool swap);

typedef struct _glProcTable {
    void (*NewList) (GLuint list, GLenum mode);
    void (*EndList) (void);
    void (*CallList) (GLuint list);
    void (*CallLists) (GLsizei n, GLenum type, const GLvoid *lists);
    void (*DeleteLists) (GLuint list, GLsizei range);
    GLuint (*GenLists) (GLsizei range);
    void (*ListBase) (GLuint base);
    void (*Begin) (GLenum mode);
    void (*Bitmap) (GLsizei width, GLsizei height,
		    GLfloat xorig, GLfloat yorig,
		    GLfloat xmove, GLfloat ymove,
		    const GLubyte *bitmap);
    void (*Color3bv) (const GLbyte *v);
    void (*Color3dv) (const GLdouble *v);
    void (*Color3fv) (const GLfloat *v);
    void (*Color3iv) (const GLint *v);
    void (*Color3sv) (const GLshort *v);
    void (*Color3ubv) (const GLubyte *v);
    void (*Color3uiv) (const GLuint *v);
    void (*Color3usv) (const GLushort *v);
    void (*Color4bv) (const GLbyte *v);
    void (*Color4dv) (const GLdouble *v);
    void (*Color4fv) (const GLfloat *v);
    void (*Color4iv) (const GLint *v);
    void (*Color4sv) (const GLshort *v);
    void (*Color4ubv) (const GLubyte *v);
    void (*Color4uiv) (const GLuint *v);
    void (*Color4usv) (const GLushort *v);
    void (*EdgeFlagv) (const GLboolean *flag);
    void (*End) (void);
    void (*Indexdv) (const GLdouble *c);
    void (*Indexfv) (const GLfloat *c);
    void (*Indexiv) (const GLint *c);
    void (*Indexsv) (const GLshort *c);
    void (*Normal3bv) (const GLbyte *v);
    void (*Normal3dv) (const GLdouble *v);
    void (*Normal3fv) (const GLfloat *v);
    void (*Normal3iv) (const GLint *v);
    void (*Normal3sv) (const GLshort *v);
    void (*RasterPos2dv) (const GLdouble *v);
    void (*RasterPos2fv) (const GLfloat *v);
    void (*RasterPos2iv) (const GLint *v);
    void (*RasterPos2sv) (const GLshort *v);
    void (*RasterPos3dv) (const GLdouble *v);
    void (*RasterPos3fv) (const GLfloat *v);
    void (*RasterPos3iv) (const GLint *v);
    void (*RasterPos3sv) (const GLshort *v);
    void (*RasterPos4dv) (const GLdouble *v);
    void (*RasterPos4fv) (const GLfloat *v);
    void (*RasterPos4iv) (const GLint *v);
    void (*RasterPos4sv) (const GLshort *v);
    void (*Rectdv) (const GLdouble *v1, const GLdouble *v2);
    void (*Rectfv) (const GLfloat *v1, const GLfloat *v2);
    void (*Rectiv) (const GLint *v1, const GLint *v2);
    void (*Rectsv) (const GLshort *v1, const GLshort *v2);
    void (*TexCoord1dv) (const GLdouble *v);
    void (*TexCoord1fv) (const GLfloat *v);
    void (*TexCoord1iv) (const GLint *v);
    void (*TexCoord1sv) (const GLshort *v);
    void (*TexCoord2dv) (const GLdouble *v);
    void (*TexCoord2fv) (const GLfloat *v);
    void (*TexCoord2iv) (const GLint *v);
    void (*TexCoord2sv) (const GLshort *v);
    void (*TexCoord3dv) (const GLdouble *v);
    void (*TexCoord3fv) (const GLfloat *v);
    void (*TexCoord3iv) (const GLint *v);
    void (*TexCoord3sv) (const GLshort *v);
    void (*TexCoord4dv) (const GLdouble *v);
    void (*TexCoord4fv) (const GLfloat *v);
    void (*TexCoord4iv) (const GLint *v);
    void (*TexCoord4sv) (const GLshort *v);
    void (*Vertex2dv) (const GLdouble *v);
    void (*Vertex2fv) (const GLfloat *v);
    void (*Vertex2iv) (const GLint *v);
    void (*Vertex2sv) (const GLshort *v);
    void (*Vertex3dv) (const GLdouble *v);
    void (*Vertex3fv) (const GLfloat *v);
    void (*Vertex3iv) (const GLint *v);
    void (*Vertex3sv) (const GLshort *v);
    void (*Vertex4dv) (const GLdouble *v);
    void (*Vertex4fv) (const GLfloat *v);
    void (*Vertex4iv) (const GLint *v);
    void (*Vertex4sv) (const GLshort *v);
    void (*ClipPlane) (GLenum plane, const GLdouble *equation);
    void (*ColorMaterial) (GLenum face, GLenum mode);
    void (*CullFace) (GLenum mode);
    void (*Fogf) (GLenum pname, GLfloat param);
    void (*Fogfv) (GLenum pname, const GLfloat *params);
    void (*Fogi) (GLenum pname, GLint param);
    void (*Fogiv) (GLenum pname, const GLint *params);
    void (*FrontFace) (GLenum mode);
    void (*Hint) (GLenum target, GLenum mode);
    void (*Lightf) (GLenum light, GLenum pname, GLfloat param);
    void (*Lightfv) (GLenum light, GLenum pname, const GLfloat *params);
    void (*Lighti) (GLenum light, GLenum pname, GLint param);
    void (*Lightiv) (GLenum light, GLenum pname, const GLint *params);
    void (*LightModelf) (GLenum pname, GLfloat param);
    void (*LightModelfv) (GLenum pname, const GLfloat *params);
    void (*LightModeli) (GLenum pname, GLint param);
    void (*LightModeliv) (GLenum pname, const GLint *params);
    void (*LineStipple) (GLint factor, GLushort pattern);
    void (*LineWidth) (GLfloat width);
    void (*Materialf) (GLenum face, GLenum pname, GLfloat param);
    void (*Materialfv) (GLenum face, GLenum pname, const GLfloat *params);
    void (*Materiali) (GLenum face, GLenum pname, GLint param);
    void (*Materialiv) (GLenum face, GLenum pname, const GLint *params);
    void (*PointSize) (GLfloat size);
    void (*PolygonMode) (GLenum face, GLenum mode);
    void (*PolygonStipple) (const GLubyte *mask);
    void (*Scissor) (GLint x, GLint y, GLsizei width, GLsizei height);
    void (*ShadeModel) (GLenum mode);
    void (*TexParameterf) (GLenum target, GLenum pname, GLfloat param);
    void (*TexParameterfv) (GLenum target, GLenum pname,
			    const GLfloat *params);
    void (*TexParameteri) (GLenum target, GLenum pname, GLint param);
    void (*TexParameteriv) (GLenum target, GLenum pname, const GLint *params);
    void (*TexImage1D) (GLenum target, GLint level, GLint internalformat,
			GLsizei width, GLint border, GLenum format,
			GLenum type, const GLvoid *pixels);
    void (*TexImage2D) (GLenum target, GLint level, GLint internalformat,
			GLsizei width, GLsizei height, GLint border,
			GLenum format, GLenum type, const GLvoid *pixels);
    void (*TexEnvf) (GLenum target, GLenum pname, GLfloat param);
    void (*TexEnvfv) (GLenum target, GLenum pname, const GLfloat *params);
    void (*TexEnvi) (GLenum target, GLenum pname, GLint param);
    void (*TexEnviv) (GLenum target, GLenum pname, const GLint *params);
    void (*TexGend) (GLenum coord, GLenum pname, GLdouble param);
    void (*TexGendv) (GLenum coord, GLenum pname, const GLdouble *params);
    void (*TexGenf) (GLenum coord, GLenum pname, GLfloat param);
    void (*TexGenfv) (GLenum coord, GLenum pname, const GLfloat *params);
    void (*TexGeni) (GLenum coord, GLenum pname, GLint param);
    void (*TexGeniv) (GLenum coord, GLenum pname, const GLint *params);
    void (*FeedbackBuffer) (GLsizei size, GLenum type, GLfloat *buffer);
    void (*SelectBuffer) (GLsizei size, GLuint *buffer);
    GLint (*RenderMode) (GLenum mode);
    void (*InitNames) (void);
    void (*LoadName) (GLuint name);
    void (*PassThrough) (GLfloat token);
    void (*PopName) (void);
    void (*PushName) (GLuint name);
    void (*DrawBuffer) (GLenum mode);
    void (*Clear) (GLbitfield mask);
    void (*ClearAccum) (GLfloat red, GLfloat green, GLfloat blue,
			GLfloat alpha);
    void (*ClearIndex) (GLfloat c);
    void (*ClearColor) (GLclampf red, GLclampf green, GLclampf blue,
			GLclampf alpha);
    void (*ClearStencil) (GLint s);
    void (*ClearDepth) (GLclampd depth);
    void (*StencilMask) (GLuint mask);
    void (*ColorMask) (GLboolean red, GLboolean green, GLboolean blue,
		       GLboolean alpha);
    void (*DepthMask) (GLboolean flag);
    void (*IndexMask) (GLuint mask);
    void (*Accum) (GLenum op, GLfloat value);
    void (*Disable) (GLenum cap);
    void (*Enable) (GLenum cap);
    void (*Finish) (void);
    void (*Flush) (void);
    void (*PopAttrib) (void);
    void (*PushAttrib) (GLbitfield mask);
    void (*Map1d) (GLenum target, GLdouble u1, GLdouble u2, GLint stride,
		   GLint order, const GLdouble *points);
    void (*Map1f) (GLenum target, GLfloat u1, GLfloat u2, GLint stride,
		   GLint order, const GLfloat *points);
    void (*Map2d) (GLenum target, GLdouble u1, GLdouble u2, GLint ustride,
		   GLint uorder, GLdouble v1, GLdouble v2, GLint vstride,
		   GLint vorder, const GLdouble *points);
    void (*Map2f) (GLenum target, GLfloat u1, GLfloat u2, GLint ustride,
		   GLint uorder, GLfloat v1, GLfloat v2, GLint vstride,
		   GLint vorder, const GLfloat *points);
    void (*MapGrid1d) (GLint un, GLdouble u1, GLdouble u2);
    void (*MapGrid1f) (GLint un, GLfloat u1, GLfloat u2);
    void (*MapGrid2d) (GLint un, GLdouble u1, GLdouble u2, GLint vn,
		       GLdouble v1, GLdouble v2);
    void (*MapGrid2f) (GLint un, GLfloat u1, GLfloat u2, GLint vn,
		       GLfloat v1, GLfloat v2);
    void (*EvalCoord1dv) (const GLdouble *u);
    void (*EvalCoord1fv) (const GLfloat *u);
    void (*EvalCoord2dv) (const GLdouble *u);
    void (*EvalCoord2fv) (const GLfloat *u);
    void (*EvalMesh1) (GLenum mode, GLint i1, GLint i2);
    void (*EvalPoint1) (GLint i);
    void (*EvalMesh2) (GLenum mode, GLint i1, GLint i2, GLint j1, GLint j2);
    void (*EvalPoint2) (GLint i, GLint j);
    void (*AlphaFunc) (GLenum func, GLclampf ref);
    void (*BlendFunc) (GLenum sfactor, GLenum dfactor);
    void (*LogicOp) (GLenum opcode);
    void (*StencilFunc) (GLenum func, GLint ref, GLuint mask);
    void (*StencilOp) (GLenum fail, GLenum zfail, GLenum zpass);
    void (*DepthFunc) (GLenum func);
    void (*PixelZoom) (GLfloat xfactor, GLfloat yfactor);
    void (*PixelTransferf) (GLenum pname, GLfloat param);
    void (*PixelTransferi) (GLenum pname, GLint param);
    void (*PixelStoref) (GLenum pname, GLfloat param);
    void (*PixelStorei) (GLenum pname, GLint param);
    void (*PixelMapfv) (GLenum map, GLsizei mapsize, const GLfloat *values);
    void (*PixelMapuiv) (GLenum map, GLsizei mapsize, const GLuint *values);
    void (*PixelMapusv) (GLenum map, GLsizei mapsize, const GLushort *values);
    void (*ReadBuffer) (GLenum mode);
    void (*CopyPixels) (GLint x, GLint y, GLsizei width, GLsizei height,
			GLenum type);
    void (*ReadPixels) (GLint x, GLint y, GLsizei width, GLsizei height,
			GLenum format, GLenum type, GLvoid *pixels);
    void (*DrawPixels) (GLsizei width, GLsizei height, GLenum format,
			GLenum type, const GLvoid *pixels);
    void (*GetBooleanv) (GLenum pname, GLboolean *params);
    void (*GetClipPlane) (GLenum plane, GLdouble *equation);
    void (*GetDoublev) (GLenum pname, GLdouble *params);
    GLenum (*GetError) (void);
    void (*GetFloatv) (GLenum pname, GLfloat *params);
    void (*GetIntegerv) (GLenum pname, GLint *params);
    void (*GetLightfv) (GLenum light, GLenum pname, GLfloat *params);
    void (*GetLightiv) (GLenum light, GLenum pname, GLint *params);
    void (*GetMapdv) (GLenum target, GLenum query, GLdouble *v);
    void (*GetMapfv) (GLenum target, GLenum query, GLfloat *v);
    void (*GetMapiv) (GLenum target, GLenum query, GLint *v);
    void (*GetMaterialfv) (GLenum face, GLenum pname, GLfloat *params);
    void (*GetMaterialiv) (GLenum face, GLenum pname, GLint *params);
    void (*GetPixelMapfv) (GLenum map, GLfloat *values);
    void (*GetPixelMapuiv) (GLenum map, GLuint *values);
    void (*GetPixelMapusv) (GLenum map, GLushort *values);
    void (*GetPolygonStipple) (GLubyte *mask);
    const GLubyte *(*GetString) (GLenum name);
    void (*GetTexEnvfv) (GLenum target, GLenum pname, GLfloat *params);
    void (*GetTexEnviv) (GLenum target, GLenum pname, GLint *params);
    void (*GetTexGendv) (GLenum coord, GLenum pname, GLdouble *params);
    void (*GetTexGenfv) (GLenum coord, GLenum pname, GLfloat *params);
    void (*GetTexGeniv) (GLenum coord, GLenum pname, GLint *params);
    void (*GetTexImage) (GLenum target, GLint level, GLenum format,
			 GLenum type, GLvoid *pixels);
    void (*GetTexParameterfv) (GLenum target, GLenum pname, GLfloat *params);
    void (*GetTexParameteriv) (GLenum target, GLenum pname, GLint *params);
    void (*GetTexLevelParameterfv) (GLenum target, GLint level, GLenum pname,
				    GLfloat *params);
    void (*GetTexLevelParameteriv) (GLenum target, GLint level, GLenum pname,
				    GLint *params);
    GLboolean (*IsEnabled) (GLenum cap);
    GLboolean (*IsList) (GLuint list);
    void (*DepthRange) (GLclampd zNear, GLclampd zFar);
    void (*Frustum) (GLdouble left, GLdouble right, GLdouble bottom,
		     GLdouble top, GLdouble zNear, GLdouble zFar);
    void (*LoadIdentity) (void);
    void (*LoadMatrixf) (const GLfloat *m);
    void (*LoadMatrixd) (const GLdouble *m);
    void (*MatrixMode) (GLenum mode);
    void (*MultMatrixf) (const GLfloat *m);
    void (*MultMatrixd) (const GLdouble *m);
    void (*Ortho) (GLdouble left, GLdouble right, GLdouble bottom,
		   GLdouble top, GLdouble zNear, GLdouble zFar);
    void (*PopMatrix) (void);
    void (*PushMatrix) (void);
    void (*Rotated) (GLdouble angle, GLdouble x, GLdouble y, GLdouble z);
    void (*Rotatef) (GLfloat angle, GLfloat x, GLfloat y, GLfloat z);
    void (*Scaled) (GLdouble x, GLdouble y, GLdouble z);
    void (*Scalef) (GLfloat x, GLfloat y, GLfloat z);
    void (*Translated) (GLdouble x, GLdouble y, GLdouble z);
    void (*Translatef) (GLfloat x, GLfloat y, GLfloat z);
    void (*Viewport) (GLint x, GLint y, GLsizei width, GLsizei height);
    void (*ArrayElement) (GLint i);
    void (*BindTexture) (GLenum target, GLuint texture);
    void (*ColorPointer) (GLint size, GLenum type, GLsizei stride,
			  const GLvoid *pointer);
    void (*DisableClientState) (GLenum array);
    void (*DrawArrays) (GLenum mode, GLint first, GLsizei count);
    void (*DrawElements) (GLenum mode, GLsizei count, GLenum type,
			  const GLvoid *indices);
    void (*EdgeFlagPointer) (GLsizei stride, const GLvoid *pointer);
    void (*EnableClientState) (GLenum array);
    void (*IndexPointer) (GLenum type, GLsizei stride, const GLvoid *pointer);
    void (*Indexubv) (const GLubyte *c);
    void (*InterleavedArrays) (GLenum format, GLsizei stride,
			       const GLvoid *pointer);
    void (*NormalPointer) (GLenum type, GLsizei stride, const GLvoid *pointer);
    void (*PolygonOffset) (GLfloat factor, GLfloat units);
    void (*TexCoordPointer) (GLint size, GLenum type, GLsizei stride,
			     const GLvoid *pointer);
    void (*VertexPointer) (GLint size, GLenum type, GLsizei stride,
			   const GLvoid *pointer);
    GLboolean (*AreTexturesResident) (GLsizei n, const GLuint *textures,
				      GLboolean *residences);
    void (*CopyTexImage1D) (GLenum target, GLint level, GLenum internalformat,
			    GLint x, GLint y, GLsizei width, GLint border);
    void (*CopyTexImage2D) (GLenum target, GLint level, GLenum internalformat,
			    GLint x, GLint y, GLsizei width, GLsizei height,
			    GLint border);
    void (*CopyTexSubImage1D) (GLenum target, GLint level, GLint xoffset,
			       GLint x, GLint y, GLsizei width);
    void (*CopyTexSubImage2D) (GLenum target, GLint level, GLint xoffset,
			       GLint yoffset, GLint x, GLint y,
			       GLsizei width, GLsizei height);
    void (*DeleteTextures) (GLsizei n, const GLuint *textures);
    void (*GenTextures) (GLsizei n, GLuint *textures);
    void (*GetPointerv) (GLenum pname, GLvoid ** params);
    GLboolean (*IsTexture) (GLuint texture);
    void (*PrioritizeTextures) (GLsizei n, const GLuint *textures,
				const GLclampf *priorities);
    void (*TexSubImage1D) (GLenum target, GLint level, GLint xoffset,
			   GLsizei width, GLenum format, GLenum type,
			   const GLvoid *pixels);
    void (*TexSubImage2D) (GLenum target, GLint level, GLint xoffset,
			   GLint yoffset, GLsizei width, GLsizei height,
			   GLenum format, GLenum type, const GLvoid *pixels);
    void (*PopClientAttrib) (void);
    void (*PushClientAttrib) (GLbitfield mask);
    void (*BlendColor) (GLclampf red, GLclampf green, GLclampf blue,
			GLclampf alpha);
    void (*BlendEquation) (GLenum mode);
    void (*ColorTable) (GLenum target, GLenum internalformat,
			GLsizei width, GLenum format, GLenum type,
			const GLvoid *table);
    void (*ColorTableParameterfv) (GLenum target, GLenum pname,
				   const GLfloat *params);
    void (*ColorTableParameteriv) (GLenum target, GLenum pname,
				   const GLint *params);
    void (*CopyColorTable) (GLenum target, GLenum internalformat,
			    GLint x, GLint y, GLsizei width);
    void (*GetColorTable) (GLenum target, GLenum format, GLenum type,
			   GLvoid *table);
    void (*GetColorTableParameterfv) (GLenum target, GLenum pname,
				      GLfloat *params);
    void (*GetColorTableParameteriv) (GLenum target, GLenum pname,
				      GLint *params);
    void (*ColorSubTable) (GLenum target, GLsizei start, GLsizei count,
			   GLenum format, GLenum type, const GLvoid *data);
    void (*CopyColorSubTable) (GLenum target, GLsizei start, GLint x, GLint y,
			       GLsizei width);
    void (*ConvolutionFilter1D) (GLenum target, GLenum internalformat,
				 GLsizei width, GLenum format, GLenum type,
				 const GLvoid *image);
    void (*ConvolutionFilter2D) (GLenum target, GLenum internalformat,
				 GLsizei width, GLsizei height,
				 GLenum format, GLenum type,
				 const GLvoid *image);
    void (*ConvolutionParameterf) (GLenum target, GLenum pname,
				   GLfloat params);
    void (*ConvolutionParameterfv) (GLenum target, GLenum pname,
				    const GLfloat *params);
    void (*ConvolutionParameteri) (GLenum target, GLenum pname, GLint params);
    void (*ConvolutionParameteriv) (GLenum target, GLenum pname,
				    const GLint *params);
    void (*CopyConvolutionFilter1D) (GLenum target, GLenum internalformat,
				     GLint x, GLint y, GLsizei width);
    void (*CopyConvolutionFilter2D) (GLenum target, GLenum internalformat,
				     GLint x, GLint y,
				     GLsizei width, GLsizei height);
    void (*GetConvolutionFilter) (GLenum target, GLenum format, GLenum type,
				  GLvoid *image);
    void (*GetConvolutionParameterfv) (GLenum target, GLenum pname,
				       GLfloat *params);
    void (*GetConvolutionParameteriv) (GLenum target, GLenum pname,
				       GLint *params);
    void (*GetSeparableFilter) (GLenum target, GLenum format, GLenum type,
				GLvoid *row, GLvoid *column, GLvoid *span);
    void (*SeparableFilter2D) (GLenum target, GLenum internalformat,
			       GLsizei width, GLsizei height, GLenum format,
			       GLenum type, const GLvoid *row,
			       const GLvoid *column);
    void (*GetHistogram) (GLenum target, GLboolean reset, GLenum format,
			  GLenum type, GLvoid *values);
    void (*GetHistogramParameterfv) (GLenum target, GLenum pname,
				     GLfloat *params);
    void (*GetHistogramParameteriv) (GLenum target, GLenum pname,
				     GLint *params);
    void (*GetMinmax) (GLenum target, GLboolean reset, GLenum format,
		       GLenum type, GLvoid *values);
    void (*GetMinmaxParameterfv) (GLenum target, GLenum pname,
				  GLfloat *params);
    void (*GetMinmaxParameteriv) (GLenum target, GLenum pname, GLint *params);
    void (*Histogram) (GLenum target, GLsizei width, GLenum internalformat,
		       GLboolean sink);
    void (*Minmax) (GLenum target, GLenum internalformat, GLboolean sink);
    void (*ResetHistogram) (GLenum target);
    void (*ResetMinmax) (GLenum target);
    void (*TexImage3D) (GLenum target, GLint level, GLint internalformat,
			GLsizei width, GLsizei height, GLsizei depth,
			GLint border, GLenum format, GLenum type,
			const GLvoid *pixels);
    void (*TexSubImage3D) (GLenum target, GLint level,
			   GLint xoffset, GLint yoffset, GLint zoffset,
			   GLsizei width, GLsizei height, GLsizei depth,
			   GLenum format, GLenum type, const GLvoid *pixels);
    void (*CopyTexSubImage3D) (GLenum target, GLint level,
			       GLint xoffset, GLint yoffset, GLint zoffset,
			       GLint x, GLint y,
			       GLsizei width, GLsizei height);
} __glProcTable;

typedef struct _glProcTableEXT {
    void (*ActiveTextureARB) (GLenum texture);
    void (*ClientActiveTextureARB) (GLenum texture);
    void (*MultiTexCoord1dvARB) (GLenum target, const GLdouble *v);
    void (*MultiTexCoord1fvARB) (GLenum target, const GLfloat *v);
    void (*MultiTexCoord1ivARB) (GLenum target, const GLint *v);
    void (*MultiTexCoord1svARB) (GLenum target, const GLshort *v);
    void (*MultiTexCoord2dvARB) (GLenum target, const GLdouble *v);
    void (*MultiTexCoord2fvARB) (GLenum target, const GLfloat *v);
    void (*MultiTexCoord2ivARB) (GLenum target, const GLint *v);
    void (*MultiTexCoord2svARB) (GLenum target, const GLshort *v);
    void (*MultiTexCoord3dvARB) (GLenum target, const GLdouble *v);
    void (*MultiTexCoord3fvARB) (GLenum target, const GLfloat *v);
    void (*MultiTexCoord3ivARB) (GLenum target, const GLint *v);
    void (*MultiTexCoord3svARB) (GLenum target, const GLshort *v);
    void (*MultiTexCoord4dvARB) (GLenum target, const GLdouble *v);
    void (*MultiTexCoord4fvARB) (GLenum target, const GLfloat *v);
    void (*MultiTexCoord4ivARB) (GLenum target, const GLint *v);
    void (*MultiTexCoord4svARB) (GLenum target, const GLshort *v);
    void (*SampleCoverageARB) (GLclampf value, GLboolean invert);
    GLboolean (*AreTexturesResidentEXT) (GLsizei n, const GLuint *textures,
					 GLboolean *residences);
    void (*GenTexturesEXT) (GLsizei n, GLuint *textures);
    GLboolean (*IsTextureEXT) (GLuint texture);
    void (*SampleMaskSGIS) (GLclampf value, GLboolean invert);
    void (*SamplePatternSGIS) (GLenum pattern);
    void (*PointParameterfEXT) (GLenum pname, GLfloat param);
    void (*PointParameterfvEXT) (GLenum pname, const GLfloat *params);
    void (*WindowPos3fMESA) (GLfloat x, GLfloat y, GLfloat z);
    void (*BlendFuncSeparateEXT) (GLenum sfactorRGB, GLenum dfactorRGB,
				  GLenum sfactorAlpha, GLenum dfactorAlpha);
    void (*FogCoordfvEXT) (const GLfloat *coord);
    void (*FogCoorddvEXT) (const GLdouble *coord);
    void (*FogCoordPointerEXT) (GLenum type, GLsizei stride,
				const GLvoid *pointer);
    void (*SecondaryColor3bvEXT) (const GLbyte *v);
    void (*SecondaryColor3dvEXT) (const GLdouble *v);
    void (*SecondaryColor3fvEXT) (const GLfloat *v);
    void (*SecondaryColor3ivEXT) (const GLint *v);
    void (*SecondaryColor3svEXT) (const GLshort *v);
    void (*SecondaryColor3ubvEXT) (const GLubyte *v);
    void (*SecondaryColor3uivEXT) (const GLuint *v);
    void (*SecondaryColor3usvEXT) (const GLushort *v);
    void (*SecondaryColorPointerEXT) (GLint size, GLenum type, GLsizei stride,
				      const GLvoid *pointer);
    void (*PointParameteriNV) (GLenum pname, GLint params);
    void (*PointParameterivNV) (GLenum pname, const GLint *params);
    void (*ActiveStencilFaceEXT) (GLenum face);
} __glProcTableEXT;

extern __glProcTable     *__glRenderTable;
extern __glProcTableEXT  *__glRenderTableEXT;

#endif
