// file      : xsd-frontend/semantic-graph/particle.cxx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : Copyright (c) 2006-2008 Code Synthesis Tools CC
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

#include <xsd-frontend/semantic-graph/particle.hxx>

namespace XSDFrontend
{
  namespace SemanticGraph
  {
    namespace RTTI = Cult::RTTI;

    using RTTI::Access;
    using RTTI::TypeInfo;


    // Particle
    //
    namespace
    {
      struct ParticleInit
      {
        ParticleInit ()
        {
          TypeInfo ti (typeid (Particle));
          ti.add_base (Access::public_, true, typeid (Node));
          RTTI::insert (ti);
        }

      } particle_init_;
    }

    Particle::
    Particle ()
        : contained_particle_ (0)
    {
    }

    Void Particle::
    add_edge_right (ContainsParticle& e)
    {
      assert (contained_particle_ == 0);
      contained_particle_ = &e;
    }
  }
}
