// file      : xsde/type-map/type-map.hxx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : Copyright (c) 2007 Code Synthesis Tools CC
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

#ifndef XSDE_TYPE_MAP_TYPE_MAP_HXX
#define XSDE_TYPE_MAP_TYPE_MAP_HXX

#include <cult/types.hxx>
#include <cult/containers/vector.hxx>

namespace TypeMap
{
  using namespace Cult::Types;
  typedef WideString String;

  class Type
  {
  public:
    Type (String const& xsd_name,
          String const& cxx_ret_name,
          String const& cxx_arg_name)
        : xsd_name_ (xsd_name),
          cxx_ret_name_ (cxx_ret_name),
          cxx_arg_name_ (cxx_arg_name)
    {
    }

    String const&
    xsd_name () const
    {
      return xsd_name_;
    }

    String const&
    cxx_ret_name () const
    {
      return cxx_ret_name_;
    }

    String const&
    cxx_arg_name () const
    {
      return cxx_arg_name_;
    }

  private:
    String xsd_name_;
    String cxx_ret_name_;
    String cxx_arg_name_;
  };

  class Namespace
  {
  public:
    Namespace (String const& xsd_name)
        : xsd_name_ (xsd_name), has_cxx_name_ (false)
    {
    }

    Namespace (String const& xsd_name, String const& cxx_name)
        : xsd_name_ (xsd_name), has_cxx_name_ (true), cxx_name_ (cxx_name)
    {
    }

    Namespace (String const& xsd_name,
               Boolean has_cxx_name,
               String const& cxx_name)
        : xsd_name_ (xsd_name),
          has_cxx_name_ (has_cxx_name),
          cxx_name_ (cxx_name)
    {
    }

    //
    //
    typedef Cult::Containers::Vector<String> Includes;
    typedef Includes::ConstIterator IncludesIterator;

    IncludesIterator
    includes_begin () const
    {
      return includes_.begin ();
    }

    IncludesIterator
    includes_end () const
    {
      return includes_.end ();
    }

    Void
    includes_push_back (String const& i)
    {
      includes_.push_back (i);
    }

    //
    //
    typedef Cult::Containers::Vector<Type> Types;
    typedef Types::ConstIterator TypesIterator;

    TypesIterator
    types_begin () const
    {
      return types_.begin ();
    }

    TypesIterator
    types_end () const
    {
      return types_.end ();
    }

    Void
    types_push_back (String const& xsd_type,
                     String const& cxx_ret_type,
                     String const& cxx_arg_type = L"")
    {
      types_.push_back (Type (xsd_type, cxx_ret_type, cxx_arg_type));
    }

    //
    //
    String const&
    xsd_name () const
    {
      return xsd_name_;
    }

    //
    //
    Boolean
    has_cxx_name () const
    {
      return has_cxx_name_;
    }

    String const&
    cxx_name () const
    {
      return cxx_name_;
    }

  private:
    Includes includes_;
    Types types_;
    String xsd_name_;
    Boolean has_cxx_name_;
    String cxx_name_;
  };

  typedef Cult::Containers::Vector<Namespace> Namespaces;
}

#endif // XSDE_TYPE_MAP_TYPE_MAP_HXX

