/* $Header: /fridge/cvs/xscorch/sgtk/sdialog-gtk.h,v 1.6 2009-04-26 17:39:47 jacob Exp $ */
/*
   
   xscorch - sdialog-gtk.h    Copyright(c) 2000-2003 Justin David Smith
   justins(at)chaos2.org      http://chaos2.org/
    
   GTK dialogue helper functions
    

   This program is free software; you can redistribute it and/or modify 
   it under the terms of the GNU General Public License as published by 
   the Free Software Foundation, version 2 of the License ONLY. 

   This program is distributed in the hope that it will be useful, 
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
   General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

*/
#ifndef __sdialog_gtk_h_included
#define __sdialog_gtk_h_included


/* The order of includes does matter! */
#include <swindow-gtk.h>
#include <sdialog.h>
#include <slabel.h>
#include <sgame/shelp.h>
#include <libj/jstr/libjstr.h>


/* Tooltips and dialogue helpers */
static inline GtkWidget *tooltip(sc_window_gtk *w, const char *help, GtkWidget *widget) {

#if 0 /* TEMP - Not working ... do we even need it? */
   if(GTK_IS_COMBO_BOX(widget)) {
      /* TEMP - This was the COMBO non-BOX version using the old w->tooltips... */
      gtk_tooltips_set_tip(w->tooltips, GTK_COMBO(widget)->entry, help, help);
      gtk_tooltips_set_tip(w->tooltips, GTK_COMBO(widget)->list, help,  help);

      /* And this is the version I tried for 2.12 but there is no entry or list... */
      gtk_widget_set_tooltip_text(GTK_WIDGET(GTK_COMBO_BOX(widget)->entry), help);
      gtk_widget_set_tooltip_text(GTK_WIDGET(GTK_COMBO_BOX(widget)->list),  help);
   }
#endif

   /* TOOLTIPS changed from an ass to a mule in GTK 2.12 */
   gtk_widget_set_tooltip_text(widget, help);

   return(widget);

}


static inline void attach_label(ScDialog *dialog, sc_window_gtk *w, const char *help, const char *field, int row) {
   
   char buf[SC_GTK_STRING_BUFFER];
   sbprintf(buf, sizeof(buf), "%s:", field);
   sc_dialog_grid_attach(dialog, tooltip(w, help, sc_label_new(buf)), row, 0);
         
   
}


static inline void attach_widget(ScDialog *dialog, sc_window_gtk *w, const char *help, GtkWidget *widget, int row) {
   
   sc_dialog_grid_attach(dialog, tooltip(w, help, widget), row, 1);
         
   
}


static inline void attach_option_help(ScDialog *dialog, sc_window_gtk *w, const char *field, const char *help, GtkWidget *widget, int *row) {

   attach_label (dialog, w, help, field,  *row);
   attach_widget(dialog, w, help, widget, *row);
   ++(*row);

}


static inline void attach_option(ScDialog *dialog, sc_window_gtk *w, const char *field, GtkWidget *widget, int *row) {

   char help[SC_GTK_STRING_BUFFER];
   sc_help_text(help, sizeof(help), field);
   attach_option_help(dialog, w, field, help, widget, row);

}


#endif /* __sdialog_gtk_h_included */
