/*
  xqbiff  -- "biff" program for qmail.
  Copyright (C) 1998-2003 Yusuke Ishizawa <yu-i@wmail.plala.or.jp>

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2, or (at your option) any
  later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
/*
 *  xqb.h
 *
 * ̤إåե
 *
 */


#ifndef XQB_H
#define XQB_H

#include "imacro.h"


#ifndef VERSION
#define VERSION "0.75"
#endif
#define DEVELOPVER 0

#define PROGDATE "21 Jul 2003"
#define MINSIZE  8                     /* Minimum main window size */


#define TIMEDIFFERENCE_HOUR 9            /* Time difference */
#define TIMEDIFFERENCE_MIN  0

#define _LABEL_ENV_  "XQB_LABEL"
#define _MAIL_ENV_   "XQB_MAILS"
#define _NMAIL_ENV_  "XQB_NEWMAILS"
#define _CPID_ENV_   "XQB_CPID"
#define _PPID_ENV_   "XQB_PID"



#include<stdio.h>
#include<string.h>
#include<stdlib.h>
#include<signal.h>
#include<dirent.h>
#include<unistd.h>
#include<time.h>
#include<errno.h>
#include<sys/time.h>
#include<sys/stat.h>
#include"ietc.h"
#include"ical.h"
#include"ifile.h"
#include"istr.h"
#include"ixcolor.h"
#include"ixmbstr.h"
#include"fdio.h"
#include"sig.h"
#include"idbg.h"

#include<X11/Xlib.h>
#include<X11/Xutil.h>
#include<X11/Xos.h>
#include<X11/Xlocale.h>
#include<X11/keysym.h>
#include<X11/xpm.h>
#include<X11/Xatom.h>
#ifdef HAVE_IMLIB_H
#include<Imlib.h>
#endif


#define XQB_MODE_DIR 0
#define XQB_MODE_BOX 1
#define XQB_MODE_POP 2


/********************************/
/* Option information structure */
/********************************/
struct _Opinfo{
    char display[256];              /* Display                         */
    char bg[32];                    /* Background color                */
    char fg[32];                    /* Foreground color                */
    int  bd;                        /* Border width                    */
    BOOL anim;                      /* Animation                       */
    char m_geom[32];                /* Maim window geometry            */
    char l_geom[32];                /* List window geometry            */
    char p_geom[32];                /* Popup window geometry           */
    BOOL p_geom_flag;               /* Popup window geometry flag      */
    int  poll;                      /* Search interval                 */
    char com2[1024];                 /* Executable command line         */
    char com3[1024];
    char maildir[1024];             /* Mail directory path             */
    char mailbox[1024];             /* Mailbox path                    */
    char poprc[1024];               /* Pop resource directory          */
    char image[1024];               /* Animation image file(XPM)       */
    int  mmax;                      /* Max view of mails list          */
    char fe[256];                   /* Ascii font name                 */
    char fk[256];                   /* JIS KANA font name              */
    char fj[256];                   /* JIS font name                   */
    BOOL scroll;                    /* Scroll direction                */
    int  sc_speed;                  /* List scroll speed               */
    BOOL nopopup;                   /* No popup window                 */
    int  sort;                      /* Mails list sorting by receive time
				       0 = No sorting
				       1 = oldest mails listed first
				       2 = newest mails listed first   */
    BOOL beep;                      /* Rings the bell at received mail */
    int  length;                    /* Line length                     */
    int  mode;                      /* Mode  0:Maildir 1:Mailbox 2:Pop */
    BOOL shape;                     /* Window shape                    */
    BOOL notitle;                   /* No titlebar(at shape mode only) */

    int  retry;                     /* Retry                           */

    int  nocapt;
    char rcfile[1024];

    char label[256];

    BOOL flat_face;

    int  p_time;
};
typedef struct _Opinfo Opinfo;


/*******************************/
/* Image information structure */
/*******************************/
struct _iminfo{
/*
    BOOL temp;
*/
    char imname[1024];              /* Image file namefull path   */
    int  width;                     /* Image's width                  */
    int  height;                    /*         height                 */
    int  pwidth;                    /* Image's width at a panel       */
    int  pheight;                   /*         height                 */
    int  ptn;
    int  pt[5];                     /* Animation patterns             */
    double *asp[5];
};
typedef struct _iminfo Iminfo;


/***********************************/
/* Mail file information structure */
/***********************************/
struct _FileInfo{
    char   filename[1024];          /* Mail file name                 */
    time_t time;                    /* Mail received time             */
};
typedef struct _FileInfo FileInfo;


/**********************************/
/* ʸʿ˾¤ */
/**********************************/
struct _TextInfoElem{
    char fromkey[256];
    char subjkey[256];

    char bgpname[1024];
    char bgcname[32];

    char fromt[32];
    char fromn[32];
    char subjt[32];
    char subjn[32];
    char daten[32];
    char numb[32];

    char command[1024];
    BOOL run_others;

    BOOL fromtbold;
    BOOL fromnbold;
    BOOL subjtbold;
    BOOL subjnbold;
    BOOL datenbold;
    BOOL numbbold;

    Pixmap bgp;
    int    bgp_w, bgp_h;
    unsigned char bgp_cont;
    unsigned char bgp_brt;
    unsigned long bgc;
    unsigned long fromtc;
    unsigned long fromnc;
    unsigned long subjtc;
    unsigned long subjnc;
    unsigned long datenc;
    unsigned long numbc;
};
#define TEXT_COLOR_INFO_MAX 11
struct _TextInfo{
    char headerfg[32];               /* Title text color         */
    char headerbg[32];               /* Title background color   */
    BOOL headerbold;                 /* Use bold font            */
    unsigned long hdfgc;
    unsigned long hdbgc;
    struct _TextInfoElem tinf[TEXT_COLOR_INFO_MAX];
};
typedef struct _TextInfo TextInfo;


struct _PARAMS{
    char *name;
};
typedef struct _PARAMS PARAMS;

struct _iSize{
    int width;
    int height;
};
typedef struct _iSize iSize;

struct _PopInfo{
    char mode[256];
    char server[256];
    char user[256];
    char passwd[256];
};
typedef struct _PopInfo PopInfo;



/* Function prototype */
extern void GetOpinfo( int, char*[], TextInfo* );
extern BOOL GetIminfo( Iminfo* );
extern void GetResource( Display*, char*, TextInfo*, char* );
extern void OpErrOut();
extern void OpHelpOut();
extern void OpInfoOut();
extern void OpVerOut();
extern int  mimdecode( char def[], char ret[], int *code );
extern void changecodetojis( char def[], char ret[], size_t len, int code );
extern void printjisstr( char str[] );
extern void SearchMail( int sfd, int rfd, int i_time );
extern int  CheckPopConnect();
extern void SetWndName( Display*, Window, char* );
extern void SignalBlock(int);
extern BOOL SignalUnblock(int);
extern void GetWndSizePos(Display*,Window,XSizeHints*,XSizeHints*);
extern void MapWnd(Display*,Window,XSizeHints*);



/* Global variable */
extern Opinfo    opinfo;        /* Xqbiff's user option structure    */
extern PopInfo   popinfo;       /* Pop information structure         */
extern iSize     display_size;  /* Display size                      */
extern int       font_h;        /* Fonts max height                  */
extern int       MAXDRAW;       /* List pixmap size                  */
extern BOOL      apop;
extern int       rcvsig;
extern int       ppid;          /* Parent process ID                  */
extern int       cpid;          /* Child process ID                  */
extern int       transcfg;
extern BOOL      ltransflag;
extern BOOL      ptransflag;
#ifdef HAVE_IMLIB_H
extern ImlibData  *imlibdata;
#endif

#define FD_BUF 1024             /* Pipe buffer max size              */



/* Alias */
#define DW (display_size.width)
#define DH (display_size.height)
#define LINE_H (font_h+5)
#define MH (LINE_H*3)


/* Instructions child -> parent */
#define CP_ADDMAILS    31    /* ᡼ */
#define CP_DELMAILS    32    /* ᡼븺 */
#define CP_RESCANMAILS 33    /* ᡼ꥹȹ(ʤ) */
#define CP_CHKSTART    35    /* ᡼븡 */
#define CP_CHKEND      36    /* ᡼븡λ */
#define CP_FINCOMM     37    /* ޥɽλ */
#define CP_MESSAGE     38    /* åɽ׵ */
#define CP_EXITCHILD    1    /* ҥץλ */

/* Instructions parent -> child */
#define PC_RESEARCH 41    /* ᡼Ƹ׵ */
#define PC_RUNCOMM  42    /* ޥɼ¹׵ */



#define WD 2              /* ɥ */
#define DEFAULT_NOCAPT 1
#define SCBAR_SIZE 14
#define __SMOOTH_COLOR__

#define CC_DQ '\"'
#define CC_SQ '\''

/* text code */
#define CODE_ASCII  0
#define CODE_JIS    1
#define CODE_EUC    2
#define CODE_SJIS   3

/* Mode */
#define XQB_MODE_DIR  0
#define XQB_MODE_BOX  1
#define XQB_MODE_POP  2

#endif
