/*
  xqbiff  -- "biff" program for qmail.
  Copyright (C) 1998-2003 Yusuke Ishizawa <yu-i@wmail.plala.or.jp>

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2, or (at your option) any
  later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
/*
 * txtcode.c
 *
 * MIME ǥɴؿȤʸѴؿȤ
 */

#include<stdio.h>
#include<string.h>
#include"xqb.h"
#include"mail.h"


extern void b64_decoder( char def[], char ret[] );
extern void quote_decoder( char def[], char ret[] );

/* MIME γ, λ, ǽ'?', '?' Υǥå֤ */
BOOL mimsearch( char *def, int *srt, int *end, int *fq, int *sq )
{
    char *ret;
    char *cur_str;  /*  ܤƤʸƬ  */
    
    /*
     * MIMEɤ, "=?"ǻϤޤ, "?="ǽ,
     * δ֤2Ĥ'?'ĤȲꤷޤ礦
     */


    /* MIME λ "=?" õ */
    cur_str = &(def[0]);
    ret = strstr(cur_str, "=?");
    if( ret == NULL ) return FALSE;

    *srt = (int)(ret - def);
    cur_str = ret + 2;

    /* 1ܤ '?' õ */
    ret = strchr(cur_str, '?');
    if( ret == NULL ) return FALSE;

    *fq = (int)(ret - def);
    cur_str = ret + 1;

    /* 2ܤ '?' õ */
    ret = strchr(cur_str, '?');
    if( ret == NULL ) return FALSE;

    *sq = (int)(ret - def);
    cur_str = ret + 1;

    /* MIME ν "?=" õ */
    ret = strstr(cur_str, "?=");
    if( ret == NULL ) return FALSE;

    *end = (int)(ret - def);

    return TRUE;
}


/* ʸ,ѴȤȤʤȤȽ̤ơƴؿƤ */
/* ʸ ret , 1024 ʾΥǳݤƤ뤳          */
int mimdecode( char def[], char ret[], int *code )
{
    int flag = 1;
    int k, i;
    int srt, end, q1, q2;
    char temp1[1024], temp2[1024], buff[2048], ctmp, ctype[1024];
    char *dp;  /*  ʸ def θܤƤʬʸƬ  */


    iStrInit( buff, 1024 );
    dp = &(def[0]);
    *code = CODE_JIS;

    while( dp[0] != '\0' ){
	srt = end = q1 = q2 = 0;

	if( FALSE == mimsearch( dp, &srt, &end, &q1, &q2 ) ){
	    strncat( buff, dp, 1024 );
	    buff[1023] = '\0';
	    break;

	} else {
	    /* MIMEɰʸ򥳥ԡ */
	    if( srt ){
		for (k=0; k<srt; k++) {  /*  tab 򥹥ڡѴ  */
		    if ( dp[k] == '\t' ) {
			dp[k] = ' ';
		    }
		}
		strncat(buff, dp, srt);
		dp += srt;
	    }

	    /* MIMEν */
	    /* "=?xxxxxxxx?" ޤǤڤ */
	    dp += 2;
	    strncpy( ctype, dp, q1-srt-2 );
	    ctype[q1-srt-2] = '\0';
	    dp += q1-srt-1;

	    if( 0 == strcasecmp(ctype,"iso-2022-jp") ){
		*code = CODE_JIS;
	    } else if( 0 == strcasecmp(ctype,"shift_jis") ){
		*code = CODE_SJIS;
	    } else if( 0 == strcasecmp(ctype,"euc-jp") ){
		*code = CODE_EUC;
	    } else {
		*code = CODE_JIS;
	    }

	    /* 󥳡ɵɤ߼ */
	    ctmp = dp[0];

	    dp += q2 - q1;

	    /* MIME ʬڤФ */
	    strncpy( temp1, dp, end - q2 -1 );
	    temp1[end - q2 - 1] = '\0';
	    dp += end - q2 +1;
	    iStrInit( temp2, 1024 );
	    switch( ctmp ){
	    case 'b':
	    case 'B':
		b64_decoder( temp1, temp2 );
		strcat( buff, temp2 );
		break;
		    
	    case 'q':
	    case 'Q':
		quote_decoder( temp1, temp2 );
		strcat( buff, temp2 );
		break;

	    default:
		dp[0] = '\0';
		flag = 0;
		break;
	    }
	}
    }

    i=0;
    k=0;
    if( flag == 0 ){
	/* Ԥƥԡ */
	while( def[i] != '\0' && k < 1023 ){
	    if( def[i] != '\n' && def[i] != '\r' ){
		ret[k++] = def[i];
	    }
	    i++;
	}
	ret[k] = '\0';
    } else {
	/* Ԥƥԡ */
	while( buff[i] != '\0' && k < 1023 ){
	    if( buff[i] != '\n' && buff[i] != '\r' ){
		ret[k++] = buff[i];
	    }
	    i++;
	}
	ret[k] = '\0';
    }

    /* ⤦٥ɤå */
    if( *code == CODE_JIS )
	*code = check_text_code(ret);

    return 1;
}


/* base64 Υǥ */
void b64_decoder( char def[], char ret[] )
{
    static char btable[] = {
	-1, -1, -1, -1,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1, -1, -1, -1,
	-1, -1, -1, -1,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1, -1, -1, -1,
	-1, -1, -1, -1,  -1, -1, -1, -1,  -1, -1, -1, 62,  -1, -1, -1, 63,
	52, 53, 54, 55,  56, 57, 58, 59,  60, 61, -1, -1,  -1, -1, -1, -1,
	-1,  0,  1,  2,   3,  4,  5,  6,   7,  8,  9, 10,  11, 12, 13, 14,
	15, 16, 17, 18,  19, 20, 21, 22,  23, 24, 25, -1,  -1, -1, -1, -1,
	-1, 26, 27, 28,  29, 30, 31, 32,  33, 34, 35, 36,  37, 38, 39, 40,
	41, 42, 43, 44,  45, 46, 47, 48,  49, 50, 51, -1,  -1, -1, -1, -1
    };
    int buf[4];
    int iidx = 0, oidx = 0, tidx = 0;
    int def_len = strlen(def);

    if( (def_len % 4) != 0 ){
	fprintf( stderr, "b64_decode::error1.\n" );
	strcpy( ret, def );
	return;
    } 
    
    while( iidx != def_len ){
	tidx = 0;
	while( tidx < 4 && (buf[tidx] = def[iidx++]) != '=' ){
	    buf[tidx] = btable[buf[tidx]];
	    if( buf[tidx] == -1 ){
		fprintf( stderr, "b64_decode::error2.\n" );
		strcpy( ret, def );
		return;
	    }
	    tidx++;
	}

	ret[oidx++] = ( (buf[0] << 2) | ((buf[1] & 0x30) >> 4) );

	if( tidx<3 ) break;

	ret[oidx++] = ( ((buf[1] & 0x0f) << 4) | ((buf[2] & 0x3c) >> 2) );

	if( tidx<4 ) break;

	ret[oidx++] = ( ((buf[2] & 0x03) << 6) | (buf[3] & 0x3f) );
    }

    return;
}


/* quote Υǥ */
void quote_decoder( char def[], char ret[] )
{
    static char qtable[] = {
	-1, -1, -1, -1,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1, -1, -1, -1,
	-1, -1, -1, -1,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1, -1, -1, -1,
	-1, -1, -1, -1,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1, -1, -1, -1,
	 0,  1,  2,  3,   4,  5,  6,  7,   8,  9, -1, -1,  -1, -1, -1, -1,
	-1, 10, 11, 12,  13, 14, 15, -1,  -1, -1, -1, -1,  -1, -1, -1, -1,
	-1, -1, -1, -1,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1, -1, -1, -1,
	-1, 10, 11, 12,  13, 14, 15, -1,  -1, -1, -1, -1,  -1, -1, -1, -1,
	-1, -1, -1, -1,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1, -1, -1, -1
    };
    int iidx = 0, oidx = 0;
    int c1, c2;
    int def_len = strlen(def);

    while( iidx < def_len ){
	if( '=' != def[iidx] ){
	    ret[oidx++] = def[iidx++];
	} else {
	    if( ++iidx < def_len-1 ){

		if( def[iidx] != '\n' && def[iidx] != '\r' ){

		    c1 = qtable[(int)def[iidx++]];
		    c2 = qtable[(int)def[iidx++]];

		    if( c1 == -1 || c2 == -1 ){
			fprintf( stderr, "quote:error1. ???\n" );
			strcpy( ret, def );
			return;
		    }

		    ret[oidx++] = ((c1 << 4) | c2);

		}

	    } else {
		fprintf( stderr, "quote:error3.\n" );
		strcpy( ret, def );
		return;
	    }
	}
    }

    return;
}


#define END  -1  /* λ */
#define JIS   0  /* JIS */
#define KJIS 10  /* ȾJIS */
#define ASCII 1  /* ʸ */
#define NJIS  2  /* JIS */
#define OJIS  3  /* JIS */ 
#define JISK  4  /* JISȾѤ */
#define JISR  5  /* JIS޻ */
#define EUC  6  /* EUC */
#define HEUC   7  /* ȾEUC */
#define SJIS 8  /* Shift-jis */
#define HSJIS  9  /* ȾShift-jis */

#define ESC   0x1b
#define BSP   0x08

void euctojis( unsigned char *def, unsigned char *ret, size_t len );
void sjistojis( unsigned char *def, unsigned char *ret, size_t len );


/*
 * ʸJISʸɷѴ
 */

void changecodetojis( char def[], char ret[], size_t len, int code )
{
    switch(code){
    case CODE_EUC:
	euctojis( (unsigned char*)def, (unsigned char*)ret, len );
	break;
    case CODE_SJIS:
	sjistojis( (unsigned char*)def, (unsigned char*)ret, len );
	break;
    case CODE_JIS:
    default:
    {
	char *buff = (char*)malloc(len*2);
	strncpy( buff, def, len );
	buff[len-1] = '\0';
	strcpy( ret, buff );
	free(buff);
	break;
    }
    }
    return;
}

void euctojis( unsigned char *def, unsigned char *ret, size_t len )
{
    if( len > 0 ){
	unsigned char *buff = NULL;
	int  i=0, j=0;
	int  prevcode = ASCII;
	int  flag = 1;

	buff = (unsigned char*)malloc(len*2);

	while( def[i] != '\0' ){
#ifdef DEBUG
printf("%s:CODE=0x%x\n",__func__,def[i]);
#endif
	    if( (def[i] & 0x80) == 0 ){
		/* ASCIIξ */
#ifdef DEBUG
		fprintf(stderr,"ASCII(%d)\n",i);
#endif
		if( prevcode != ASCII ){
		    if( i > len-3 ) break;

		    buff[j++] = 0x1b;
		    buff[j++] = '(';
		    buff[j++] = 'B';
		    prevcode = ASCII;
		}

		buff[j++] = def[i++];

	    }  else if( 0x8f == (def[i] & 0x000000ff) || 
			0xa1 <= (def[i] & 0x000000ff) ){
		/*  EUC ξ */
#ifdef DEBUG
		fprintf(stderr,"EUC(%d)\n",i);
#endif
		if( prevcode != EUC ){
		    if( j > len-3 ) break;

		    buff[j++] = 0x1b;
		    buff[j++] = '$';
		    buff[j++] = 'B';
		    prevcode = EUC;
		}
		buff[j++] = def[i++] & ~0x80;
		buff[j++] = def[i++] & ~0x80;

	    } else if( 0x8e == (def[i] & 0x000000ff) ){
		/* ȾEUC ξ */
#ifdef DEBUG
		fprintf(stderr,"HEUC(%d)\n",i);
#endif
		if( prevcode != HEUC ){
		    if( j > len-3 ) break;

		    buff[j++] = 0x1b;
		    buff[j++] = '(';
		    buff[j++] = 'I';
		    prevcode = HEUC;
		}
		buff[j++] = (def[i++] & ~0x80) + 0x0080;
	    } else {
		fprintf(stderr,"euctojis: Unknown code.(0x%02x)\n",def[i]);
		buff[j++] = def[i++];
	    }
	}

	if( prevcode == EUC || prevcode == HEUC ){

	    buff[j++] = 0x1b;
	    buff[j++] = '(';
	    buff[j++] = 'B';
	    prevcode = EUC;
	}

	buff[j] = '\0';

	strcpy( ret, buff );
	free(buff);
    }
    return;
}

void sjistojis( unsigned char *def, unsigned char *ret, size_t len )
{
    if( len > 0 ){
	unsigned char *buff = NULL;
	int  i=0, j=0;
	int  prevcode = ASCII;
	int  flag = 1;
	unsigned char c1, c2, c3;

	buff = (unsigned char*)malloc(len*2);

	while( def[i] != '\0' ){
#ifdef DEBUG
printf("%s:CODE=0x%x\n",__func__,def[i]);
#endif
	    if( isascii(def[i]) ){
		/* ASCIIξ */
#ifdef DEBUG
		fprintf(stderr,"ASCII(%d)\n",i);
#endif
		if( prevcode != ASCII ){
		    if( i > len-3 ) break;

		    buff[j++] = 0x1b;
		    buff[j++] = '(';
		    buff[j++] = 'B';
		    prevcode = ASCII;
		}

		buff[j++] = def[i++];

	    } else if( ((def[i] & 0xff) >= 0x81 && (def[i] & 0xff) <= 0x9f) ||
		       ((def[i] & 0xff) >= 0xe0 && (def[i] & 0xff) <= 0xfc) ){
		/*  SJIS ξ */

		if( ((def[i] & 0xff) >= 0x40 && (def[i] & 0xff) <= 0x7e) ||
		    ((def[i] & 0xff) >= 0x80 && (def[i] & 0xff) <= 0xfc) ){

		    if( prevcode != SJIS ){
			if( j > len-3 ) break;

			buff[j++] = 0x1b;
			buff[j++] = '$';
			buff[j++] = 'B';
			prevcode = SJIS;
		    }

		    c1 = def[i];
		    c2 = def[i+1];
		    c3 = c1 < 0xa0 ? 0x70 : 0xb0;
		    if( c2 < 0x9f ){
			buff[j++] = (c1 - c3) * 2 - 1;
			buff[j++] = c2 - (c2 > 0x7f ? 0x20 : 0x1f);
		    } else {
			buff[j++] = (c1 - c3) * 2;
			buff[j++] = c2 - 0x7e;
		    }
		    i+=2;
		} else {

		    buff[j++] = '_';
		    i++;
		    if( def[i] != '\0' && !isascii(def[i]) ){
			buff[j++] = '_';
			i++;
		    }
		}

	    } else if( (def[i] & 0xff) >= 0xa1 && (def[i] & 0xff) <= 0xdf ){

		if( prevcode != HSJIS ){
		    if( j > len-3 ) break;

		    buff[j++] = 0x1b;
		    buff[j++] = '$';
		    buff[j++] = 'B';
		    prevcode = HSJIS;
		}

		buff[j++] = 0x8e;
		buff[j++] = def[i++];

	    } else {
		buff[j++] = '_';
		i++;
	    }
	}

	if( prevcode == SJIS || prevcode == HSJIS ){

	    buff[j++] = 0x1b;
	    buff[j++] = '(';
	    buff[j++] = 'B';
	    prevcode = SJIS;
	}

	buff[j] = '\0';

	strcpy( ret, buff );
	free(buff);
    }
    return;
}

int check_text_code(unsigned char *src)
{
    int r = CODE_JIS;
    register int i;

    for( i=0 ; src[i] != '\0' ; i++ ){
	if( (src[i] & 0x80) == 0 ){
	    continue;

	}  else if( 0x8f == (src[i] & 0x000000ff) || 
		    0xa1 <= (src[i] & 0x000000ff) ){
	    r = CODE_EUC;
	    if( src[++i] == '\0' ) break;
	} else if( 0x8e == (src[i] & 0x000000ff) ){
	    r = CODE_EUC;
	    continue;
	} else {
	    r = CODE_SJIS;
	    break;
	}
    }
    return r;
}
