/*
  xqbiff  -- "biff" program for qmail.
  Copyright (C) 1998-2003 Yusuke Ishizawa <yu-i@wmail.plala.or.jp>

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2, or (at your option) any
  later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
/*
 * mail.c
 *
 * ᡼갷ؿ
 *
 */

#include"mail.h"

extern int  GetMailInfoMaildir(MailInfo**,int*,MailInfo**,int*,BOOL);
extern int  GetMailInfoMailbox(MailInfo**,int*,MailInfo**,int*,BOOL);
extern int  GetMailInfoPop(MailInfo**,int*,MailInfo**,int*,BOOL);


/********************/
/* TimeDif          */
/* 򤹤 */
/********************/
void TimeDif( struct tm *tm, char rug[] )
{
    char tmp[4];
    unsigned int hdif, mdif;
    time_t tt;
    BOOL add = TRUE;

    /* Calculate a time difference */
    add = (rug[0] == '+') ? FALSE : TRUE;

    tmp[0] = rug[1]; tmp[1] = rug[2]; tmp[2] = '\0';
    hdif = atoi(tmp);

    tmp[0] = rug[3]; tmp[1] = rug[4]; tmp[2] = '\0';
    mdif = atoi(tmp);

    tt = mktime( tm );

    if( add == TRUE )
	tt = tt + (mdif * 60) + (hdif * 60 * 60);
    else
	tt = tt - (mdif * 60) - (hdif * 60 * 60);

    tt = tt + ((TIMEDIFFERENCE_MIN) * 60) + ((TIMEDIFFERENCE_HOUR) * 60 * 60);

    *tm = *localtime( &tt );

    return;
}


/************************************************/
/* ReceivedDecode                               */
/* Received ιԤ, 'MM/DD hh:mm:ss yy' */
/* ƥȤ                               */
/************************************************/
BOOL ReceivedDecode( char def[], char ret[] )
{
    int i, j, day, mon, year, hour, min, sec;
    char month[8], rug[16];
    char *dp;
    struct tm tm = { 0, 0, 0, 0, 0, 0, 0, 0, 0 };


#ifdef DEBUG
    fprintf( stderr, "receiveddecode." );
#endif

    dp = &(def[0]);

    /* Cut before ';' */
    j = strlen( dp );
    for( i=0 ; i<j ; ++i ){
	if( dp[i] == ';' )
	    break;
    }

    if( i < j )
	dp += i+1;

    /* Cut Week */
    while( (dp[0] < '0' || '9' < dp[0] ) && dp[0] != '\0' ){
	dp++;
    }
    if( 7 != sscanf( dp, "%d %s %d %d:%d:%d %s", 
		     &day, month, &year, &hour, &min, &sec, rug ) )
	return FALSE;

    mon = iMonth( month );

    /* Calculate a time difference */
    tm.tm_sec  = sec;
    tm.tm_min  = min;
    tm.tm_hour = hour;
    tm.tm_mday = day;
    tm.tm_mon  = mon;
    tm.tm_year = year - 1900;

    TimeDif( &tm, rug );

    sec  = tm.tm_sec;
    min  = tm.tm_min;
    hour = tm.tm_hour;
    day  = tm.tm_mday;
    mon  = tm.tm_mon;
    year = tm.tm_year + 1900;

    sprintf( ret, " %02d/%02d %02d:%02d:%02d %04d", 
	     mon+1, day, hour, min, sec, year );

#ifdef DEBUG
    fprintf( stderr, "Date Decode %s", ret );

    fprintf( stderr, "..Done.\n" );
#endif

    return TRUE;
}


/*********************************************/
/* DateToTime                                */
/* 'MM/DD hh/mm/ss yy'ηǽ񤫤줿դ */
/* ƥȤtime_tѴ֤            */
/*********************************************/
time_t DateToTime( char date_text[] )
{
    struct tm time = { 0, 0, 0, 0, 0, 0, 0, 0, 0 };
    time_t ret = 0;

    sscanf( date_text, "%02d/%02d %d:%d:%d %d", 
	    &time.tm_mon, &time.tm_mday,
	    &time.tm_hour, &time.tm_min, &time.tm_sec, &time.tm_year );

    time.tm_year -= 1900;
    time.tm_mon--;
    time.tm_isdst = 0;

    /* Convert 'struct tm' to 'time_t' */
    ret = mktime( &time );

    if( ret == -1 ){
    }

    return ret;
}


/*****************************************/
/* SortMailInfo                          */
/* MailInfo򥽡Ȥ            */
/* mode: 0=none  1=date_new  2=date_old  */
/*****************************************/
BOOL SortMailInfo( int nmail, MailInfo *mlist )
{
    int i, j;
    int lowest;
    MailInfo mtmp;
    time_t key;

    if( nmail < 1 || mlist == NULL) return FALSE;

#ifdef DEBUG
    fprintf( stderr, "SortMailInfo.%d mails.", nmail );
#endif

    switch( opinfo.sort ){
    case 0: /* Case of none sorting */
#ifdef DEBUG
	fprintf( stderr, "none." );
#endif
	break;

    case 1: /* Case of old order */
#ifdef DEBUG
	fprintf( stderr, "old." );
#endif
	for( i=0 ; i < nmail-1 ; i++ ){
	    lowest = i;
	    key = mlist[i].time;

	    for( j=i+1 ; j<nmail ; j++ ){
		if( mlist[j].time < key ){
		    lowest = j;
		    key = mlist[j].time;
		}
	    }
	    mtmp             = mlist[i];
	    mlist[i]      = mlist[lowest];
	    mlist[lowest] = mtmp;
	}
	break;

    case 2: /* Case of new order */
#ifdef DEBUG
	fprintf( stderr, "new." );
#endif
	for( i=0 ; i < nmail-1 ; i++ ){
	    lowest = i;
	    key = mlist[i].time;

	    for( j=i+1 ; j<nmail ; j++ ){
		if( mlist[j].time > key ){
		    lowest = j;
		    key = mlist[j].time;
		}
	    }
	    mtmp             = mlist[i];
	    mlist[i]      = mlist[lowest];
	    mlist[lowest] = mtmp;
	}
	break;

    default:
#ifdef DEBUG
	fprintf( stderr, "other." );
#endif
	return FALSE;
	break;
    }

#ifdef DEBUG
    fprintf( stderr, "...Ok.\n" );
#endif

    return TRUE;
}



/*********************************************/
/* GetMailInfo                               */
/* Read mailfile contents and set structure. */
/*********************************************/
int GetMailInfo(MailInfo **mlist, int *mlist_n,
		MailInfo **nlist, int *nlist_n,
		BOOL force)
{
    int ret = 0;      /* Return value is the count of mails */

    /* If already allocated memory then ... */
    if( *mlist != NULL ){
	free( *mlist );
	*mlist = NULL;
    };
    if( *nlist != NULL ){
	free( *nlist );
	*nlist = NULL;
    };

    do{
	switch( opinfo.mode ){
	case XQB_MODE_DIR:    /* Case of Maildir */
	    ret = GetMailInfoMaildir(mlist,mlist_n,nlist,nlist_n,force);
	    break;

	case XQB_MODE_BOX:    /* Case of Mailbox */
	    ret = GetMailInfoMailbox(mlist,mlist_n,nlist,nlist_n,force);
	    break;

	case XQB_MODE_POP:    /* Case of Pop */
	    ret = GetMailInfoPop(mlist,mlist_n,nlist,nlist_n,force);
	    break;

	default:
	    break;
	};

    } while( ret == -2 );


    if( ret > 0 ){
	SortMailInfo( *mlist_n, *mlist );
	SortMailInfo( *nlist_n, *nlist );
    }


#ifdef DEBUG
    {
	int i;
	for( i=0 ; i<*mlist_n ; i++ ){
	    fprintf( stderr, "\n%d:\nFrom: %s\nSubject: %s\nDate: %s\n", i+1,
		     (*mlist)[i].from, (*mlist)[i].subject, (*mlist)[i].date );
	}
	fprintf( stderr, " %d \n", *mlist_n );
    }
#endif
    return ret;
}


/**********************************************************************/
/* GetMailLineFile                                                    */
/* ᡼ե뤫ʸɤ߹                                 */
/* ᡼νɤ߹ʤäˤ FALSE ֤                */
/* fp    : File pointer                                               */
/* rbuf  : ʸ֤                                       */
/* rlen  : ʸ                                         */
/**********************************************************************/
BOOL GetMailLineFile( FILE *fp, char *ret, int rlen )
{
    char *buff=NULL, c;
    BOOL flag;


    /* Allocate work memory. */
    if( NULL == (buff=(char*)malloc(sizeof(char)*rlen)) ){
#ifdef DEBUG
	fprintf( stderr, "GetMailLineFile(): Can't allocate memory.\n" );
#endif
	return FALSE;
    }

    /* Initioalization. */
    ret[0] = '\0';
    buff[0] = '\0';


    /*
     * Start read.
     */

    /* Read a line. */
    if( -1==fgetline(buff,rlen,fp) ){
	free(buff);

	fprintf( stderr, "GetMailLineFile(): fgetline error.\n" );

	return FALSE;
    }

    strcpy( ret, buff );
    
    flag = TRUE;
    do{
	/* Read a next line. */
	c = fgetc(fp);

	if( c==EOF ){
	    /*
	     * If end of file then ...
	     */

	    flag = FALSE;

	} else if( 0x20 < c ||  c=='\n' || c=='\0' ){
	    /*
	     * If next line is other text then ...
	     */
	    ungetc(c,fp);
	    flag = FALSE;

	} else {
	    /*
	     * If next line is subsequence (c < 0x20)then ...
	     */
	    if( -1 == fgetline(buff,rlen,fp) ){
		flag = FALSE;
	    } else if( strlen(ret) < rlen-1 ){
		int i=0;
		while( buff[i] <= 0x20 ) i++;
		strncat( ret, &(buff[i]), rlen-(strlen(ret)-1) );
	    }
	}

    } while( flag );

    free(buff);

    return TRUE;
}


/**********************************************************************/
/* GetMailLineSock                                                    */
/* եǥץ꥿ʸɤ߹                         */
/* ᡼νɤ߹ʤäˤ FALSE ֤                */
/* fp    : File descriptor                                            */
/* rbuf  : ʸ֤                                       */
/* rlen  : ʸ                                         */
/**********************************************************************/
BOOL GetMailLineSock( int s, char *ret, int rlen )
{
    char *buff=NULL, c;
    int i;
    BOOL flag;


    /* Allocate work memory. */
    if( NULL == (buff=(char*)malloc(sizeof(char)*rlen)) ){
#ifdef DEBUG
	fprintf( stderr, "GetMailLineSock(): Can't allocate memory.\n" );
#endif
	return FALSE;
    }

    /* Initialization. */
    ret[0] = '\0';
    buff[0] = '\0';


    /*
     * Start read.
     */

    /* Read a line. */
    if( FALSE==PopReadALine( s, buff, rlen ) ){
	free(buff);
	return FALSE;
    }

    strcpy( ret, buff );


    if( !(ret[0]=='.' && ret[1]=='\0') ){
	flag = TRUE;
	do{
	    /* Read a next line. */
	    i = recv( s, &c, 1, MSG_PEEK );

	    if( i <= 0 ){
		/*
		 * If end of file then ...
		 */
		flag = FALSE;

	    } else if( 0x20<c ||  buff[0]=='\n' || buff[0]=='\0' ){
		/*
		 * If next line is other text  ...
		 */
		flag = FALSE;

	    } else {
		/*
		 * If next line is subsequence then ...
		 */
		if( FALSE==PopReadALine( s, buff, rlen ) ){
		    flag = FALSE;
		} else {
		    if( rlen > strlen(ret)-1 ){
			i=0;
			while( buff[i] <= 0x20 ) i++;

			strncat( ret, &(buff[i]), rlen-strlen(ret)-1 );
		    }
		}
	    }
	} while( flag );
    }

    free(buff);
/*
    printf( "ReadLine: %s\n", ret );
*/
    return TRUE;
}


/**********************************************************************/
/* GetMailText                                                        */
/* ᡼ե POP Ф'From''Subject''Date'ɤ߹ */
/* ɤ߹Ǥο֤                                           */
/**********************************************************************/
int GetMailText( int fd, FILE *fp,
                 char from[], char subj[], char date[], char to[] )
{
    char buff[XQB_TEXTBUFF_LEN];
    char dbuff[XQB_TEXTBUFF_LEN];
    char datebuff[XQB_TEXTBUFF_LEN];
    char recvbuff[XQB_TEXTBUFF_LEN];
    int  rcnt = 0;

    iStrInit( buff, XQB_TEXTBUFF_LEN  );
    iStrInit( dbuff, XQB_TEXTBUFF_LEN );
    iStrInit( datebuff, XQB_TEXTBUFF_LEN  );
    iStrInit( recvbuff, XQB_TEXTBUFF_LEN );

    /* Initialization */
    from[0] = '\0';
    subj[0] = '\0';
    date[0] = '\0';
    to[0] = '\0';


    while( from[0] == '\0' || subj[0] == '\0' ||
	   to[0] == '\0' || date[0] == '\0' ){

	/* Read a line */
	if( opinfo.mode == XQB_MODE_DIR || opinfo.mode == XQB_MODE_BOX ){
	    if( FALSE == GetMailLineFile( fp, buff, XQB_TEXTBUFF_LEN ) ){
		buff[0] = '\0';
	    }
	} else if( opinfo.mode == XQB_MODE_POP ){
	    if( FALSE == GetMailLineSock( fd, buff, XQB_TEXTBUFF_LEN )
		|| buff[0] == '.' ){
		buff[0] = '\0';
	    }
	}
/*
printf( "Line: %s\n", buff );
*/
	if( buff[0] == '\0' ){
	    break;
        } else if( 0 == strncmp( buff, "From:", 5 ) && from[0] == '\0' ){
	    /* ʸ,FromιԤäȤ */
	    if( strlen(buff) > 5 ){
		strcpy( from, &(buff[5]) );
		rcnt++;
	    }
	} else if( 0 == strncmp( buff, "Received:", 9 ) && recvbuff[0] == '\0' ){
	    /* ʸ,ReceivedιԤäȤ */
	    if( strlen(buff) > 9 ){
		ReceivedDecode( buff, recvbuff );
	    }
	} else if( 0 == strncmp( buff, "Date:", 5 ) && datebuff[0] == '\0' ){
	    /* ʸ,DateιԤäȤ */
	    if( strlen(buff) > 5 ){
		ReceivedDecode( buff, datebuff );
	    }
	} else if( 0 == strncmp( buff, "Subject:", 8 ) && subj[0] == '\0' ){
	    /* ʸ,SubjectιԤäȤ */
	    if( strlen(buff) > 8 ){
		strcpy( subj, &(buff[8]) );
		rcnt++;
	    }
	} else if( 0 == strncmp( buff, "To:", 3 ) && to[0] == '\0' ){
	    /* ʸ,ToιԤäȤ */
	    if( strlen(buff) > 3 ){
		strcpy( to, &(buff[3]) );
		rcnt++;
	    }
	}
    }

    if( recvbuff[0] != '\0' ){
	strcpy( date, recvbuff );
	rcnt++;
    } else if( datebuff[0] != '\0' ){
	strcpy( date, datebuff );
	rcnt++;
    } else if( date[0] == '\0' ){
	strcpy( date, " \?\?/\?\? \?\?:\?\?:\?\? \?\?\?\?" );
    }

    return;
}


/******************************************************/
/* SetMailColorInfo                                   */
/******************************************************/
void SetMailColorInfo( MailInfo *minfo, int nmail,
		       TextInfo *tinfo, BOOL *tflag)
{
    int i, j;
    BOOL fc, sc;
    BOOL fk, sk;

#if 0
    for( i=0 ; i<TEXT_COLOR_INFO_MAX ; i++ ){
	printf( "%d: fromkey    : %s\n", i, tinfo->tinf[i].fromkey );
	printf( "%d: subjkey    : %s\n", i, tinfo->tinf[i].subjkey );
	printf( "%d: fromtbold  : %d\n", i, tinfo->tinf[i].fromtbold );
	printf( "%d: subjtbold  : %d\n", i, tinfo->tinf[i].subjtbold );
	printf( "%d: fromnbold  : %d\n", i, tinfo->tinf[i].fromnbold );
	printf( "%d: subjnbold  : %d\n", i, tinfo->tinf[i].subjnbold );
	printf( "%d: datenbold  : %d\n", i, tinfo->tinf[i].datenbold );
	printf( "%d: numbbold  : %d\n", i, tinfo->tinf[i].numbbold );
    }
#endif

    *tflag = FALSE;

    for( i=0 ; i<nmail ; i++ ){
	minfo[i].ColorID = 0;
	for( j=1 ; j<TEXT_COLOR_INFO_MAX ; j++ ){
	    fc = sc = fk = sk = FALSE;

	    if( 0 != strcmp( tinfo->tinf[j].fromkey, "" ) ){
		fk = TRUE;
		if( NULL != 
		    strstr(minfo[i].from,tinfo->tinf[j].fromkey) ){
		    fc = TRUE;
		}
	    }
	    if( 0 != strcmp( tinfo->tinf[j].subjkey, "" ) ){
		sk = TRUE;
		if( NULL !=
		    strstr(minfo[i].subject,tinfo->tinf[j].subjkey) ){
		    sc = TRUE;
		}
	    }
	    if( fk == FALSE && sk == FALSE )
		continue;

	    if( fk == TRUE && fc == FALSE )
		continue;

	    if( sk == TRUE && sc == FALSE )
		continue;

	    minfo[i].ColorID = j;

	    break;
	}

	if( iBitGet(transcfg,minfo[i].ColorID) ){
	    *tflag = TRUE;
	}

    }
    return;
}

