/*
  xqbiff  -- "biff" program for qmail.
  Copyright (C) 1998-2003 Yusuke Ishizawa <yu-i@wmail.plala.or.jp>

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2, or (at your option) any
  later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
/*
 * img.c
 *
 */

#include"xqb.h"
#include"defpix.xpm"
#include"defpix.xbm"
#include"defpix2.xpm"


/*
#undef HAVE_ZLIB_H
*/
#ifdef HAVE_ZLIB_H
#include<zlib.h>
#endif
/*
#define DEBUG
*/

extern char* ReadXpmFileToBuffer( char *filename );
extern Pixel pixel_bg;
extern Pixel pixel_fg;



/*********************************************/
/* GetTok()                                  */
/* ʸ󤫤ȡФ            */
/*  src  : ʸ                        */
/*  ret  : ̥ȡ                      */
/*  max  : ȡκĹ                  */
/*  tail : ȡڤФĤʸ  */
/*   : ȡʸ                  */
/*********************************************/
int GetTok( char *src, char *ret, int max, char *tail )
{
    int i=0, j;
    char *buf = (char*)malloc(sizeof(char)*strlen(src));

    if( buf == NULL ){
        fprintf( stderr, "xqbiff: Can't allocate memory.\n" );
        exit(1);
    }

#ifdef DEBUG
    fprintf( stderr, "GetTok(): src: \"%s\" %d\n", src, strlen(src) );
#endif

    strcpy( buf, src );

    /*
     * , TAB, Ԥ̵뤹
     */
    /*
     * Ȥ̵뤷Τ '/'  '*' ɤФ
     * ȴб
     */
     while( buf[i]==' ' || buf[i]=='\t' || buf[i]=='\n'
           || buf[i]=='*' || buf[i]=='/' ) i++;

    if( buf[i]=='\0' ){
        free(buf);
        return 0;
    }

    /*
     * ȡФ
     */
    j=0;
    while( j < max && buf[i]!=' ' && buf[i]!='\t'
           && buf[i]!='\n' && buf[i]!='\0' ){
        ret[j++] = buf[i++];
    }
    ret[j]='\0';

#ifdef DEBUG
    fprintf( stderr, "GetTok(): ret: \"%s\" ", ret );
#endif

    /*
     * ĤʬζƤ
     */
    while( i < strlen(src) &&
           (buf[i]==' ' || buf[i]=='\t' || buf[i]=='\n'
            || buf[i]=='*' || buf[i]=='/') ) i++;

    if( buf[i]=='\0' || i==strlen(src) )
        tail[0] = '\0';
    else 
        strcpy( tail, &(buf[i]) );

#ifdef DEBUG
    fprintf( stderr, " tail: \"%s\"\n", tail );
#endif

    free(buf);

    return j;
}

#ifdef HAVE_ZLIB_H
#define __FPTYPE        gzFile
#define __FOPEN(x,y)    gzopen(x,y)
#define __FCLOSE(x)     if(Z_OK!=gzclose(x))fprintf(stderr,"Can't close gzfile.\n");
#define __FREAD(x,y,z)  gzread(x,y,z)
#else
#define __FPTYPE        FILE*
#define __FOPEN(x,y)    fopen(x,y)
#define __FCLOSE(x)     fclose(x)
#define __FREAD(x,y,z)  fread(y,1,z,x)
#endif


/************************/
/* GetIminfo            */
/* ǡξ */
/************************/
BOOL GetIminfo( Iminfo *iminfo )
{
    __FPTYPE  fp;
    char *cp, temp[1024], ctmp;
    int i, j;
    int size_flag = 0;
    int an_flag[5] = {0, 0, 0, 0, 0};

#ifdef DEBUG
    fprintf( stderr, "GetIminfo().\n" );
#endif



    if( -1 == iAccess( iminfo->imname, I_R_OK | I_F_OK  ) ){
	return FALSE;
    }

#ifndef HAVE_ZLIB_H
    if( 0 == strcmp( &(iminfo->imname[strlen(iminfo->imname)-3]), ".gz" ) ){
	fprintf( stderr, "Can't use compressed image file by gzip.\n" );
	return FALSE;
    }
#endif

    if( NULL == (fp = __FOPEN( iminfo->imname, "rb" )) ){
	fprintf( stderr, "Can't open file: %s\n", iminfo->imname );
	return FALSE;
    }


    for(;;){
	j=0;

	/*
	 * ե뤫 1ʬɤ߹
	 */
#ifdef HAVE_ZLIB_H
	do{
	    i = gzread( fp, &ctmp, 1 );

	    if( j < 1024 ) temp[j++] = ctmp;

	} while( i > 0 && ctmp != '\n' );
#else
	fgets( temp, 1024, fp );
	j = strlen(temp);
#endif
	if( j==0 ) break;
	temp[j-1] = '\0';

	/*
	 * ʸβ
	 */

	if( NULL != (cp = strstr(temp, "XQBIFF_SIZE_INFO")) ){
	    /*
	     * Υ
	     */
	    if( 2 != sscanf( cp, "XQBIFF_SIZE_INFO %d %d",
			       &(iminfo->pwidth), &(iminfo->pheight) ) ){
		fprintf( stderr, "Animation information error: %s\n",
			 iminfo->imname );
		__FCLOSE(fp);
		return FALSE;
	    }
	    if( iminfo->pwidth < 0 || iminfo->pheight < 0 ){
		fprintf( stderr, "Animation information error: %s\n",
			 iminfo->imname );
		__FCLOSE(fp);
		return FALSE;
	    }
	    size_flag = 1;
	} else if( NULL != (cp = strstr(temp, "XQBIFF_ANIMATION_INFO")) ){
	    /*
	     * ˥᡼˴ؤ
	     */
	    if( 1 != sscanf( cp, "XQBIFF_ANIMATION_INFO%d", &j ) ||
		j < 1 || 5 < j ){
		fprintf( stderr, "Animation information error: %s %d\n",
			 iminfo->imname, j );
		__FCLOSE(fp);
		return FALSE;
	    }

	    {
		char buf[1024];
		char ctok[256];
		int i;

		strncpy( buf, cp, 1023 );
		buf[1023] = '\0';

		if( 0 == GetTok( buf, ctok, 255, buf ) ){
		    fprintf( stderr, "Animation information error: %s\n",
			     iminfo->imname );
		    __FCLOSE(fp);
		    return FALSE;
		}
#ifdef DEBUG
		fprintf( stderr, "%d:%s ", j, ctok );
#endif		
		/* ޿ */
		if( 0 == GetTok( buf, ctok, 255, buf ) ||
		    0 > (iminfo->pt[j-1] = atoi( ctok )) ){
		    fprintf( stderr, "Animation information error: %s\n",
			     iminfo->imname );
		    __FCLOSE(fp);
		    return FALSE;
		}
#ifdef DEBUG
		fprintf( stderr, "%d\n", iminfo->pt[j-1] );
#endif
		if( iminfo->asp[j-1] != NULL )
		    free( iminfo->asp[j-1] );
		iminfo->asp[j-1] = (double*)malloc(sizeof(double)*iminfo->pt[j-1]);


		/* ˥᡼®٤ */
		if( 0 == GetTok( buf, ctok, 255, buf ) ||
		    0 >= (iminfo->asp[j-1][0] = atof( ctok )) ){
		    fprintf( stderr, "Animation information error: %s\n",
			     iminfo->imname );
		    __FCLOSE(fp);
		    return FALSE;
		}

		i=1;
		while( i<iminfo->pt[j-1] && 0<GetTok( buf, ctok, 255, buf ) ){
		    if( 0 >= (iminfo->asp[j-1][i] = atof( ctok )) )
			break;
		    i++;
		}

		while( i<iminfo->pt[j-1] ){
		    iminfo->asp[j-1][i] = iminfo->asp[j-1][i-1];
		    i++;
		}
	    }
	    an_flag[j-1] = 1;
	} else if( NULL == strstr(temp, "/*") ) { /* ʸν */
	    iminfo->ptn =  an_flag[0] + an_flag[1] + an_flag[2] + 
		an_flag[3] + an_flag[4];
	    if( size_flag + iminfo->ptn >= 5 ){
		__FCLOSE(fp);
#ifdef DEBUG
		fprintf( stderr, "GetIminfo()  %d...Ok.\n", iminfo->ptn );
#endif
		return TRUE;
	    }
	}
    }
    __FCLOSE(fp);

    fprintf( stderr, "˥᡼ɬפʾ­ޤ\n" );

    return FALSE;
}

/******************************************/
/* CreateAnimPixmap                       */
/* ˥᡼ѥԥޥåפ */
/******************************************/
void CreateAnimPixmap( Display *d, Window m_wnd, Window r_wnd,
		       Visual *vis,
		       Colormap cmap, int depth, int screen_num,
		       Pixmap **ipmap, Pixmap **mpmap,
		       Iminfo *iminfo )
{
    int           i, j;
    GC            ipgc, mpgc;
    XGCValues     gcval;
    XpmAttributes imattr;        /* xpmξ */
    int           r = -1;
    BOOL          eflag = FALSE;

    if( 0 != strcmp( opinfo.image, "none" ) ){
	/* Case of use named image */

	Pixmap iptmp = 0, mptmp = 0;
	char *buff;

	/* Create image pixmap */

#ifdef DEBUG
	fprintf( stderr, "Read xpm file.%s\n", iminfo->imname );
#endif

	imattr.depth     = depth;
	imattr.visual    = vis;
	imattr.colormap  = cmap;
	imattr.valuemask = XpmSize | XpmDepth | XpmColormap | XpmVisual;

	if( NULL != (buff = ReadXpmFileToBuffer( iminfo->imname )) ){
#ifdef DEBUG
	    fprintf( stderr, "Read xpm file..Ok.\n" );
#endif
#ifdef HAVE_IMLIB_H
	    {
		ImlibImage *im;
		XpmImage xim;
		XpmInfo  xif;
		char **data;

		r = XpmCreateXpmImageFromBuffer( buff, &xim, &xif );
		if( r != 0 ){
		    fprintf(stderr,"XpmCreateXpmImageFromBuffer error (%d)",r);
		}

		r = XpmCreateDataFromXpmImage( &data, &xim, &xif );
		if( r != 0 ){
		    fprintf(stderr,"XpmCreateDataFromImage error (%d)",r);
		}

		im=Imlib_create_image_from_xpm_data(imlibdata,data);

		Imlib_render( imlibdata, im, im->rgb_width, im->rgb_height );

		iptmp = Imlib_move_image( imlibdata, im );
		mptmp = Imlib_move_mask( imlibdata, im );

		imattr.width  = im->rgb_width;
		imattr.height = im->rgb_height;

		XpmFree(data);
		XpmFreeXpmImage(&xim);
		Imlib_kill_image( imlibdata, im );
	    }
	    r=0;
#else
	    r = XpmCreatePixmapFromBuffer( d, m_wnd, buff,
					   &iptmp, &mptmp, &imattr );
#endif
	    free(buff);
	}

	/* ɤ߹ߤ */
	if( 0 == r ){
#ifdef DEBUG
	    fprintf( stderr, "Create image success.(%dx%d)\n",
		     imattr.width, imattr.height );
#endif

	    /* ѥԥޥåפѰ */
	    for( i=0 ; i<iminfo->ptn ; i++ ){
		ipmap[i] = (Pixmap*)malloc(sizeof(Pixmap)*iminfo->pt[i]);
		for( j=0 ; j<iminfo->pt[i] ; j++ ){
		    ipmap[i][j] = XCreatePixmap( d, m_wnd, 
						 iminfo->pwidth,
						 iminfo->pheight,
						 depth );
		}
	    }

	    gcval.function           = GXcopy;
	    gcval.graphics_exposures = False;
	    ipgc = XCreateGC( d, ipmap[0][0], GCFunction |
			      GCGraphicsExposures, &gcval );


	    /* Copy to pixmap from temporary */
	    for( i=0 ; i<iminfo->ptn ; i++ ){
		for( j=0 ; j<iminfo->pt[i] ; j++ ){
		    XCopyArea( d, iptmp, ipmap[i][j], ipgc,
			       i*iminfo->pwidth, j*iminfo->pheight,
			       iminfo->pwidth, iminfo->pheight, 0, 0 );
		}
	    }

	    XFreeGC( d, ipgc );
	    XFreePixmap( d, iptmp );

	    if( mptmp == 0 )
		opinfo.shape = FALSE;
	    else if( opinfo.shape == TRUE ){
		/* ޥ󤬤 */
#ifdef DEBUG
		fprintf( stderr, "Create Mask Pixmap." );
#endif

		/* ޥѥԥޥåפѰ */
		for( i=0 ; i<iminfo->ptn ; i++ ){
		    mpmap[i] = (Pixmap*)malloc(sizeof(Pixmap)*iminfo->pt[i]);
		    for( j=0 ; j<iminfo->pt[i] ; j++ ){
			mpmap[i][j] = XCreatePixmap( d, m_wnd, iminfo->pwidth,
						     iminfo->pheight, 1 );
		    }
		}

		gcval.function           = GXcopy;
		gcval.graphics_exposures = False;
		mpgc = XCreateGC( d, mpmap[0][0], GCFunction |
				  GCGraphicsExposures, &gcval );

		XSetForeground( d, mpgc, XWhitePixel(d,screen_num) );

		/* Copy to pixmap from temporary */
		for( i=0 ; i<iminfo->ptn ; i++ ){
		    for( j=0 ; j<iminfo->pt[i] ; j++ ){
			XFillRectangle( d, mpmap[i][j], mpgc, 0, 0,
					iminfo->pwidth, iminfo->pheight );
			XCopyArea( d, mptmp, mpmap[i][j], mpgc,
				   i*iminfo->pwidth, j*iminfo->pheight,
				   iminfo->pwidth, iminfo->pheight, 0, 0 );
		    }
		}

		XFreeGC( d, mpgc );
		XFreePixmap( d, mptmp );

		XSetTransientForHint( d, m_wnd, r_wnd );
	    }
	} else {
	    fprintf( stderr, "Create image failed.(%s)(%d)\n",
		     iminfo->imname, r );
	    eflag = TRUE;
	}
    }
    if( ipmap[0] == NULL || 0 == strcmp( opinfo.image, "none" ) ){

	/*
	 * ꤵƤʤ, ɤ߹ߤ˼Ԥϡ
	 * Ȥ߹ߤβѤ
	 */

	Pixmap iptmp, ipmtmp;

	/* Case of use default image */
#ifdef DEBUG
	fprintf( stderr, "Creating default image " );
#endif
	/* Shape off */
	opinfo.shape = FALSE;

	iminfo->width   = 192;
	iminfo->height  = 192;
	iminfo->pwidth  = 48;
	iminfo->pheight = 48;
	iminfo->pt[0]   = 2;
	iminfo->pt[1]   = 4;
	iminfo->pt[2]   = 4;
	iminfo->pt[3]   = 4;
	iminfo->pt[4]   = 4;

	for( i=0 ; i<5 ; i++ ){
	    if( iminfo->asp[i] != NULL )
		free(iminfo->asp[i]);

	    iminfo->asp[i] = (double*)malloc(sizeof(double)*iminfo->pt[i]);

	    for( j=0 ; j<iminfo->pt[i] ; j++ ){
		iminfo->asp[i][j] = 0.8;
	    }
	}

#ifdef HAVE_IMLIB_H
	/* Imlib бƤߤޤ礫 */
	{
	    ImlibImage *im;

	    im=Imlib_create_image_from_xpm_data(imlibdata,defpix);
	    Imlib_render( imlibdata, im, im->rgb_width, im->rgb_height );
	    iptmp = Imlib_move_image( imlibdata, im );

	    imattr.width  = im->rgb_width;
	    imattr.height = im->rgb_height;

	    Imlib_kill_image( imlibdata, im );

#ifdef DEBUG
	    fprintf( stderr, "by Imlib.\n" );
#endif
	}
#else
	{
	    /* Create image pixmap */
	    imattr.depth     = depth;
	    imattr.colormap  = cmap;
	    imattr.visual    = vis;
	    imattr.valuemask = XpmSize | XpmDepth | XpmVisual;
	    imattr.valuemask = XpmSize | XpmDepth | XpmColormap | XpmVisual;

#ifdef DEBUG
	    fprintf( stderr, "by libXpm.\n" );
#endif

	    /* Ȥ߹ߥ顼 */
	    if( depth == 8 ){
#ifdef DEBUG
		fprintf( stderr, "XpmCreatePixmapFromData(defpix2)\n" );
#endif
		r = XpmCreatePixmapFromData( d, m_wnd, defpix2,
					     &iptmp, NULL, &imattr );
	    } else {
#ifdef DEBUG
		fprintf( stderr, "XpmCreatePixmapFromData(defpix)\n" );
#endif
		r = XpmCreatePixmapFromData( d, m_wnd, defpix,
					     &iptmp, NULL, &imattr );
	    }

	    if( 0 != r ){

		fprintf(stderr,"XpmCreatePixmapFromData failed.(%d)\n",r);

#ifdef DEBUG
		fprintf( stderr, "XCreatePixmapFromBitmapData\n" );
#endif
		/* ԤΥ */
		iptmp = XCreatePixmapFromBitmapData( d, m_wnd, defpix_bits, 
						     defpix_width, defpix_height,
						     pixel_fg, pixel_bg, depth );
		if( iptmp == 0 ){
		    fprintf( stderr, "Can't create image.\n" );
		    exit(1);
		} else if( eflag == TRUE ){
		    fprintf( stderr, "use default image.(mono)\n" );
		}
		iminfo->height  = 96;
		iminfo->pt[0] = 1;
		iminfo->pt[2] = 2;
		iminfo->pt[3] = 2;
		iminfo->pt[4] = 2;
	    } else if( eflag == TRUE ){
		fprintf( stderr, "use default image.(color)\n" );
	    }
	}
#endif

	/* ѥԥޥåפѰ */
	for( i=0 ; i<5 ; i++ ){
	    ipmap[i] = (Pixmap*)malloc(sizeof(Pixmap)*iminfo->pt[i]);
	    for( j=0 ; j<iminfo->pt[i] ; j++ ){
		ipmap[i][j] = XCreatePixmap( d, m_wnd, iminfo->pwidth,
					     iminfo->pheight, depth );
	    }
	}

	gcval.function           = GXcopy;
	gcval.graphics_exposures = False;
	ipgc = XCreateGC( d, ipmap[0][0], GCFunction |
			  GCGraphicsExposures, &gcval );


	/* Copy to pixmap from temporary */
	for( i=0 ; i<5 ; i++ ){
	    for( j=0 ; j<iminfo->pt[i] ; j++ ){
		XCopyArea( d, iptmp, ipmap[i][j], ipgc,
			   i*iminfo->pwidth, j*iminfo->pheight,
			   iminfo->pwidth, iminfo->pheight, 0, 0 );
	    }
	}

	XFreeGC( d, ipgc );
	XFreePixmap( d, iptmp );

	iminfo->ptn = 5;
    }

    iminfo->width = imattr.width;
    iminfo->height = imattr.height;


#ifdef DEBUG
    fprintf( stderr, "..Ok.\n" );
#endif

    return;
}


#define BUFFMAX 1024

char* ReadXpmFileToBuffer( char *filename )
{
    char   *buff = NULL, *tp;
    char    temp[BUFFMAX];
    __FPTYPE  fp=NULL;
    int     bt=0, rd=0;                /* Buffer size, Read size */

#ifdef DEBUG
    fprintf( stderr, "ReadXpmFileToBuffer()." );
#endif

    if( NULL == (fp = __FOPEN( filename, "rb" )) ){
        fprintf( stderr, "Can't open file: %s\n", filename );
        return NULL;
    }
#ifdef DEBUG
    fprintf( stderr, "file open(%s).", filename );
#endif

    while( 0 < (rd = __FREAD( fp, (void*)temp, sizeof(char)*BUFFMAX )) ){

	tp = buff;

	if( NULL == (buff = (char*)realloc( buff, bt+rd )) ){
	    free( tp );
	    __FCLOSE(fp);
	    fprintf( stderr, "ReadXpmFileToBuffer: Can't alloc memory.(%dbyte)\n", bt+rd );
	    return NULL;
	}
	memcpy( &buff[bt], temp, rd );
	bt += rd;
    }

    __FCLOSE(fp);

#ifdef DEBUG
    fprintf( stderr, "..Ok.%d\n", bt );
#endif

    return buff;
}


