/*
# X-BASED THREED
#
#  Threed.h
#
###
#
#  Copyright (c) 1994 - 2007	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "useful",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Public header file for Threed */

#ifndef _XtThreed_h
#define _XtThreed_h

/***********************************************************************
 *
 * 3D Widget
 *
 ***********************************************************************/

#ifndef WINVER
#define XtNmono ((char *) "mono")
#define XtNframeColor ((char *) "frameColor")
#define XtNanotherBrush ((char *) "anotherBrush")
#define XtNblackBrush ((char *) "blackBrush")
#define XtNdkgrayBrush ((char *) "dkgrayBrush")
#define XtNgrayBrush ((char *) "grayBrush")
#define XtNltgrayBrush ((char *) "ltgrayBrush")
#define XtNwhiteBrush ((char *) "whiteBrush")
#define XtNsurfaceBorder ((char *) "surfaceBorder")
#define XtNinstall ((char *) "install")
#define XtNpicture ((char *) "picture")
#define XtNdelay ((char *) "delay")
#define XtNsound ((char *) "sound")
#define XtNmoveSound ((char *) "moveSound")
#define XtNxDistance ((char *) "xDistance")
#define XtNyDistance ((char *) "yDistance")
#define XtNzDistance ((char *) "zDistance")
#define XtNthetaDegrees ((char *) "thetaDegrees")
#define XtNphiDegrees ((char *) "phiDegrees")
#define XtNpsiDegrees ((char *) "psiDegrees")
#define XtNsurface ((char *) "surface")
#define XtNobject ((char *) "object")
#define XtNobjectName ((char *) "objectName")
#define XtNobjectNumber ((char *) "objectNumber")
#define XtNobjectList ((char *) "objectList")
#define XtNversionOnly ((char *) "versionOnly")
#define XtNmenu ((char *) "menu")
#define XtNbuffer ((char *) "buffer")
#define XtNselectCallback ((char *) "selectCallback")
#define XtCMono ((char *) "Mono")
#define XtCInstall ((char *) "Install")
#define XtCPicture ((char *) "Picture")
#define XtCDelay ((char *) "Delay")
#define XtCSound ((char *) "Sound")
#define XtCMoveSound ((char *) "MoveSound")
#define XtCXDistance ((char *) "XDistance")
#define XtCYDistance ((char *) "YDistance")
#define XtCZDistance ((char *) "ZDistance")
#define XtCThetaDegrees ((char *) "ThetaDegrees")
#define XtCPhiDegrees ((char *) "PhiDegrees")
#define XtCPsiDegrees ((char *) "PsiDegrees")
#define XtCSurface ((char *) "Surface")
#define XtCObject ((char *) "Object")
#define XtCObjectName ((char *) "ObjectName")
#define XtCObjectNumber ((char *) "ObjectNumber")
#define XtCObjectList ((char *) "ObjectList")
#define XtCMenu ((char *) "Menu")
#define XtCBuffer ((char *) "Buffer")

typedef struct _ThreeDClassRec *ThreeDWidgetClass;

extern WidgetClass threedWidgetClass;

typedef struct {
  int reason;
  XEvent *event;
  char message[81];
} threedCallbackStruct;
#endif

#define THREED_HIDE (-1)
#define THREED_SET 0
#define THREED_SURFACE 1
#define THREED_OBJECT 2
#define THREED_SPEED 3
#define NUM_DEGREES 360
#define ST_ANGLE 180
#define RT_ANGLE 90

#define MINDISTANCE (-100)
#define MAXDISTANCE 100
#define MINDEPTH (-50)
#define MAXDEPTH 150
#define MINDEGREES 0
#define MAXDEGREES (NUM_DEGREES-1)

#define DEFAULTSURFACE TRUE
#ifdef WINVER
#ifdef UNIXDELIM
#define CURRENTDELIM "./"
#define FINALDELIM "/"
#else
#define CURRENTDELIM ".\\"
#define FINALDELIM "\\"
#endif
#else
#ifdef VMS
#define CURRENTDELIM "[]"
#define FINALDELIM ""
#else
#define CURRENTDELIM "./"
#define FINALDELIM "/"
#endif
#endif
#ifdef MONOTEST
#define DEFAULTMONO TRUE
#else
#define DEFAULTMONO FALSE
#endif
#define DEFAULTREVERSE FALSE

typedef struct _ThreeDRec *ThreeDWidget;

typedef struct _IntPoint3D {
	int x, y, z;
} IntPoint3D;

typedef struct _IntAngle3D {
	int theta; /* relative to y axis */
	int phi; /* relative to x axis */
	int psi; /* relative to z axis */
} IntAngle3D;

extern void intCat(char ** string, const char * var1, const int var2);
#if 0
extern void stringCat(char ** string, const char * var1, const char * var2);
#endif

#endif /* _XtThreed_h */
/* DON'T ADD STUFF AFTER THIS #endif */
