/*-
# X-BASED DINOSAUR CUBE
#
#  DinoP.h
#
###
#
#  Copyright (c) 1995 - 2006	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Private header file for Dino */

#ifndef _DinoP_h
#define _DinoP_h

#include "xwin.h"
#include "timer.h"
#include "Dino.h"

#ifdef WINVER
extern void DestroyPuzzle(HBRUSH brush);
extern void ResizePuzzle(DinoWidget w);
extern void SizePuzzle(DinoWidget w);
extern void InitializePuzzle(DinoWidget w, HBRUSH brush);
extern void ExposePuzzle(DinoWidget w);
extern void PeriodModePuzzle(DinoWidget w, const int mode);
extern void DimPuzzle(DinoWidget w);
extern int  MovePuzzleDir(DinoWidget w, const int direction);
extern void setPuzzle(DinoWidget w, int reason);
extern void setPuzzleMove(DinoWidget w, int reason, int face, int position,
	int direction, int style);

#else

/* This gets around C's inability to do inheritance */
typedef struct _DinoClassPart {
	int         ignore;
} DinoClassPart;

typedef struct _DinoClassRec {
	CoreClassPart coreClass;
	DinoClassPart dinoClass;
} DinoClassRec;

extern DinoClassRec dinoClassRec;

extern void QuitPuzzle(DinoWidget w, XEvent *event, char **args, int nArgs);
#endif

#define SYMBOL ':'

#define IGNORE_DIR (-1)
#define TR 0
#define BR 1
#define BL 2
#define TL 3
#define STRT 4
#define CW 5
#define HALF 6
#define CCW 7
#define TOP 8
#define RIGHT 9
#define BOTTOM 10
#define LEFT 11
#define MAXORIENT 4
#define MAXROTATE 3
#define CORNER 0
#define MIDDLE 1
#define EDGE 2
#define FACE 3

typedef struct _DinoCornerLoc {
	int         face, rotation;
} DinoCornerLoc;

typedef struct _MoveRecord {
#if 0
	int face, position, direction, style, control;
#endif
	unsigned long int packed;  /* This makes assumptions on the data. */
} MoveRecord;

typedef struct _MoveStack {
	MoveRecord move;
	struct _MoveStack *previous, *next;
} MoveStack;

typedef struct _DinoStack {
	MoveStack *currMove, *lastMove, *firstMove;
	int count;
} DinoStack;

typedef struct _DinoLoc {
	int face, side, dir;
} DinoLoc;

typedef struct _DinoPart {
	DinoCornerLoc cubeLoc[MAXFACES][MAXORIENT];
	DinoCornerLoc faceLoc[MAXORIENT];
	DinoCornerLoc rowLoc[MAXORIENT][MAXORIENT];
	DinoCornerLoc spindleLoc[MAXROTATE][2];
	int         currentFace, currentPosition, currentDirection;
	Boolean     started, cheat;
	Boolean     practice, orient, vertical, mono, reverse, focus;
	Boolean     scoreOnly, versionOnly;
	int         dim; /* This allows us to reuse code between 2d and 3d */
	int         degreeTurn, view;
	int         delay;
	int         mode, style;
	Position    delta;
	Position    orientLineLength;
	Point       puzzleSize;
	Point       puzzleOffset, letterOffset;
	GC          frameGC, borderGC, inverseGC;
	GC          faceGC[MAXFACES];
#ifdef WINVER
	char        userName[81], scoreFile[81];
	char        faceChar[MAXFACES];
#else
	int         menu;
	char       *userName, *scoreFile, *font;
	XFontStruct *fontInfo;
	char       *faceName[MAXFACES];
	Pixel       foreground, background;
	Pixel       frameColor, borderColor;
	Pixel       faceColor[MAXFACES];
	XtCallbackList select;
#endif
} DinoPart;

typedef struct _DinoRec {
	CorePart    core;
	DinoPart    dino;
} DinoRec;

typedef struct _RowNext {
	int         face, direction, side_face;
} RowNext;

extern void HidePuzzle(
#ifdef WINVER
const DinoWidget w
#else
DinoWidget w, XEvent *event, char **args, int nArgs
#endif
);
extern void SelectPuzzle(DinoWidget w
#ifdef WINVER
, const int x, const int y, const int control
#else
, XEvent *event, char **args, int nArgs
#endif
);
extern void ReleasePuzzle(DinoWidget w
#ifdef WINVER
, const int x, const int y, const int shift, const int control, const int alt
#else
, XEvent *event, char **args, int nArgs
#endif
);
#ifndef WINVER
extern void PracticePuzzleMaybe(DinoWidget w
, XEvent *event, char **args, int nArgs
);
extern void PracticePuzzle2(DinoWidget w
, XEvent *event, char **args, int nArgs
);
extern void RandomizePuzzleMaybe(DinoWidget w
, XEvent *event, char **args, int nArgs
);
extern void RandomizePuzzle2(DinoWidget w
, XEvent *event, char **args, int nArgs
);
#endif
extern void GetPuzzle(DinoWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void WritePuzzle(DinoWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void UndoPuzzle(DinoWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void RedoPuzzle(DinoWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void ClearPuzzle(DinoWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void RandomizePuzzle(DinoWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void SolvePuzzle(DinoWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void PracticePuzzle(DinoWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void OrientizePuzzle(DinoWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void ViewPuzzle(DinoWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void EnterPuzzle(DinoWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void LeavePuzzle(DinoWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
#ifndef WINVER
extern void Period2ModePuzzle(DinoWidget w
, XEvent *event, char **args, int nArgs
);
extern void Period3ModePuzzle(DinoWidget w
, XEvent *event, char **args, int nArgs
);
extern void BothModePuzzle(DinoWidget w
, XEvent *event, char **args, int nArgs
);
#endif

extern void MovePuzzleInput(DinoWidget w, int x, int y, int direction, int shift,
	int control, int alt);
extern void MovePuzzle(DinoWidget w, int face, int position, int direction,
	int style, int control);
extern void SetAllColors(DinoWidget w);
#if 0
/* For future auto-solver */
extern void SolvePieces(DinoWidget w);

#endif
extern void DrawAllPieces(DinoWidget w);
extern Boolean CheckSolved(DinoWidget w);
extern void newMoves(DinoStack *s);
extern void deleteMoves(DinoStack *s);
extern void setMove(DinoStack *s,
	int face, int position, int direction, int style, int control);
extern void getMove(DinoStack *s,
	int *face, int *position, int *direction, int *style, int *control);
extern int madeMoves(DinoStack *s);
extern void flushMoves(DinoWidget w, DinoStack *s, Boolean undo);
extern int numMoves(DinoStack *s);
extern void scanMoves(FILE *fp, DinoWidget w, int moves);
extern void printMoves(FILE *fp, DinoStack *s);
extern void scanStartPosition(FILE *fp, DinoWidget w);
extern void printStartPosition(FILE *fp, DinoWidget w);
extern void setStartPosition(DinoWidget w);

#ifdef DEBUG
extern void PrintCube(DinoWidget w);

#endif

#endif /* _DinoP_h */
