/*-
# X-BASED HEXAGONS
#
#  HexagonsP.h
#
###
#
#  Copyright (c) 1994 - 2008	David A. Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Private header file for Hexagons */

#ifndef _HexagonsP_h
#define _HexagonsP_h

#include "xwin.h"
#include "timer.h"
#include "Hexagons.h"

#ifdef WINVER
extern void DestroyPuzzle(HexagonsWidget w, HBRUSH brush);
extern void ResizePuzzle(HexagonsWidget w);
extern void SizePuzzle(HexagonsWidget w);
extern void InitializePuzzle(HexagonsWidget w, HBRUSH brush);
extern void ExposePuzzle(HexagonsWidget w);
extern void HidePuzzle(HexagonsWidget w);
extern void SelectPuzzle(HexagonsWidget w, const int x, const int y);
extern void ReleasePuzzle(HexagonsWidget w, const int x, const int y);
extern void GetPuzzle(HexagonsWidget w);
extern void WritePuzzle(HexagonsWidget w);
extern void UndoPuzzle(HexagonsWidget w);
extern void RedoPuzzle(HexagonsWidget w);
extern void ClearPuzzle(HexagonsWidget w);
extern void RandomizePuzzle(HexagonsWidget w);
extern void SolvePuzzle(HexagonsWidget w);
extern void CornersPuzzle(HexagonsWidget w);
extern void SpeedPuzzle(HexagonsWidget w);
extern void SlowPuzzle(HexagonsWidget w);
extern void SoundPuzzle(HexagonsWidget w);
extern void EnterPuzzle(HexagonsWidget w);
extern void LeavePuzzle(HexagonsWidget w);
extern int MovePuzzle(HexagonsWidget w, const int direction,
	const int control);

#else

/* This gets around C's inability to do inheritance */
typedef struct _HexagonsClassPart {
	int ignore;
} HexagonsClassPart;

typedef struct _HexagonsClassRec {
	CoreClassPart coreClass;
	HexagonsClassPart hexagonsClass;
} HexagonsClassRec;

extern HexagonsClassRec hexagonsClassRec;
#endif

#ifndef BUMPSOUND
#define BUMPSOUND "bump"
#endif

#define SYMBOL ':'

#define TR 0
#define RIGHT 1
#define BR 2
#define BL 3
#define LEFT 4
#define TL 5
#define COORD 6
#define TOP 6
#define BOTTOM 9
#define TRBL 0
#define TLBR 1
#define ROW 2
#define ROW_TYPES 3
#define LOW 0
#define HIGH 1
#define SPACES 2
#define BLOCKED (-3)
#define SPACE (-2)
#define FG_SHADES 3
#define BG_SHADES 5
#define MAX_SLICES 10

#define NORMAL 1
#define DOUBLE 2
#define INSTANT 3

typedef struct _MoveRecord {
#if 0
	int direction;
#endif
	unsigned char packed;   /* This makes assumptions on the data. */
} MoveRecord;

typedef struct _MoveStack {
	MoveRecord move;
	struct _MoveStack *previous, *next;
} MoveStack;

typedef struct _HexagonsStack {
	MoveStack *currMove, *lastMove, *firstMove;
	int count;
} HexagonsStack;

typedef struct _HexagonsPart {
	int        *tileOfPosition, spacePosition[SPACES];
	int         spaceRow[ROW_TYPES];
	int         currentPosition, currentRow[ROW_TYPES];
	Boolean     started, cheat, sound;
	Boolean     corners, mono, reverse, focus;
	Boolean     scoreOnly, versionOnly;
	int         delay, numSlices;
	int         base;
	int         sizeX, sizeY, sizeSize, sizeCenter;
	Point       offset, tileSize, puzzleSize;
	Point       delta, puzzleOffset, digitOffset;
	GC          textGC;
	GC          tileGC[FG_SHADES];
	GC          inverseGC[BG_SHADES];
	Pixmap      bufferTiles[2];
	TimeVal     oldTime;
#ifdef WINVER
	char        userName[81], scoreFile[81], bumpSound[81], picture[81];
#else
	int         menu, graphicsFormat, pixmapSize;
	char       *userName, *scoreFile, *bumpSound;
	char       *picture, *font;
	Boolean     install;
	Colormap    colormap, oldColormap;
	XImage     *image;
	XFontStruct *fontInfo;
	Pixel       foreground, background;
	Pixel       frameColor, tileColor, textColor;
	XtCallbackList select;
#endif
} HexagonsPart;

typedef struct _HexagonsRec {
	CorePart core;
	HexagonsPart hexagons;
} HexagonsRec;

extern int *startPosition;
extern void setPuzzle(HexagonsWidget w, int reason);
extern int MovePuzzleDir(HexagonsWidget w, const int direction,
	const int fast);

#if 0
/* For future auto-solver */
extern void SolveSomeTiles(HexagonsWidget w);
#endif
extern void DrawAllTiles(const HexagonsWidget w);
extern Boolean CheckSolved(const HexagonsWidget w);
extern void newMoves(HexagonsStack *s);
extern void deleteMoves(HexagonsStack *s);
extern void setMove(HexagonsStack *s, int direction);
extern void getMove(HexagonsStack *s, int *direction);
extern int madeMoves(HexagonsStack *s);
extern void flushMoves(HexagonsWidget w, HexagonsStack *s, Boolean undo);
extern int numMoves(HexagonsStack *s);
extern void scanMoves(FILE *fp, HexagonsWidget w, int moves);
extern void printMoves(FILE *fp, HexagonsStack *s);
extern void scanStartPosition(FILE *fp, HexagonsWidget w);
extern void printStartPosition(FILE *fp, HexagonsWidget w);
extern void setStartPosition(HexagonsWidget w);
extern int Row(HexagonsWidget w, const int pos);
extern int TrBl(HexagonsWidget w, const int pos, const int posRow);
extern int TlBr(HexagonsWidget w, const int pos, const int posRow);

#endif /* _HexagonsP_h */
